/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.EnumWeaponType;
import com.flansmod.common.guns.ShootableType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;

public class BulletType
extends ShootableType {
    public float speedMultiplier = 1.0f;
    public int flak = 0;
    public String flakParticles = "largesmoke";
    public boolean setEntitiesOnFire = false;
    public float livingProximityTrigger = -1.0f;
    public float driveableProximityTrigger = -1.0f;
    public float damageToTriggerer = 0.0f;
    public int primeDelay = 0;
    public int explodeParticles = 0;
    public String explodeParticleType = "largesmoke";
    public EnumWeaponType weaponType = EnumWeaponType.NONE;
    public String hitSound;
    public float hitSoundRange = 64.0f;
    public boolean hitSoundEnable = false;
    public boolean entityHitSoundEnable = false;
    public float penetratingPower = 1.0f;
    public float penetrationDecay = 0.0f;
    public float playerPenetrationEffectOnDamage = 0.0f;
    public float entityPenetrationEffectOnDamage = 0.0f;
    public float blockPenetrationEffectOnDamage = 0.0f;
    public float penetrationDecayEffectOnDamage = 0.0f;
    public float knockbackModifier;
    public boolean lockOnToPlanes = false;
    public boolean lockOnToVehicles = false;
    public boolean lockOnToMechas = false;
    public boolean lockOnToPlayers = false;
    public boolean lockOnToLivings = false;
    public float maxLockOnAngle = 45.0f;
    public float lockOnForce = 1.0f;
    public int maxDegreeOfMissile = 20;
    public int tickStartHoming = 5;
    public boolean enableSACLOS = false;
    public int maxDegreeOfSACLOS = 5;
    public int maxRangeOfMissile = 150;
    public boolean manualGuidance = false;
    public int lockOnFuse = 10;
    public ArrayList<PotionEffect> hitEffects = new ArrayList();
    public int numBullets = -1;
    public float bulletSpread = -1.0f;
    public float dragInAir = 0.99f;
    public float dragInWater = 0.8f;
    public boolean canSpotEntityDriveable = false;
    public int maxRange = -1;
    public boolean shootForSettingPos = false;
    public int shootForSettingPosHeight = 100;
    public boolean isDoTopAttack = false;
    public int smokeTime = 0;
    public String smokeParticleType = "explode";
    public ArrayList<PotionEffect> smokeEffects = new ArrayList();
    public float smokeRadius = 5.0f;
    public boolean TVguide = true;
    public boolean VLS = false;
    public int VLSTime = 0;
    public boolean fixedDirection = false;
    public float turnRadius = 3.0f;
    public String boostPhaseParticle;
    public float trackPhaseSpeed = 2.0f;
    public float trackPhaseTurn = 0.2f;
    public boolean torpedo = false;
    public boolean fancyDescription = true;
    public boolean laserGuidance = false;
    public float blockHitFXScale;
    public static List<BulletType> bullets = new ArrayList<BulletType>();

    public BulletType(TypeFile file) {
        super(file);
        this.texture = "defaultBullet";
        this.bounciness = 0.0f;
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        if (this.shortName != null && this.isValid) {
            bullets.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            this.flak = ConfigUtils.configInt(config, "FlakParticles", this.flak);
            this.flakParticles = ConfigUtils.configString(config, "FlakParticleType", this.flakParticles);
            this.setEntitiesOnFire = ConfigUtils.configBool(config, "SetEntitiesOnFire", this.setEntitiesOnFire);
            this.hitSoundEnable = ConfigUtils.configBool(config, "HitSoundEnable", this.hitSoundEnable);
            this.entityHitSoundEnable = ConfigUtils.configBool(config, "EntityHitSoundEnable", this.entityHitSoundEnable);
            this.hitSound = ConfigUtils.configSound(this.packName, config, "HitSound", this.hitSound);
            this.hitSoundRange = ConfigUtils.configFloat(config, "HitSoundRange", this.hitSoundRange);
            boolean pens = ConfigUtils.configBool(config, "Penetrates", true);
            this.penetratingPower = pens ? 1.0f : 0.7f;
            this.penetratingPower = ConfigUtils.configFloat(config, new String[]{"Penetration", "PenetratingPower"}, this.penetratingPower);
            this.penetrationDecay = ConfigUtils.configFloat(config, "PenetrationDecay", this.penetrationDecay);
            this.playerPenetrationEffectOnDamage = ConfigUtils.configFloat(config, "PlayerPenetrationDamageEffect", this.playerPenetrationEffectOnDamage);
            this.entityPenetrationEffectOnDamage = ConfigUtils.configFloat(config, "EntityPenetrationDamageEffect", this.entityPenetrationEffectOnDamage);
            this.blockPenetrationEffectOnDamage = ConfigUtils.configFloat(config, "BlockPenetrationDamageEffect", this.blockPenetrationEffectOnDamage);
            this.penetrationDecayEffectOnDamage = ConfigUtils.configFloat(config, "PenetrationDecayDamageEffect", this.penetrationDecayEffectOnDamage);
            this.dragInAir = ConfigUtils.configFloat(config, "DragInAir", this.dragInAir);
            this.dragInAir = Math.max(0.0f, Math.min(1.0f, this.dragInAir));
            this.dragInWater = ConfigUtils.configFloat(config, "DragInWater", this.dragInWater);
            this.dragInWater = Math.max(0.0f, Math.min(1.0f, this.dragInWater));
            this.numBullets = ConfigUtils.configInt(config, "NumBullets", this.numBullets);
            this.bulletSpread = ConfigUtils.configFloat(config, new String[]{"Accuracy", "Spread"}, this.bulletSpread);
            this.livingProximityTrigger = ConfigUtils.configFloat(config, "LivingProximityTrigger", this.livingProximityTrigger);
            this.driveableProximityTrigger = ConfigUtils.configFloat(config, "VehicleProximityTrigger", this.driveableProximityTrigger);
            this.damageToTriggerer = ConfigUtils.configFloat(config, "DamageToTriggerer", this.damageToTriggerer);
            this.primeDelay = ConfigUtils.configInt(config, new String[]{"PrimeDelay", "TriggerDelay"}, this.primeDelay);
            this.explodeParticles = ConfigUtils.configInt(config, "NumExplodeParticles", this.explodeParticles);
            this.explodeParticleType = ConfigUtils.configString(config, "ExplodeParticles", this.explodeParticleType);
            this.smokeTime = ConfigUtils.configInt(config, "SmokeTime", this.smokeTime);
            this.smokeParticleType = ConfigUtils.configString(config, "SmokeParticles", this.smokeParticleType);
            ArrayList<String[]> lines = ConfigUtils.getSplitsFromKey(config, new String[]{"SmokeEffect"});
            for (String[] stringArray : lines) {
                try {
                    this.smokeEffects.add(BulletType.getPotionEffect(stringArray));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Couldn't read PotionEffect for bullet", stringArray, ex);
                }
            }
            this.smokeRadius = ConfigUtils.configFloat(config, "SmokeRadius", this.smokeRadius);
            this.VLS = ConfigUtils.configBool(config, new String[]{"VLS", "HasDeadZone"}, this.VLS);
            this.VLSTime = ConfigUtils.configInt(config, "DeadZoneTime", this.VLSTime);
            this.fixedDirection = ConfigUtils.configBool(config, "FixedTrackDirection", this.fixedDirection);
            this.turnRadius = ConfigUtils.configFloat(config, "GuidedTurnRadius", this.turnRadius);
            this.trackPhaseSpeed = ConfigUtils.configFloat(config, "GuidedPhaseSpeed", this.trackPhaseSpeed);
            this.trackPhaseTurn = ConfigUtils.configFloat(config, "GuidedPhaseTurnSpeed", this.trackPhaseTurn);
            this.boostPhaseParticle = ConfigUtils.configString(config, "BoostParticle", this.boostPhaseParticle);
            this.torpedo = ConfigUtils.configBool(config, "Torpedo", this.torpedo);
            ArrayList<String[]> splits = ConfigUtils.getSplitsFromKey(config, new String[]{"Bomb"});
            for (String[] split : splits) {
                if (split.length != 1 && (split.length != 2 || !split[1].equalsIgnoreCase("true"))) continue;
                this.weaponType = EnumWeaponType.BOMB;
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"Shell"});
            for (String[] split : splits) {
                if (split.length != 1 && (split.length != 2 || !split[1].equalsIgnoreCase("true"))) continue;
                this.weaponType = EnumWeaponType.SHELL;
            }
            splits = ConfigUtils.getSplitsFromKey(config, new String[]{"Missile"});
            for (String[] split : splits) {
                if (split.length != 1 && (split.length != 2 || !split[1].equalsIgnoreCase("true"))) continue;
                this.weaponType = EnumWeaponType.MISSILE;
            }
            if (config.containsKey("WeaponType")) {
                String string = ConfigUtils.configString(config, "WeaponType", "Bomb");
                try {
                    if (string != null) {
                        this.weaponType = EnumWeaponType.valueOf(string.toUpperCase());
                    }
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "WeaponType not known in BulletType", new String[]{"WeaponType", string}, ex);
                }
            }
            if (config.containsKey("LockOnToDriveables")) {
                this.lockOnToVehicles = this.lockOnToMechas = ConfigUtils.configBool(config, "LockOnToDriveables", this.lockOnToVehicles);
                this.lockOnToPlanes = this.lockOnToMechas;
            }
            this.lockOnToVehicles = ConfigUtils.configBool(config, "LockOnToVehicles", this.lockOnToVehicles);
            this.lockOnToPlanes = ConfigUtils.configBool(config, "LockOnToPlanes", this.lockOnToPlanes);
            this.lockOnToMechas = ConfigUtils.configBool(config, "LockOnToMechas", this.lockOnToMechas);
            this.lockOnToPlayers = ConfigUtils.configBool(config, "LockOnToPlayers", this.lockOnToPlayers);
            this.lockOnToLivings = ConfigUtils.configBool(config, "LockOnToLivings", this.lockOnToLivings);
            this.maxLockOnAngle = ConfigUtils.configFloat(config, "MaxLockOnAngle", this.maxLockOnAngle);
            this.lockOnForce = ConfigUtils.configFloat(config, new String[]{"LockOnForce", "TurningForce"}, this.lockOnForce);
            this.maxDegreeOfMissile = ConfigUtils.configInt(config, "MaxDegreeOfLockOnMissile", this.maxDegreeOfMissile);
            this.tickStartHoming = ConfigUtils.configInt(config, "TickStartHoming", this.tickStartHoming);
            this.enableSACLOS = ConfigUtils.configBool(config, "EnableSACLOS", this.enableSACLOS);
            this.maxDegreeOfSACLOS = ConfigUtils.configInt(config, "MaxDegreeOFSACLOS", this.maxDegreeOfSACLOS);
            this.maxRangeOfMissile = ConfigUtils.configInt(config, "MaxRangeOfMissile", this.maxRangeOfMissile);
            this.canSpotEntityDriveable = ConfigUtils.configBool(config, "CanSpotEntityDriveable", this.canSpotEntityDriveable);
            this.shootForSettingPos = ConfigUtils.configBool(config, "ShootForSettingPos", this.shootForSettingPos);
            this.shootForSettingPosHeight = ConfigUtils.configInt(config, "ShootForSettingPosHeight", this.shootForSettingPosHeight);
            this.isDoTopAttack = ConfigUtils.configBool(config, "IsDoTopAttack", this.isDoTopAttack);
            this.knockbackModifier = ConfigUtils.configFloat(config, "KnockbackModifier", this.knockbackModifier);
            lines = ConfigUtils.getSplitsFromKey(config, new String[]{"PotionEffect"});
            for (String[] split : lines) {
                try {
                    this.hitEffects.add(BulletType.getPotionEffect(split));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Couldn't read PotionEffect for bullet", split, ex);
                }
            }
            this.manualGuidance = ConfigUtils.configBool(config, "ManualGuidance", this.manualGuidance);
            this.laserGuidance = ConfigUtils.configBool(config, "LaserGuidance", this.laserGuidance);
            this.lockOnFuse = ConfigUtils.configInt(config, "LockOnFuse", this.lockOnFuse);
            this.maxRange = ConfigUtils.configInt(config, "MaxRange", this.maxRange);
            this.fancyDescription = ConfigUtils.configBool(config, "FancyDescription", this.fancyDescription);
            this.speedMultiplier = ConfigUtils.configFloat(config, "BulletSpeedMultiplier", this.speedMultiplier);
            this.blockHitFXScale = ConfigUtils.configFloat(config, "BlockHitFXScale", (float)(Math.log(this.explosionRadius + 2.0f) / Math.log(2.15) + 0.05));
        }
        catch (Exception e) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error reading bullet config", null, e);
            this.isValid = false;
        }
    }

    public static BulletType getBullet(String s) {
        for (BulletType bullet : bullets) {
            if (!bullet.shortName.equals(s)) continue;
            return bullet;
        }
        return null;
    }

    public static BulletType getBullet(Item item) {
        for (BulletType bullet : bullets) {
            if (bullet.item != item) continue;
            return bullet;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelBase.class);
    }
}

