/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.guns;

import com.flansmod.client.model.ModelAAGun;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.item.ItemStack;

public class AAGunType
extends InfoType {
    public List<BulletType> ammo = new ArrayList<BulletType>();
    public int reloadTime;
    public int recoil = 5;
    public int accuracy;
    public int damage;
    public int shootDelay;
    public int numBarrels;
    public boolean fireAlternately;
    public int health;
    public int gunnerX;
    public int gunnerY;
    public int gunnerZ;
    public String shootSound;
    public String reloadSound;
    public ModelAAGun model;
    public float topViewLimit = 75.0f;
    public float bottomViewLimit = 0.0f;
    public int[] barrelX;
    public int[] barrelY;
    public int[] barrelZ;
    public boolean targetMobs = false;
    public boolean targetPlayers = false;
    public boolean targetVehicles = false;
    public boolean targetPlanes = false;
    public boolean targetMechas = false;
    public float targetRange = 10.0f;
    public boolean shareAmmo = false;
    public boolean canShootHomingMissile = false;
    public int countExplodeAfterShoot = -1;
    public boolean isDropThis = true;
    public static List<AAGunType> infoTypes = new ArrayList<AAGunType>();

    public AAGunType(TypeFile file) {
        super(file);
    }

    @Override
    protected void preRead(TypeFile file) {
    }

    @Override
    public void postRead(TypeFile file) {
        if (this.shortName != null && this.isValid) {
            infoTypes.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            ArrayList<String[]> splits;
            if (FMLCommonHandler.instance().getSide().isClient()) {
                this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelAAGun.class);
            }
            this.texture = ConfigUtils.configString(config, "Texture", this.texture);
            this.damage = ConfigUtils.configInt(config, "Damage", this.damage);
            this.reloadTime = ConfigUtils.configInt(config, "ReloadTime", this.reloadTime);
            this.recoil = ConfigUtils.configInt(config, "Recoil", this.recoil);
            this.accuracy = ConfigUtils.configInt(config, "Accuracy", this.accuracy);
            this.shootDelay = ConfigUtils.configInt(config, "ShootDelay", this.shootDelay);
            this.shootSound = ConfigUtils.configAASound(this.packName, config, "ShootSound", this.shootSound);
            this.reloadSound = ConfigUtils.configAASound(this.packName, config, "ReloadSound", this.reloadSound);
            this.fireAlternately = ConfigUtils.configBool(config, "FireAlternately", this.fireAlternately);
            this.numBarrels = ConfigUtils.configInt(config, "NumBarrels", this.numBarrels);
            this.barrelX = new int[this.numBarrels];
            this.barrelY = new int[this.numBarrels];
            this.barrelZ = new int[this.numBarrels];
            try {
                splits = ConfigUtils.getSplitsFromKey(config, new String[]{"Barrel"});
                if (splits.size() != this.numBarrels) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Unexpected number of Barrel positions given", null, null);
                }
                for (String[] split : splits) {
                    try {
                        int id = Integer.parseInt(split[1]);
                        this.barrelX[id] = Integer.parseInt(split[2]);
                        this.barrelY[id] = Integer.parseInt(split[3]);
                        this.barrelZ[id] = Integer.parseInt(split[4]);
                    }
                    catch (Exception ex) {
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Reading barrel failed", split, ex);
                    }
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Configuring barrels failed", null, ex);
            }
            this.health = ConfigUtils.configInt(config, "Health", this.health);
            this.topViewLimit = ConfigUtils.configFloat(config, "TopViewLimit", this.topViewLimit);
            this.bottomViewLimit = ConfigUtils.configFloat(config, "BottomViewLimit", this.bottomViewLimit);
            try {
                splits = ConfigUtils.getSplitsFromKey(config, new String[]{"Ammo"});
                for (String[] split : splits) {
                    if (split.length == 2 && split[1] != null) {
                        BulletType type = BulletType.getBullet(split[1]);
                        if (type != null) {
                            this.ammo.add(type);
                            continue;
                        }
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Unrecognised ammo type", split, null);
                        continue;
                    }
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Invalid Ammo line", split, null);
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding ammunition failed", null, ex);
            }
            try {
                String[] split = ConfigUtils.getSplitFromKey(config, "GunnerPos");
                if (split != null) {
                    this.gunnerX = Integer.parseInt(split[1]);
                    this.gunnerY = Integer.parseInt(split[2]);
                    this.gunnerZ = Integer.parseInt(split[3]);
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Setting gunner position failed", null, ex);
            }
            this.targetMobs = ConfigUtils.configBool(config, "TargetMobs", this.targetMobs);
            this.targetPlayers = ConfigUtils.configBool(config, "TargetPlayers", this.targetPlayers);
            this.targetVehicles = ConfigUtils.configBool(config, "TargetVehicles", this.targetVehicles);
            this.targetPlanes = ConfigUtils.configBool(config, "TargetPlanes", this.targetPlanes);
            this.targetMechas = ConfigUtils.configBool(config, "TargetMechas", this.targetMechas);
            if (config.containsKey("TargetDriveables")) {
                this.targetPlanes = this.targetVehicles = ConfigUtils.configBool(config, "TargetDriveables", false);
                this.targetMechas = this.targetVehicles;
            }
            this.shareAmmo = ConfigUtils.configBool(config, "ShareAmmo", this.shareAmmo);
            this.targetRange = ConfigUtils.configFloat(config, "TargetRange", this.targetRange);
            this.canShootHomingMissile = ConfigUtils.configBool(config, "CanShootHomingMissile", this.canShootHomingMissile);
            this.countExplodeAfterShoot = ConfigUtils.configInt(config, "CountExplodeAfterShoot", this.countExplodeAfterShoot);
            this.isDropThis = ConfigUtils.configBool(config, "IsDropThis", this.isDropThis);
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error occurred when reading AAGun", null, ex);
            this.isValid = false;
        }
    }

    public boolean isAmmo(BulletType type) {
        return this.ammo.contains(type);
    }

    public boolean isAmmo(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemBullet && this.isAmmo(((ItemBullet)stack.func_77973_b()).type);
    }

    public static AAGunType getAAGun(String s) {
        for (AAGunType gun : infoTypes) {
            if (!gun.shortName.equals(s)) continue;
            return gun;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelAAGun.class);
    }

    @Override
    public float GetRecommendedScale() {
        return 50.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ModelBase GetModel() {
        return this.model;
    }
}

