/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables.mechas;

import com.flansmod.client.model.ModelMecha;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import java.util.ArrayList;

public class MechaType
extends DriveableType {
    public float turnLeftModifier = 1.0f;
    public float turnRightModifier = 1.0f;
    public float moveSpeed = 1.0f;
    public boolean squashMobs = false;
    public int stepHeight = 0;
    public float jumpHeight = 1.0f;
    public float jumpVelocity = 1.0f;
    public float rotateSpeed = 10.0f;
    public Vector3f leftArmOrigin;
    public Vector3f rightArmOrigin;
    public float armLength = 1.0f;
    public float legLength = 1.0f;
    public float heldItemScale = 1.0f;
    public float height = 3.0f;
    public float width = 2.0f;
    public float chassisHeight = 1.0f;
    public float reach = 10.0f;
    public boolean damageBlocksFromFalling = true;
    public float blockDamageFromFalling = 1.0f;
    public boolean takeFallDamage = true;
    public float fallDamageMultiplier = 1.0f;
    public float legSwingLimit = 2.0f;
    public boolean limitHeadTurn = false;
    public float limitHeadTurnValue = 90.0f;
    public float legSwingTime = 5.0f;
    public float upperArmLimit = 90.0f;
    public float lowerArmLimit = 90.0f;
    public float leftHandModifierX = 0.0f;
    public float leftHandModifierY = 0.0f;
    public float leftHandModifierZ = 0.0f;
    public float rightHandModifierX = 0.0f;
    public float rightHandModifierY = 0.0f;
    public float rightHandModifierZ = 0.0f;
    public ArrayList<LegNode> legNodes = new ArrayList();
    public float legAnimSpeed = 0.0f;
    public String stompSound = "";
    public int stompSoundLength = 0;
    public float stompRangeLower = 0.0f;
    public float stompRangeUpper = 0.0f;
    public boolean restrictInventoryInput = false;
    public boolean allowMechaToolsInRestrictedInv = true;
    public static ArrayList<MechaType> types = new ArrayList();

    public MechaType(TypeFile file) {
        super(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        if (this.shortName != null && this.isValid) {
            types.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            this.turnLeftModifier = ConfigUtils.configFloat(config, "TurnLeftSpeed", this.turnLeftModifier);
            this.turnRightModifier = ConfigUtils.configFloat(config, "TurnRightSpeed", this.turnRightModifier);
            this.moveSpeed = ConfigUtils.configFloat(config, "MoveSpeed", this.moveSpeed);
            this.squashMobs = ConfigUtils.configBool(config, "SquashMobs", this.squashMobs);
            this.stepHeight = ConfigUtils.configInt(config, "StepHeight", this.stepHeight);
            this.jumpHeight = ConfigUtils.configFloat(config, "JumpHeight", -99.0f);
            this.jumpVelocity = this.jumpHeight == -99.0f ? 1.0f : (float)Math.sqrt(Math.abs(9.81f * (this.jumpHeight + 0.2f) / 200.0f));
            this.rotateSpeed = ConfigUtils.configFloat(config, "RotateSpeed", this.rotateSpeed);
            this.stompSound = ConfigUtils.configDriveableSound(this.packName, config, "StompSound", this.stompSound);
            this.stompSoundLength = ConfigUtils.configInt(config, "StompSoundLength", this.stompSoundLength);
            this.stompRangeLower = ConfigUtils.configFloat(config, "StompRangeLower", this.stompRangeLower);
            this.stompRangeUpper = ConfigUtils.configFloat(config, "StompRangeUpper", this.stompRangeUpper);
            String[] split = null;
            try {
                split = ConfigUtils.getSplitFromKey(config, new String[]{"LeftArmOrigin"});
                if (split != null) {
                    this.leftArmOrigin = new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f);
                }
                if ((split = ConfigUtils.getSplitFromKey(config, new String[]{"RightArmOrigin"})) != null) {
                    this.rightArmOrigin = new Vector3f(Float.parseFloat(split[1]) / 16.0f, Float.parseFloat(split[2]) / 16.0f, Float.parseFloat(split[3]) / 16.0f);
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding arm origin failed", split, ex);
            }
            this.armLength = ConfigUtils.configFloat(config, "ArmLength", this.armLength) / 16.0f;
            this.legLength = ConfigUtils.configFloat(config, "LegLength", this.legLength) / 16.0f;
            this.heldItemScale = ConfigUtils.configFloat(config, "HeldItemScale", this.heldItemScale);
            this.height = ConfigUtils.configFloat(config, "Height", this.height * 16.0f) / 16.0f;
            this.width = ConfigUtils.configFloat(config, "Width", this.width * 16.0f) / 16.0f;
            this.chassisHeight = (float)Math.floor(ConfigUtils.configFloat(config, "ChassisHeight", this.chassisHeight * 16.0f)) / 16.0f;
            this.fallDamageMultiplier = ConfigUtils.configFloat(config, "FallDamageMultiplier", this.fallDamageMultiplier);
            this.blockDamageFromFalling = ConfigUtils.configFloat(config, "BlockDamageFromFalling", this.blockDamageFromFalling);
            this.reach = ConfigUtils.configFloat(config, "Reach", this.reach);
            this.takeFallDamage = ConfigUtils.configBool(config, "TakeFallDamage", this.takeFallDamage);
            this.damageBlocksFromFalling = ConfigUtils.configBool(config, "DamageBlocksFromFalling", this.damageBlocksFromFalling);
            this.legSwingLimit = ConfigUtils.configFloat(config, "LegSwingLimit", this.legSwingLimit);
            try {
                split = ConfigUtils.getSplitFromKey(config, "LimitHeadTurn");
                if (split != null) {
                    this.limitHeadTurn = Boolean.parseBoolean(split[1].toLowerCase());
                    this.limitHeadTurnValue = Float.parseFloat(split[2]);
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Setting head turn limit failed", split, ex);
            }
            this.legSwingTime = ConfigUtils.configFloat(config, "LegSwingTime", this.legSwingTime);
            this.upperArmLimit = ConfigUtils.configFloat(config, "UpperArmLimit", this.upperArmLimit);
            this.lowerArmLimit = ConfigUtils.configFloat(config, "LowerArmLimit", this.lowerArmLimit);
            try {
                split = ConfigUtils.getSplitFromKey(config, "LeftHandModifier");
                if (split != null) {
                    this.leftHandModifierX = Float.parseFloat(split[1]) / 16.0f;
                    this.leftHandModifierY = Float.parseFloat(split[2]) / 16.0f;
                    this.leftHandModifierZ = Float.parseFloat(split[3]) / 16.0f;
                }
                if ((split = ConfigUtils.getSplitFromKey(config, "RightHandModifier")) != null) {
                    this.rightHandModifierX = Float.parseFloat(split[1]) / 16.0f;
                    this.rightHandModifierY = Float.parseFloat(split[2]) / 16.0f;
                    this.rightHandModifierZ = Float.parseFloat(split[3]) / 16.0f;
                }
            }
            catch (Exception ex) {
                FlansMod.logPackError(file.name, this.packName, this.shortName, "Setting Hand Modifiers failed", split, ex);
            }
            ArrayList<String[]> splits = ConfigUtils.getSplitsFromKey(config, new String[]{"LegNode"});
            for (String[] ssplit : splits) {
                try {
                    LegNode node = new LegNode();
                    node.rotation = Integer.parseInt(ssplit[1]);
                    node.lowerBound = Float.parseFloat(ssplit[2]);
                    node.upperBound = Float.parseFloat(ssplit[3]);
                    node.speed = Integer.parseInt(ssplit[4]);
                    node.legPart = Integer.parseInt(ssplit[5]);
                    this.legNodes.add(node);
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding LegNode failed", ssplit, ex);
                }
            }
            this.legAnimSpeed = ConfigUtils.configFloat(config, "LegAnimSpeed", this.legAnimSpeed);
            this.restrictInventoryInput = ConfigUtils.configBool(config, "RestrictInventoryInput", this.restrictInventoryInput);
            this.allowMechaToolsInRestrictedInv = ConfigUtils.configBool(config, "AllowMechaToolsInRestrictedInv", this.allowMechaToolsInRestrictedInv);
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal error occurred while reading Mecha Type", null, ex);
            this.isValid = false;
        }
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelMecha.class);
    }

    public static MechaType getMecha(String find) {
        for (MechaType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    public class LegNode {
        public int rotation;
        public float lowerBound;
        public float upperBound;
        public int speed;
        public int legPart;
    }
}

