/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelPlane;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumPlaneMode;
import com.flansmod.common.driveables.Propeller;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import com.flansmod.utils.ConfigMap;
import com.flansmod.utils.ConfigUtils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public class PlaneType
extends DriveableType {
    public EnumPlaneMode mode = EnumPlaneMode.PLANE;
    public float lookDownModifier = 1.0f;
    public float lookUpModifier = 1.0f;
    public float rollLeftModifier = 1.0f;
    public float rollRightModifier = 1.0f;
    public float turnLeftModifier = 1.0f;
    public float turnRightModifier = 1.0f;
    public float restingPitch = 0.0f;
    public boolean spinWithoutTail = false;
    public boolean heliThrottlePull = true;
    public boolean newFlightControl = false;
    public float lift = 1.0f;
    public float takeoffSpeed = 0.5f;
    public float maxSpeed = 2.0f;
    public boolean supersonic = false;
    public float wingArea = 1.0f;
    public float maxThrust = 50.0f;
    public float mass = 1000.0f;
    public float emptyDrag = 1.0f;
    public int planeShootDelay;
    public int planeBombDelay;
    public Vector3f wingPos1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingPos2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingRot1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingRot2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingRotRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingWheelPos1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingWheelPos2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingWheelRot1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingWheelRot2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingWheelRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f wingWheelRotRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f bodyWheelPos1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f bodyWheelPos2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f bodyWheelRot1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f bodyWheelRot2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f bodyWheelRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f bodyWheelRotRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f tailWheelPos1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f tailWheelPos2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f tailWheelRot1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f tailWheelRot2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f tailWheelRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f tailWheelRotRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorPos1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorPos2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRot1 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRot2 = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRotRate = new Vector3f(0.0f, 0.0f, 0.0f);
    public ArrayList<Propeller> propellers = new ArrayList();
    public ArrayList<Propeller> heliPropellers = new ArrayList();
    public ArrayList<Propeller> heliTailPropellers = new ArrayList();
    public boolean hasGear = false;
    public boolean hasDoor = false;
    public boolean hasWing = false;
    public boolean foldWingForLand = false;
    public boolean flyWithOpenDoor = false;
    public boolean autoOpenDoorsNearGround = true;
    public boolean autoDeployLandingGearNearGround = true;
    public boolean valkyrie = false;
    public boolean invInflight = true;
    public static ArrayList<PlaneType> types = new ArrayList();

    public PlaneType(TypeFile file) {
        super(file);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        if (this.shortName != null && this.isValid) {
            types.add(this);
        }
    }

    @Override
    protected void read(ConfigMap config, TypeFile file) {
        super.read(config, file);
        try {
            this.mode = EnumPlaneMode.getMode(ConfigUtils.configString(config, "Mode", "Plane"));
            this.newFlightControl = ConfigUtils.configBool(config, "NewFlightControl", this.newFlightControl);
            this.turnLeftModifier = ConfigUtils.configFloat(config, "TurnLeftSpeed", this.turnLeftModifier);
            this.turnRightModifier = ConfigUtils.configFloat(config, "TurnRightSpeed", this.turnRightModifier);
            this.lookUpModifier = ConfigUtils.configFloat(config, "LookUpSpeed", this.lookUpModifier);
            this.lookDownModifier = ConfigUtils.configFloat(config, "LookDownSpeed", this.lookDownModifier);
            this.rollLeftModifier = ConfigUtils.configFloat(config, "RollLeftSpeed", this.rollLeftModifier);
            this.rollRightModifier = ConfigUtils.configFloat(config, "RollRightSpeed", this.rollRightModifier);
            this.lift = ConfigUtils.configFloat(config, "Lift", this.lift);
            this.takeoffSpeed = ConfigUtils.configFloat(config, "TakeoffSpeed", this.takeoffSpeed);
            this.maxSpeed = ConfigUtils.configFloat(config, "MaxSpeed", this.maxSpeed);
            this.supersonic = ConfigUtils.configBool(config, "Supersonic", this.supersonic);
            this.maxThrust = ConfigUtils.configFloat(config, "MaxThrust", this.maxThrust);
            this.mass = ConfigUtils.configFloat(config, "Mass", this.mass);
            this.wingArea = ConfigUtils.configFloat(config, "WingArea", this.wingArea);
            this.heliThrottlePull = ConfigUtils.configBool(config, "HeliThrottlePull", this.heliThrottlePull);
            this.emptyDrag = ConfigUtils.configFloat(config, "EmptyDrag", this.emptyDrag);
            this.planeShootDelay = ConfigUtils.configInt(config, "ShootDelay", this.planeShootDelay);
            this.planeBombDelay = ConfigUtils.configInt(config, "BombDelay", this.planeBombDelay);
            ArrayList<String[]> splits = ConfigUtils.getSplitsFromKey(config, new String[]{"HeliPropeller", "Propeller", "HeliTailPropeller"});
            for (String[] split : splits) {
                try {
                    Propeller propeller = new Propeller(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), EnumDriveablePart.getPart(split[5]), PartType.getPart(split[6]));
                    if (split[0].contains("HeliTailPropeller")) {
                        this.heliTailPropellers.add(propeller);
                    } else if (split[0].contains("HeliPropeller")) {
                        this.heliPropellers.add(propeller);
                    } else {
                        this.propellers.add(propeller);
                    }
                    if (propeller.itemType == null) {
                        FlansMod.logPackError(file.name, this.packName, this.shortName, "Couldn't find item for propeller, not adding to recipe.", split, null);
                        continue;
                    }
                    this.driveableRecipe.add(new ItemStack(propeller.itemType.item));
                }
                catch (Exception ex) {
                    FlansMod.logPackError(file.name, this.packName, this.shortName, "Adding propeller failed", split, ex);
                }
            }
            this.hasFlare = ConfigUtils.configBool(config, "HasFlare", this.hasFlare);
            this.flareDelay = Math.max(1, ConfigUtils.configInt(config, "FlareDelay", this.flareDelay));
            this.timeFlareUsing = ConfigUtils.configInt(config, "TimeFlareUsing", this.timeFlareUsing);
            this.timeFlareUsing = this.timeFlareUsing <= 0 ? 1 : this.timeFlareUsing;
            this.engineSoundLength = ConfigUtils.configInt(config, "PropSoundLength", this.engineSoundLength);
            this.engineSound = ConfigUtils.configDriveableSound(this.packName, config, "PropSound", this.engineSound);
            this.shootSoundPrimary = ConfigUtils.configDriveableSound(this.packName, config, "ShootSound", this.shootSoundPrimary);
            this.shootSoundSecondary = ConfigUtils.configDriveableSound(this.packName, config, "BombSound", this.shootSoundSecondary);
            this.hasGear = ConfigUtils.configBool(config, "HasGear", this.hasGear);
            this.hasDoor = ConfigUtils.configBool(config, "HasDoor", this.hasDoor);
            this.hasWing = ConfigUtils.configBool(config, "HasWing", this.hasWing);
            this.foldWingForLand = ConfigUtils.configBool(config, "FoldWingForLand", this.foldWingForLand);
            this.flyWithOpenDoor = ConfigUtils.configBool(config, "FlyWithOpenDoor", this.flyWithOpenDoor);
            this.autoOpenDoorsNearGround = ConfigUtils.configBool(config, "AutoOpenDoorsNearGround", this.autoOpenDoorsNearGround);
            this.autoDeployLandingGearNearGround = ConfigUtils.configBool(config, "AutoDeployLandingGearNearGround", this.autoDeployLandingGearNearGround);
            this.restingPitch = ConfigUtils.configFloat(config, "RestingPitch", this.restingPitch);
            this.spinWithoutTail = ConfigUtils.configBool(config, "SpinWithoutTail", this.spinWithoutTail);
            this.valkyrie = ConfigUtils.configBool(config, "Valkyrie", this.valkyrie);
            this.wingPos1 = ConfigUtils.configVector(config, "WingPosition1", this.wingPos1);
            this.wingPos2 = ConfigUtils.configVector(config, "WingPosition2", this.wingPos2);
            this.wingRot1 = ConfigUtils.configVector(config, "WingRotation1", this.wingRot1);
            this.wingRot2 = ConfigUtils.configVector(config, "WingRotation2", this.wingRot2);
            this.wingRate = ConfigUtils.configVector(config, "WingRate", this.wingRate);
            this.wingRotRate = ConfigUtils.configVector(config, "WingRotRate", this.wingRotRate);
            this.wingWheelPos1 = ConfigUtils.configVector(config, "WingWheelPosition1", this.wingWheelPos1);
            this.wingWheelPos2 = ConfigUtils.configVector(config, "WingWheelPosition2", this.wingWheelPos2);
            this.wingWheelRot1 = ConfigUtils.configVector(config, "WingWheelRotation1", this.wingWheelRot1);
            this.wingWheelRot2 = ConfigUtils.configVector(config, "WingWheelRotation2", this.wingWheelRot2);
            this.wingWheelRate = ConfigUtils.configVector(config, "WingWheelRate", this.wingWheelRate);
            this.wingWheelRotRate = ConfigUtils.configVector(config, "WingWheelRotRate", this.wingWheelRotRate);
            this.bodyWheelPos1 = ConfigUtils.configVector(config, "BodyWheelPosition1", this.bodyWheelPos1);
            this.bodyWheelPos2 = ConfigUtils.configVector(config, "BodyWheelPosition2", this.bodyWheelPos2);
            this.bodyWheelRot1 = ConfigUtils.configVector(config, "BodyWheelRotation1", this.bodyWheelRot1);
            this.bodyWheelRot2 = ConfigUtils.configVector(config, "BodyWheelRotation2", this.bodyWheelRot2);
            this.bodyWheelRate = ConfigUtils.configVector(config, "BodyWheelRate", this.bodyWheelRate);
            this.bodyWheelRotRate = ConfigUtils.configVector(config, "BodyWheelRotRate", this.bodyWheelRotRate);
            this.tailWheelPos1 = ConfigUtils.configVector(config, "TailWheelPosition1", this.tailWheelPos1);
            this.tailWheelPos2 = ConfigUtils.configVector(config, "TailWheelPosition2", this.tailWheelPos2);
            this.tailWheelRot1 = ConfigUtils.configVector(config, "TailWheelRotation1", this.tailWheelRot1);
            this.tailWheelRot2 = ConfigUtils.configVector(config, "TailWheelRotation2", this.tailWheelRot2);
            this.tailWheelRate = ConfigUtils.configVector(config, "TailWheelRate", this.tailWheelRate);
            this.tailWheelRotRate = ConfigUtils.configVector(config, "TailWheelRotRate", this.tailWheelRotRate);
            this.doorPos1 = ConfigUtils.configVector(config, "DoorPosition1", this.doorPos1);
            this.doorPos2 = ConfigUtils.configVector(config, "DoorPosition2", this.doorPos2);
            this.doorRot1 = ConfigUtils.configVector(config, "DoorRotation1", this.doorRot1);
            this.doorRot2 = ConfigUtils.configVector(config, "DoorRotation2", this.doorRot2);
            this.doorRate = ConfigUtils.configVector(config, "DoorRate", this.doorRate);
            this.doorRotRate = ConfigUtils.configVector(config, "DoorRotRate", this.doorRotRate);
            this.invInflight = ConfigUtils.configBool(config, "InflightInventory", this.invInflight);
        }
        catch (Exception ex) {
            FlansMod.logPackError(file.name, this.packName, this.shortName, "Fatal Error! Reading PlaneType failed", null, ex);
            this.isValid = true;
        }
    }

    @Override
    public int numEngines() {
        switch (this.mode) {
            case VTOL: {
                return Math.max(this.propellers.size(), this.heliPropellers.size());
            }
            case PLANE: {
                return this.propellers.size();
            }
            case HELI: {
                return this.heliPropellers.size();
            }
        }
        return 1;
    }

    @Override
    public ArrayList<ItemStack> getItemsRequired(DriveablePart part, PartType engine) {
        ArrayList<ItemStack> stacks = super.getItemsRequired(part, engine);
        for (Propeller propeller : this.propellers) {
            if (propeller.planePart != part.type) continue;
            if (propeller.itemType != null) {
                stacks.add(new ItemStack(propeller.itemType.item));
            } else {
                FlansMod.logPackError("", this.packName, this.shortName, "Couldn't drop propeller! Check it is a valid item", null, null);
            }
            if (engine.item != null) {
                stacks.add(new ItemStack(engine.item));
                continue;
            }
            FlansMod.logPackError("", this.packName, this.shortName, "Couldn't drop engine on plane death!", null, null);
        }
        return stacks;
    }

    public static PlaneType getPlane(String find) {
        for (PlaneType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelPlane.class);
    }
}

