/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.api.IExplodeable;
import com.flansmod.client.model.AnimTankTrack;
import com.flansmod.client.model.AnimTrackLink;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.ShootPoint;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.eventhandlers.DriveableDeathByHandEvent;
import com.flansmod.common.network.PacketDriveableKey;
import com.flansmod.common.network.PacketParticle;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketVehicleControl;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;

public class EntityVehicle
extends EntityDriveable
implements IExplodeable {
    public int shellDelay;
    public int gunDelay;
    public int soundPosition;
    public int idlePosition;
    public float wheelsYaw;
    private int ticksSinceUsed = 0;
    public boolean varDoor;
    public float wheelsAngle;
    public int toggleTimer = 0;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public float roll = 0.0f;
    public float yawSpeed = 0.0f;
    private float fallVelocity = 0.0f;
    public int throttleDecayDelayTicks = 0;
    public int keyHeld = 0;
    public boolean leftTurnHeld = false;
    public boolean rightTurnHeld = false;
    public boolean allWheelsOnGround;
    boolean lockTurretForward = false;
    public Vector3f doorPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f doorRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f door2Pos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f door2Rot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevDoorPos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevDoorRot = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevDoor2Pos = new Vector3f(0.0f, 0.0f, 0.0f);
    public Vector3f prevDoor2Rot = new Vector3f(0.0f, 0.0f, 0.0f);
    public boolean deployedSmoke = false;
    public float lastRelSpeedRight = 0.0f;
    public float lastRelSpeedLeft = 0.0f;
    public float legAnimPosRight = 0.0f;
    public float legAnimPosLeft = 0.0f;
    public float frLegYawLast = 0.0f;
    public float brLegYawLast = 0.0f;
    public float flLegYawLast = 0.0f;
    public float blLegYawLast = 0.0f;
    public EntityPlayer placer = null;
    public String placerName = null;
    public Entity target = null;
    public AnimTankTrack rightTrack;
    public AnimTankTrack leftTrack;
    public AnimTrackLink[] trackLinksLeft = new AnimTrackLink[0];
    public AnimTrackLink[] trackLinksRight = new AnimTrackLink[0];

    public EntityVehicle(World world) {
        super(world);
        this.field_70138_W = 1.0f;
    }

    public EntityVehicle(World world, double x, double y, double z, VehicleType type, DriveableData data) {
        super(world, type, data, null);
        this.field_70138_W = 1.0f;
        this.func_70107_b(x, y, z);
        this.initType(type, false);
    }

    public EntityVehicle(World world, double x, double y, double z, EntityPlayer p, VehicleType type, DriveableData data) {
        super(world, type, data, p);
        this.placer = p;
        this.placerName = p.func_70005_c_();
        this.field_70138_W = 1.0f;
        this.func_70107_b(x, y, z);
        this.rotateYaw(p.field_70177_z + 90.0f);
        this.initType(type, false);
        this.setupTracks(type);
    }

    public void setupTracks(DriveableType type) {
        this.rightTrack = new AnimTankTrack(type.rightTrackPoints, type.trackLinkLength);
        this.leftTrack = new AnimTankTrack(type.leftTrackPoints, type.trackLinkLength);
        int numLinks = Math.round(this.rightTrack.getTrackLength() / type.trackLinkLength);
        this.trackLinksLeft = new AnimTrackLink[numLinks];
        this.trackLinksRight = new AnimTrackLink[numLinks];
        for (int i = 0; i < numLinks; ++i) {
            float progress = 0.01f + type.trackLinkLength * (float)i;
            int trackPart = this.leftTrack.getTrackPart(progress);
            this.trackLinksLeft[i] = new AnimTrackLink(progress);
            this.trackLinksRight[i] = new AnimTrackLink(progress);
            this.trackLinksLeft[i].position = this.leftTrack.getPositionOnTrack(progress);
            this.trackLinksRight[i].position = this.rightTrack.getPositionOnTrack(progress);
            this.trackLinksLeft[i].rot = new RotatedAxes(0.0f, 0.0f, this.rotateTowards(this.leftTrack.points.get(trackPart == 0 ? this.leftTrack.points.size() - 1 : trackPart - 1), this.trackLinksLeft[i].position));
            this.trackLinksRight[i].rot = new RotatedAxes(0.0f, 0.0f, this.rotateTowards(this.rightTrack.points.get(trackPart == 0 ? this.rightTrack.points.size() - 1 : trackPart - 1), this.trackLinksRight[i].position));
            this.trackLinksLeft[i].zRot = this.rotateTowards(this.leftTrack.points.get(trackPart == 0 ? this.leftTrack.points.size() - 1 : trackPart - 1), this.trackLinksLeft[i].position);
            this.trackLinksRight[i].zRot = this.rotateTowards(this.rightTrack.points.get(trackPart == 0 ? this.rightTrack.points.size() - 1 : trackPart - 1), this.trackLinksRight[i].position);
        }
    }

    @Override
    protected void initType(DriveableType type, boolean clientSide) {
        super.initType(type, clientSide);
        this.setupTracks(type);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("VarDoor", this.varDoor);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.varDoor = tag.func_74767_n("VarDoor");
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
    }

    @Override
    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throt, float steeringYaw) {
        super.setPositionRotationAndMotion(x, y, z, yaw, pitch, roll, motX, motY, motZ, velYaw, velPitch, velRoll, throt, steeringYaw);
        this.wheelsYaw = steeringYaw;
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.seats[i].func_130002_c(entityplayer)) continue;
            if (i == 0) {
                this.shellDelay = type.vehicleShellDelay;
                FlansMod.proxy.doTutorialStuff(entityplayer, this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean pressKey(int key, EntityPlayer player) {
        VehicleType type = this.getVehicleType();
        DriveableData data = this.getDriveableData();
        if (this.field_70170_p.field_72995_K && (key == 6 || key == 8 || key == 9)) {
            FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
            return true;
        }
        switch (key) {
            case 0: {
                if (this.isEngineActive()) {
                    this.throttle = type.useRealisticAcceleration ? (float)((double)this.throttle + (double)(data.engine.enginePower * (this.throttle < 0.0f ? type.brakingModifier : 1.0f)) * (Math.sqrt(1.0f - this.getThrottleNerf()) * 0.9 + 0.1) / (double)type.mass) : (float)((double)this.throttle + (double)(0.01f * (this.throttle < 0.0f ? type.brakingModifier : 1.0f)) * (Math.sqrt(1.0f - this.getThrottleNerf()) * 0.9 + 0.1));
                    this.throttleDecayDelayTicks = 10;
                }
                return true;
            }
            case 1: {
                if (this.isEngineActive()) {
                    this.throttle = type.useRealisticAcceleration ? (float)((double)this.throttle - (double)(data.engine.enginePower * (this.throttle > 0.0f ? type.brakingModifier : 1.0f)) * (Math.sqrt(1.0f - this.getThrottleNerf()) * 0.9 + 0.1) / (double)type.mass) : (float)((double)this.throttle - (double)(0.01f * (this.throttle > 0.0f ? type.brakingModifier : 1.0f)) * (Math.sqrt(1.0f - this.getThrottleNerf()) * 0.9 + 0.1));
                    this.throttleDecayDelayTicks = 10;
                }
                return true;
            }
            case 2: {
                if (this.throttle < 0.3f) {
                    this.throttle += type.clutchBrake;
                }
                this.wheelsYaw -= 1.0f;
                this.leftTurnHeld = true;
                this.keyHeld = 100;
                return true;
            }
            case 3: {
                if (this.throttle < 0.3f) {
                    this.throttle += type.clutchBrake;
                }
                this.wheelsYaw += 1.0f;
                this.rightTurnHeld = true;
                this.keyHeld = 100;
                return true;
            }
            case 4: {
                this.throttle *= 0.8f;
                if (this.throttle > 0.001f) {
                    this.throttle = 0.0f;
                }
                if (this.throttle < -0.001f) {
                    this.throttle = 0.0f;
                }
                this.target = null;
                return true;
            }
            case 5: {
                Minecraft mc = Minecraft.func_71410_x();
                if (this.toggleTimer <= 0 && TeamsManager.allowVehicleZoom) {
                    this.toggleTimer = 10;
                    if (mc.field_71474_y.field_74334_X != 10.0f) {
                        mc.field_71474_y.field_74334_X = 10.0f;
                        mc.field_71474_y.field_74341_c = 0.2f;
                    } else {
                        mc.field_71474_y.field_74334_X = 70.0f;
                        mc.field_71474_y.field_74341_c = 0.5f;
                    }
                }
                return true;
            }
            case 6: {
                this.seats[0].field_70153_n.func_82142_c(false);
                this.seats[0].field_70153_n.func_70078_a(null);
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.exitSound, false);
                return true;
            }
            case 7: {
                if (this.field_70170_p.field_72995_K) {
                    FlansMod.proxy.openDriveableMenu((EntityPlayer)this.seats[0].field_70153_n, this.field_70170_p, this);
                }
                return true;
            }
            case 8: 
            case 9: {
                return super.pressKey(key, player);
            }
            case 10: {
                FlansMod.proxy.changeControlMode((EntityPlayer)this.seats[0].field_70153_n);
                this.seats[0].targetYaw = this.seats[0].looking.getYaw();
                this.seats[0].targetPitch = this.seats[0].looking.getPitch();
                return true;
            }
            case 11: {
                this.seats[0].targetYaw -= this.seats[0].seatInfo.aimingSpeed.x;
                return true;
            }
            case 12: {
                this.seats[0].targetYaw += this.seats[0].seatInfo.aimingSpeed.x;
                return true;
            }
            case 13: {
                if (this.seats[0].targetPitch < -this.seats[0].seatInfo.minPitch) {
                    this.seats[0].targetPitch += this.seats[0].seatInfo.aimingSpeed.y;
                }
                return true;
            }
            case 14: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varDoor = !this.varDoor;
                    if (type.hasDoor) {
                        player.func_145747_a((IChatComponent)new ChatComponentText("Doors " + (this.varDoor ? "opened" : "closed")));
                    }
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketVehicleControl(this));
                }
                return true;
            }
            case 15: {
                if (this.seats[0].targetPitch > -this.seats[0].seatInfo.maxPitch) {
                    this.seats[0].targetPitch -= this.seats[0].seatInfo.aimingSpeed.y;
                }
                return true;
            }
            case 16: {
                return true;
            }
            case 17: {
                break;
            }
            case 18: {
                if (!type.hasFlare || this.ticksFlareUsing > 0 || this.flareDelay > 0) break;
                this.ticksFlareUsing = type.timeFlareUsing * 20;
                this.flareDelay = type.flareDelay;
                this.dischargeSmoke();
                if (this.field_70170_p.field_72995_K) {
                    FlansMod.getPacketHandler().sendToServer(new PacketDriveableKey(key));
                } else {
                    this.dischargeSmoke();
                    if (!type.flareSound.isEmpty()) {
                        PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.flareSound, false);
                    }
                }
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void resetZoom() {
        if (TeamsManager.allowVehicleZoom) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71474_y.field_74334_X == 10.0f) {
                mc.field_71474_y.field_74334_X = 70.0f;
                mc.field_71474_y.field_74341_c = 0.5f;
            }
        }
    }

    @Override
    public Vector3f getLookVector(ShootPoint dp) {
        return this.rotate(this.seats[0].looking.getXAxis());
    }

    @Override
    public void func_70071_h_() {
        double bkPrevPosY = this.field_70167_r;
        super.func_70071_h_();
        this.animateFancyTracks();
        if (this.field_70170_p.field_72995_K) {
            for (Entity e : this.findEntitiesWithinbounds()) {
                if (this.isPartOfThis(e) || !(e instanceof EntityPlayer)) continue;
                this.moveRiders(e);
            }
        }
        VehicleType type = this.getVehicleType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log("Vehicle type null. Not ticking vehicle");
            return;
        }
        if (type.shootWithOpenDoor) {
            this.canFire = this.varDoor;
        }
        boolean thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.seats[0].field_70153_n);
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && TeamsManager.vehicleLife > 0 && this.ticksSinceUsed > TeamsManager.vehicleLife * 20) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && (this.varFlare || this.ticksFlareUsing > type.timeFlareUsing * 20 - 5) && this.field_70173_aa % 5 == 0) {
            this.deployedSmoke = true;
        }
        if (type.setPlayerInvisible && !this.field_70170_p.field_72995_K && this.seats[0].field_70153_n != null) {
            this.seats[0].field_70153_n.func_82142_c(true);
        }
        if (this.ticksFlareUsing <= 0) {
            this.deployedSmoke = false;
        }
        if (this.ticksFlareUsing > 0) {
            --this.ticksFlareUsing;
        }
        if (this.flareDelay > 0) {
            --this.flareDelay;
        }
        if (this.shellDelay > 0) {
            --this.shellDelay;
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.soundPosition > 0) {
            --this.soundPosition;
        }
        if (this.idlePosition > 0) {
            --this.idlePosition;
        }
        if (type.tank && !this.hasBothTracks()) {
            this.throttle = 0.0f;
        }
        if (this.disabled || !this.hasBothTracks() || !this.isPartIntact(EnumDriveablePart.steering)) {
            this.wheelsYaw = 0.0f;
        }
        float maxThrottle = 1.0f - this.getThrottleNerf();
        if (Math.abs(this.throttle) > maxThrottle) {
            this.throttle = Math.max(-1.0f, Math.min(1.0f, (Math.signum(this.throttle) * maxThrottle + this.throttle * 2.0f) / 3.0f));
        }
        if (this.hasEnoughFuel() && this.isEngineActive()) {
            this.wheelsAngle += this.throttle / 3.25f;
        }
        this.prevDoorPos = this.doorPos;
        this.prevDoorRot = this.doorRot;
        this.prevDoor2Pos = this.door2Pos;
        this.prevDoor2Rot = this.door2Rot;
        if (!this.varDoor) {
            this.doorPos = this.transformPart(this.doorPos, type.doorPos1, type.doorRate);
            this.doorRot = this.transformPart(this.doorRot, type.doorRot1, type.doorRotRate);
            this.door2Pos = this.transformPart(this.door2Pos, type.door2Pos1, type.door2Rate);
            this.door2Rot = this.transformPart(this.door2Rot, type.door2Rot1, type.door2RotRate);
        } else {
            this.doorPos = this.transformPart(this.doorPos, type.doorPos2, type.doorRate);
            this.doorRot = this.transformPart(this.doorRot, type.doorRot2, type.doorRotRate);
            this.door2Pos = this.transformPart(this.door2Pos, type.door2Pos2, type.door2Rate);
            this.door2Rot = this.transformPart(this.door2Rot, type.door2Rot2, type.door2RotRate);
        }
        this.wheelsYaw *= 0.9f;
        if (this.wheelsYaw > 20.0f) {
            this.wheelsYaw = 20.0f;
        }
        if (this.wheelsYaw < -20.0f) {
            this.wheelsYaw = -20.0f;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            double x = this.field_70165_t + (this.field_70118_ct - this.field_70165_t) / (double)this.serverPositionTransitionTicker;
            double y = this.field_70163_u + (this.field_70117_cu - this.field_70163_u) / (double)this.serverPositionTransitionTicker;
            double z = this.field_70161_v + (this.field_70116_cv - this.field_70161_v) / (double)this.serverPositionTransitionTicker;
            double dYaw = MathHelper.func_76138_g((double)(this.serverYaw - (double)this.axes.getYaw()));
            double dPitch = MathHelper.func_76138_g((double)(this.serverPitch - (double)this.axes.getPitch()));
            double dRoll = MathHelper.func_76138_g((double)(this.serverRoll - (double)this.axes.getRoll()));
            this.field_70177_z = (float)((double)this.axes.getYaw() + dYaw / (double)this.serverPositionTransitionTicker);
            this.field_70125_A = (float)((double)this.axes.getPitch() + dPitch / (double)this.serverPositionTransitionTicker);
            float rotationRoll = (float)((double)this.axes.getRoll() + dRoll / (double)this.serverPositionTransitionTicker);
            --this.serverPositionTransitionTicker;
            this.func_70107_b(x, y, z);
            this.setRotation(this.field_70177_z, this.field_70125_A, rotationRoll);
        }
        this.correctWheelPos();
        Vector3f amountToMoveCar = new Vector3f();
        for (EntityWheel wheel : this.wheels) {
            boolean canThrustCreatively;
            if (wheel == null) continue;
            double prevPosYWheel = wheel.field_70163_u;
            this.field_70122_E = true;
            wheel.field_70122_E = true;
            wheel.field_70177_z = this.axes.getYaw();
            if (!(type.tank || wheel.ID != 2 && wheel.ID != 3)) {
                wheel.field_70177_z += this.wheelsYaw;
            }
            wheel.field_70159_w *= (double)0.9f;
            wheel.field_70181_x = wheel.field_70181_x * (this.field_70163_u - bkPrevPosY < 0.0 ? (double)0.999f : (double)0.9f);
            wheel.field_70179_y *= (double)0.9f;
            boolean bl = canThrustCreatively = !TeamsManager.vehiclesNeedFuel || type.fuelTankSize < 0 || this.seats != null && this.seats[0] != null && this.seats[0].field_70153_n instanceof EntityPlayer && ((EntityPlayer)this.seats[0].field_70153_n).field_71075_bZ.field_75098_d;
            if ((canThrustCreatively || type.fuelTankSize < 0 || data.fuelInTank > Math.abs(data.engine.fuelConsumption * this.throttle)) && this.isEngineActive()) {
                if (this.getVehicleType().tank) {
                    boolean left = wheel.ID == 0 || wheel.ID == 3;
                    float turningDrag = 0.02f;
                    wheel.field_70159_w *= (double)(1.0f - Math.abs(this.wheelsYaw) * turningDrag);
                    wheel.field_70179_y *= (double)(1.0f - Math.abs(this.wheelsYaw) * turningDrag);
                    float velocityScale = 0.0f;
                    velocityScale = this.isUnderWater() ? 0.04f * (this.throttle > 0.0f ? type.maxThrottleInWater : type.maxNegativeThrottle) * data.engine.engineSpeed : 0.04f * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                    float steeringScale = 0.1f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier);
                    float effectiveWheelSpeed = (this.throttle + this.wheelsYaw * (float)(left ? 1 : -1) * steeringScale) * velocityScale;
                    wheel.field_70159_w += (double)effectiveWheelSpeed * Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f);
                    wheel.field_70179_y += (double)effectiveWheelSpeed * Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f);
                    this.yawSpeed = (float)((double)this.yawSpeed + (double)effectiveWheelSpeed * Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f));
                } else {
                    float velocityScale = 0.0f;
                    velocityScale = this.isUnderWater() ? 0.1f * this.throttle * (this.throttle > 0.0f ? type.maxThrottleInWater : type.maxNegativeThrottle) * data.engine.engineSpeed : 0.1f * this.throttle * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                    wheel.field_70159_w += Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale;
                    wheel.field_70179_y += Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale;
                    if (wheel.ID == 2 || wheel.ID == 3) {
                        velocityScale = 0.01f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier) * (float)(this.throttle > 0.0f ? 1 : -1);
                        wheel.field_70159_w -= wheel.getSpeedXZ() * Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale * (double)this.wheelsYaw;
                        wheel.field_70179_y += wheel.getSpeedXZ() * Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale * (double)this.wheelsYaw;
                    } else {
                        wheel.field_70159_w *= (double)0.9f;
                        wheel.field_70179_y *= (double)0.9f;
                    }
                }
                if (!canThrustCreatively && TeamsManager.vehiclesNeedFuel) {
                    data.fuelInTank = (float)((double)data.fuelInTank - (double)Math.abs(data.engine.fuelConsumption * this.throttle) * 0.1);
                }
            }
            wheel.func_70091_d(wheel.field_70159_w, wheel.field_70181_x, wheel.field_70179_y);
            Vector3f targetWheelPos = this.axes.findLocalVectorGlobally(this.getVehicleType().wheelPositions[wheel.ID].position);
            Vector3f currentWheelPos = new Vector3f(wheel.field_70165_t - this.field_70165_t, wheel.field_70163_u - this.field_70163_u, wheel.field_70161_v - this.field_70161_v);
            Vector3f dPos = Vector3f.sub(targetWheelPos, currentWheelPos, null).scale(type.wheelSpringStrength);
            if (dPos.length() > 0.001f) {
                wheel.func_70091_d(dPos.x, dPos.y, dPos.z);
                dPos.scale(0.5f);
                Vector3f.sub(amountToMoveCar, dPos, amountToMoveCar);
            }
            float avgWheelHeight = 0.0f;
            if (this.wheels[0] != null && this.wheels[1] != null && this.wheels[2] != null && this.wheels[3] != null) {
                avgWheelHeight = (float)(this.wheels[0].field_70165_t + this.wheels[1].field_70165_t + this.wheels[2].field_70165_t + this.wheels[3].field_70165_t) / 4.0f;
                this.allWheelsOnGround = this.wheels[0].field_70122_E || this.wheels[1].field_70122_E || this.wheels[2].field_70122_E || this.wheels[3].field_70122_E;
            }
            if (!(type.floatOnWater && this.field_70170_p.func_72953_d(wheel.field_70121_D.func_72329_c().func_72317_d(0.0, (double)(-type.floatOffset), 0.0)) || wheel.onDeck)) {
                float a = type.maxFallSpeed;
                float g = type.gravity;
                if (wheel.field_70122_E) {
                    a *= 0.5f;
                    g *= 1.5f;
                }
                if (wheel.field_70181_x >= 0.0) {
                    wheel.field_70181_x -= (double)g;
                    continue;
                }
                if (!(wheel.field_70181_x >= (double)(-a))) continue;
                wheel.field_70181_x -= (double)g * (wheel.field_70181_x + (double)a);
                continue;
            }
            if (type.floatOnWater && this.field_70170_p.func_72953_d(wheel.field_70121_D.func_72329_c().func_72317_d(0.0, (double)(-type.floatOffset), 0.0)) && this.field_70170_p.func_72953_d(wheel.field_70121_D.func_72329_c().func_72317_d(0.0, (double)(1.0f - type.floatOffset), 0.0)) && !wheel.onDeck) {
                wheel.func_70091_d(0.0, 1.0, 0.0);
                continue;
            }
            if ((!type.floatOnWater || !this.field_70170_p.func_72953_d(wheel.field_70121_D.func_72329_c().func_72317_d(0.0, (double)(-type.floatOffset), 0.0)) || this.field_70170_p.func_72953_d(wheel.field_70121_D.func_72329_c().func_72317_d(0.0, (double)(1.0f - type.floatOffset), 0.0))) && !wheel.onDeck) continue;
            wheel.func_70091_d(0.0, 0.0, 0.0);
            this.roll = 0.0f;
            this.pitch = 0.0f;
        }
        if (this.wheels[0] != null && this.wheels[1] != null && this.wheels[2] != null && this.wheels[3] != null) {
            this.lastPos.x = (float)(this.wheels[0].field_70159_w + this.wheels[1].field_70159_w + this.wheels[2].field_70159_w + this.wheels[3].field_70159_w) / 4.0f;
            this.lastPos.y = (float)(this.wheels[0].field_70181_x + this.wheels[1].field_70181_x + this.wheels[2].field_70181_x + this.wheels[3].field_70181_x) / 4.0f;
            this.lastPos.z = (float)(this.wheels[0].field_70179_y + this.wheels[1].field_70179_y + this.wheels[2].field_70179_y + this.wheels[3].field_70179_y) / 4.0f;
        }
        double bmy = this.field_70181_x;
        this.field_70181_x = amountToMoveCar.y;
        if (this.collisionHardness.floatValue() > 0.2f) {
            amountToMoveCar.x = -this.axes.getXAxis().x * (float)this.getSpeedXZ() * 0.1f;
            amountToMoveCar.z = -this.axes.getXAxis().z * (float)this.getSpeedXZ() * 0.1f;
        }
        this.collisionHardness = Float.valueOf(0.0f);
        this.func_70091_d(amountToMoveCar.x, amountToMoveCar.y, amountToMoveCar.z);
        this.field_70181_x = bmy;
        if (this.wheels[0] != null && this.wheels[1] != null && this.wheels[2] != null && this.wheels[3] != null) {
            float steeringScale;
            float velocityScale;
            Vector3f frontAxleCentre = new Vector3f((this.wheels[2].field_70165_t + this.wheels[3].field_70165_t) / 2.0, (this.wheels[2].field_70163_u + this.wheels[3].field_70163_u) / 2.0, (this.wheels[2].field_70161_v + this.wheels[3].field_70161_v) / 2.0);
            Vector3f backAxleCentre = new Vector3f((this.wheels[0].field_70165_t + this.wheels[1].field_70165_t) / 2.0, (this.wheels[0].field_70163_u + this.wheels[1].field_70163_u) / 2.0, (this.wheels[0].field_70161_v + this.wheels[1].field_70161_v) / 2.0);
            Vector3f leftSideCentre = new Vector3f((this.wheels[0].field_70165_t + this.wheels[3].field_70165_t) / 2.0, (this.wheels[0].field_70163_u + this.wheels[3].field_70163_u) / 2.0, (this.wheels[0].field_70161_v + this.wheels[3].field_70161_v) / 2.0);
            Vector3f rightSideCentre = new Vector3f((this.wheels[1].field_70165_t + this.wheels[2].field_70165_t) / 2.0, (this.wheels[1].field_70163_u + this.wheels[2].field_70163_u) / 2.0, (this.wheels[1].field_70161_v + this.wheels[2].field_70161_v) / 2.0);
            if (frontAxleCentre.y > backAxleCentre.y && this.throttle > 0.0f) {
                float diff = frontAxleCentre.y - backAxleCentre.y;
                float dx = frontAxleCentre.x - backAxleCentre.x;
                dx = (float)Math.sqrt(dx * dx);
                float dz = frontAxleCentre.z - backAxleCentre.z;
                dz = (float)Math.sqrt(dz * dz);
                float dist = (float)Math.sqrt(dx + dz);
                this.throttle *= 1.0f - (diff /= dist) / 60.0f;
            }
            float dx = frontAxleCentre.x - backAxleCentre.x;
            float dy = frontAxleCentre.y - backAxleCentre.y;
            float dz = frontAxleCentre.z - backAxleCentre.z;
            float drx = leftSideCentre.x - rightSideCentre.x;
            float dry = leftSideCentre.y - rightSideCentre.y;
            float drz = leftSideCentre.z - rightSideCentre.z;
            float dxz = (float)Math.sqrt(dx * dx + dz * dz);
            float drxz = (float)Math.sqrt(drx * drx + drz * drz);
            float tyaw = (float)Math.atan2(dz, dx);
            float tpitch = -((float)Math.atan2(dy, dxz));
            float troll = 0.0f;
            if (type.canRoll) {
                troll = -((float)Math.atan2(dry, drxz));
            }
            this.yaw = tyaw;
            this.pitch = this.Lerp(this.pitch, tpitch, 0.2f);
            this.roll = this.Lerp(this.roll, troll, 0.2f);
            if (type.tank) {
                float effectiveWheelSpeed;
                if (this.isEngineActive()) {
                    velocityScale = 0.04f * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                    steeringScale = 0.1f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier);
                    effectiveWheelSpeed = this.wheelsYaw * steeringScale * velocityScale;
                } else {
                    effectiveWheelSpeed = 0.0f;
                }
                this.yaw = this.axes.getYaw() / 180.0f * 3.14159f + effectiveWheelSpeed;
            } else {
                float throttleModifier = (float)((double)(2.4f * Math.abs(this.throttle) - 2.5f * (this.throttle * this.throttle)) + 0.5 * Math.abs(Math.pow(this.throttle, 3.0))) * Math.signum(this.throttle);
                velocityScale = 0.1f * throttleModifier * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                steeringScale = 0.1f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier);
                float effectiveWheelSpeed = this.wheelsYaw * steeringScale * velocityScale;
                this.yaw = this.axes.getYaw() / 180.0f * 3.14159f + effectiveWheelSpeed;
            }
            this.axes.setAngles(this.yaw * 180.0f / 3.14159f, this.pitch * 180.0f / 3.14159f, this.roll * 180.0f / 3.14159f);
        }
        if (this.field_70154_o != null && this.field_70154_o.getClass().toString().indexOf("mcheli.aircraft.MCH_EntitySeat") > 0) {
            this.axes.setAngles(this.field_70154_o.field_70177_z + 90.0f, 0.0f, 0.0f);
        }
        this.checkForCollisions();
        if (Math.abs(this.throttle) > 0.01f && Math.abs(this.throttle) < 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, type.startSoundRange, this.field_71093_bK, type.startSound, false);
            this.soundPosition = type.startSoundLength;
        }
        if (this.throttle >= 0.2f && this.soundPosition == 0 && this.hasEnoughFuel() && this.isEngineActive()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, type.engineSoundRange, this.field_71093_bK, type.engineSound, false);
            this.soundPosition = type.engineSoundLength;
        }
        if (this.seats[0] != null && this.throttle <= 0.01f && this.throttle >= -0.2f && this.seats[0].field_70153_n != null && this.idlePosition == 0) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, type.engineSoundRange, this.field_71093_bK, type.idleSound, false);
            this.idlePosition = type.idleSoundLength;
        }
        if (this.throttle <= -0.2f && this.soundPosition == 0 && this.hasEnoughFuel() && this.isEngineActive()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, type.backSoundRange, this.field_71093_bK, type.backSound, false);
            this.soundPosition = type.backSoundLength;
        }
        for (EntitySeat seat : this.seats) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if (this.throttleDecayDelayTicks > 0) {
            --this.throttleDecayDelayTicks;
        } else {
            this.throttle -= Math.signum(this.throttle) * type.throttleDecay;
        }
        if (this.throttle < type.throttleDecay && this.throttle > -type.throttleDecay) {
            this.throttle = 0.0f;
        }
        if (thePlayerIsDrivingThis && this.field_70173_aa % 5 == 0) {
            FlansMod.getPacketHandler().sendToServer(new PacketVehicleControl(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa % 5 == 0) {
            FlansMod.getPacketHandler().sendToAllAround(new PacketVehicleControl(this), this.field_70165_t, this.field_70163_u, this.field_70161_v, FlansMod.driveableUpdateRange, this.field_71093_bK);
        }
        int animSpeed = 4;
        if ((double)this.throttle > 0.05 && (double)this.throttle <= 0.33 || (double)this.throttle < -0.05 && (double)this.throttle >= -0.33) {
            animSpeed = 3;
        } else if ((double)this.throttle > 0.33 && (double)this.throttle <= 0.66 || (double)this.throttle < -0.33 && (double)this.throttle >= -0.66) {
            animSpeed = 2;
        } else if ((double)this.throttle > 0.66 && (double)this.throttle <= 0.9 || (double)this.throttle < -0.66 && (double)this.throttle >= -0.9) {
            animSpeed = 1;
        } else if ((double)this.throttle > 0.9 && this.throttle <= 1.0f || (double)this.throttle < -0.9 && this.throttle >= -1.0f) {
            animSpeed = 0;
        }
        boolean turningLeft = false;
        boolean turningRight = false;
        if ((double)this.throttle > 0.05) {
            --this.animCountLeft;
            --this.animCountRight;
        } else if ((double)this.throttle < -0.05) {
            ++this.animCountLeft;
            ++this.animCountRight;
        } else if (this.wheelsYaw < -1.0f) {
            turningLeft = true;
            ++this.animCountLeft;
            --this.animCountRight;
            animSpeed = 1;
            if (this.soundPosition == 0 && this.hasEnoughFuel() && type.tank && this.isEngineActive()) {
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, type.engineSoundRange, this.field_71093_bK, type.engineSound, false);
                this.soundPosition = type.engineSoundLength;
            }
        } else if (this.wheelsYaw > 1.0f) {
            turningRight = true;
            --this.animCountLeft;
            ++this.animCountRight;
            animSpeed = 1;
            if (this.soundPosition == 0 && this.hasEnoughFuel() && type.tank && this.isEngineActive() && this.isEngineActive()) {
                PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, type.engineSoundRange, this.field_71093_bK, type.engineSound, false);
                this.soundPosition = type.engineSoundLength;
            }
        } else {
            turningLeft = false;
            turningRight = false;
        }
        if (this.animCountLeft <= 0) {
            this.animCountLeft = animSpeed;
            ++this.animFrameLeft;
        }
        if (this.animCountRight <= 0) {
            this.animCountRight = animSpeed;
            ++this.animFrameRight;
        }
        if ((this.throttle < 0.0f || turningLeft) && this.animCountLeft >= animSpeed) {
            this.animCountLeft = 0;
            --this.animFrameLeft;
        }
        if ((this.throttle < 0.0f || turningRight) && this.animCountRight >= animSpeed) {
            this.animCountRight = 0;
            --this.animFrameRight;
        }
        if (this.animFrameLeft > type.animFrames) {
            this.animFrameLeft = 0;
        }
        if (this.animFrameLeft < 0) {
            this.animFrameLeft = type.animFrames;
        }
        if (this.animFrameRight > type.animFrames) {
            this.animFrameRight = 0;
        }
        if (this.animFrameRight < 0) {
            this.animFrameRight = type.animFrames;
        }
    }

    public Entity getValidTarget() {
        if (this.placer == null && this.placerName != null) {
            this.placer = this.field_70170_p.func_72924_a(this.placerName);
        }
        float targetRange = 150.0f;
        Entity target = null;
        for (Object obj : this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b((double)targetRange, (double)targetRange, (double)targetRange))) {
            Entity candidateEntity = (Entity)obj;
            boolean targetMobs = true;
            boolean targetPlayers = false;
            boolean targetPlanes = true;
            boolean targetVehicles = true;
            if (!(targetMobs && candidateEntity instanceof EntityBat || targetPlayers && candidateEntity instanceof EntityPlayer || targetPlanes && candidateEntity instanceof EntityPlane) && (!targetVehicles || !(candidateEntity instanceof EntityVehicle)) || !(candidateEntity.func_70032_d((Entity)this) < targetRange)) continue;
            targetRange = candidateEntity.func_70032_d((Entity)this);
            if (this.isPartOfThis(candidateEntity)) {
                candidateEntity = null;
            }
            if (candidateEntity instanceof EntityPlayer) {
                if (candidateEntity == this.placer || candidateEntity.func_70005_c_().equals(this.placerName)) {
                    candidateEntity = null;
                }
                if (TeamsManager.enabled && TeamsManager.getInstance().currentRound != null && this.placer != null) {
                    PlayerData placerData = PlayerHandler.getPlayerData(this.placer, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
                    PlayerData candidateData = PlayerHandler.getPlayerData((EntityPlayer)candidateEntity, this.field_70170_p.field_72995_K ? Side.CLIENT : Side.SERVER);
                    if (candidateData.team == Team.spectators || candidateData.team == null) {
                        candidateEntity = null;
                    }
                    if (!TeamsManager.getInstance().currentRound.gametype.playerCanAttack((EntityPlayerMP)this.placer, placerData.team, (EntityPlayerMP)candidateEntity, candidateData.team)) {
                        candidateEntity = null;
                    }
                }
            }
            target = candidateEntity;
        }
        if (target != null) {
            return target;
        }
        return null;
    }

    public void animateFancyTracks() {
        int part;
        float newAngle;
        float speed;
        int i;
        float funkypart = this.getVehicleType().trackLinkFix;
        boolean funk = true;
        float funk2 = 0.0f;
        for (i = 0; i < this.trackLinksLeft.length; ++i) {
            this.trackLinksLeft[i].prevPosition = this.trackLinksLeft[i].position;
            this.trackLinksLeft[i].prevZRot = this.trackLinksLeft[i].zRot;
            speed = this.throttle * 1.5f - this.wheelsYaw / 12.0f;
            this.trackLinksLeft[i].progress += speed;
            if (this.trackLinksLeft[i].progress > this.leftTrack.getTrackLength()) {
                this.trackLinksLeft[i].progress -= this.leftTrack.getTrackLength();
            }
            if (this.trackLinksLeft[i].progress < 0.0f) {
                this.trackLinksLeft[i].progress += this.leftTrack.getTrackLength();
            }
            this.trackLinksLeft[i].position = this.leftTrack.getPositionOnTrack(this.trackLinksLeft[i].progress);
            while (this.trackLinksLeft[i].zRot > 180.0f) {
                this.trackLinksLeft[i].zRot -= 360.0f;
            }
            while (this.trackLinksLeft[i].zRot <= -180.0f) {
                this.trackLinksLeft[i].zRot += 360.0f;
            }
            newAngle = this.rotateTowards(this.leftTrack.points.get(this.leftTrack.getTrackPart(this.trackLinksLeft[i].progress)), this.trackLinksLeft[i].position);
            part = this.leftTrack.getTrackPart(this.trackLinksLeft[i].progress);
            funk2 = funk ? (speed < 0.0f ? 0.0f : 1.0f) : (speed < 0.0f ? -1.0f : 0.0f);
            this.trackLinksLeft[i].zRot = this.Lerp(this.trackLinksLeft[i].zRot, newAngle, (float)part != funkypart + funk2 ? 0.5f : 1.0f);
        }
        for (i = 0; i < this.trackLinksRight.length; ++i) {
            this.trackLinksRight[i].prevPosition = this.trackLinksRight[i].position;
            this.trackLinksRight[i].prevZRot = this.trackLinksRight[i].zRot;
            speed = this.throttle * 1.5f + this.wheelsYaw / 12.0f;
            this.trackLinksRight[i].progress += speed;
            if (this.trackLinksRight[i].progress > this.rightTrack.getTrackLength()) {
                this.trackLinksRight[i].progress -= this.leftTrack.getTrackLength();
            }
            if (this.trackLinksRight[i].progress < 0.0f) {
                this.trackLinksRight[i].progress += this.rightTrack.getTrackLength();
            }
            this.trackLinksRight[i].position = this.rightTrack.getPositionOnTrack(this.trackLinksRight[i].progress);
            newAngle = this.rotateTowards(this.rightTrack.points.get(this.rightTrack.getTrackPart(this.trackLinksRight[i].progress)), this.trackLinksRight[i].position);
            part = this.rightTrack.getTrackPart(this.trackLinksRight[i].progress);
            funk2 = funk ? (speed < 0.0f ? 0.0f : 1.0f) : (speed < 0.0f ? -1.0f : 0.0f);
            this.trackLinksRight[i].zRot = this.Lerp(this.trackLinksRight[i].zRot, newAngle, (float)part != funkypart + funk2 ? 0.5f : 1.0f);
        }
    }

    public float rotateTowards(Vector3f point, Vector3f original) {
        float angle = (float)Math.atan2(point.y - original.y, point.x - original.x);
        return angle;
    }

    public void dischargeSmoke() {
        VehicleType type = this.getVehicleType();
        for (int i = 0; i < type.smokers.size(); ++i) {
            VehicleType.SmokePoint smoker = type.smokers.get(i);
            Vector3f dir = smoker.direction;
            Vector3f pos = smoker.position;
            int time = smoker.detTime;
            dir = this.axes.findLocalVectorGlobally(dir);
            pos = this.axes.findLocalVectorGlobally(pos);
            if (EnumDriveablePart.getPart(smoker.part) == EnumDriveablePart.turret) {
                dir = this.rotate(this.seats[0].looking.findLocalVectorGlobally(smoker.direction));
                pos = this.getPositionOnTurret(smoker.position, false);
            }
            FlansMod.getPacketHandler().sendToAllAround(new PacketParticle("flansmod.smoker", this.field_70165_t + (double)(pos.x / 16.0f), this.field_70163_u + (double)(pos.y / 16.0f), this.field_70161_v + (double)(pos.z / 16.0f), dir.x, dir.y, dir.z), this.field_70165_t, this.field_70163_u, this.field_70161_v, 150.0f, this.field_71093_bK);
        }
    }

    public float Lerp(float start, float end, float percent) {
        float result = start + percent * (end - start);
        return result;
    }

    public static float Clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public List<Entity> findEntitiesWithinbounds() {
        VehicleType type = this.getVehicleType();
        AxisAlignedBB initialBox = this.field_70121_D.func_72329_c();
        List riddenEntities = this.field_70170_p.func_72872_a(Entity.class, initialBox);
        Vector3f size = new Vector3f(type.harvestBoxSize.x / 8.0f, type.harvestBoxSize.y / 8.0f, type.harvestBoxSize.z / 8.0f);
        Vector3f pos = new Vector3f(type.harvestBoxPos.x / 8.0f, type.harvestBoxPos.y / 8.0f, type.harvestBoxPos.z / 8.0f);
        boolean fancy = false;
        if (!fancy) {
            for (float x = pos.x; x <= pos.x + size.x; x += 1.0f) {
                for (float y = pos.y; y <= pos.y + size.y; y += 1.0f) {
                    for (float z = pos.z; z <= pos.z + size.z; z += 1.0f) {
                        Vector3f v = this.axes.findLocalVectorGlobally(new Vector3f(x, y, z));
                        double entX = this.field_70165_t + (double)v.x;
                        double entY = this.field_70163_u + (double)v.y;
                        double entZ = this.field_70161_v + (double)v.z;
                        AxisAlignedBB checkBox = this.field_70121_D.func_72329_c().func_72317_d((double)v.x, (double)v.y, (double)v.z);
                        List entityhere = this.field_70170_p.func_72872_a(Entity.class, checkBox);
                        for (int i = 0; i < entityhere.size(); ++i) {
                            if (!(entityhere.get(i) instanceof EntityPlayer) || this.isPartOfThis((Entity)entityhere.get(i))) continue;
                            riddenEntities.add(entityhere.get(i));
                        }
                    }
                }
            }
        } else {
            AxisAlignedBB checkBox = this.func_70046_E().func_72329_c().func_72314_b(50.0, 50.0, 50.0);
            List entityhere = this.field_70170_p.func_72872_a(EntityPlayer.class, checkBox);
            for (int i = 0; i < entityhere.size(); ++i) {
                if (!(entityhere.get(i) instanceof EntityPlayer)) continue;
                riddenEntities.add(entityhere.get(i));
            }
        }
        return riddenEntities;
    }

    public Vector3f transformPart(Vector3f current, Vector3f target, Vector3f rate) {
        Vector3f newPos = current;
        if (Math.sqrt((current.x - target.x) * (current.x - target.x)) > (double)(rate.x / 2.0f)) {
            if (current.x > target.x) {
                current.x -= rate.x;
            } else if (current.x < target.x) {
                current.x += rate.x;
            }
        } else {
            current.x = target.x;
        }
        if (Math.sqrt((current.y - target.y) * (current.y - target.y)) > (double)(rate.y / 2.0f)) {
            if (current.y > target.y) {
                current.y -= rate.y;
            } else if (current.y < target.y) {
                current.y += rate.y;
            }
        } else {
            current.y = target.y;
        }
        if (Math.sqrt((current.z - target.z) * (current.z - target.z)) > (double)(rate.z / 2.0f)) {
            if (current.z > target.z) {
                current.z -= rate.z;
            } else if (current.z < target.z) {
                current.z += rate.z;
            }
        } else {
            current.z = target.z;
        }
        return newPos;
    }

    @Override
    protected void func_70069_a(float k) {
        if (k <= 10.0f) {
            return;
        }
        float damage = MathHelper.func_76123_f((float)k) * 2;
        boolean no_damage = true;
        if (damage > 0.0f && this.invulnerableUnmountCount == 0 && this.field_70173_aa > 20) {
            DriveableType type = this.getDriveableType();
            damage = (int)(damage * type.fallDamageFactor);
            this.attackPart(EnumDriveablePart.core, DamageSource.field_76379_h, damage);
            if (type.wheelPositions.length > 0) {
                this.attackPart(type.wheelPositions[0].part, DamageSource.field_76379_h, damage / 5.0f);
            }
            no_damage = false;
        }
    }

    private float averageAngles(float a, float b) {
        float avg;
        float pi = (float)Math.PI;
        while (a > b + pi) {
            a -= 2.0f * pi;
        }
        while (a < b - pi) {
            a += 2.0f * pi;
        }
        for (avg = (a + b) / 2.0f; avg > pi; avg -= 2.0f * pi) {
        }
        while (avg < -pi) {
            avg += 2.0f * pi;
        }
        return avg;
    }

    private Vec3 subtract(Vec3 a, Vec3 b) {
        return Vec3.func_72443_a((double)(a.field_72450_a - b.field_72450_a), (double)(a.field_72448_b - b.field_72448_b), (double)(a.field_72449_c - b.field_72449_c));
    }

    private Vec3 crossProduct(Vec3 a, Vec3 b) {
        return Vec3.func_72443_a((double)(a.field_72448_b * b.field_72449_c - a.field_72449_c * b.field_72448_b), (double)(a.field_72449_c * b.field_72450_a - a.field_72450_a * b.field_72449_c), (double)(a.field_72450_a * b.field_72448_b - a.field_72448_b * b.field_72450_a));
    }

    @Override
    public boolean landVehicle() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        if (damagesource.field_76373_n.equals("player") && damagesource.func_76346_g().field_70122_E && (this.seats[0] == null || this.seats[0].field_70153_n == null) && (damagesource.func_76346_g() instanceof EntityPlayer && ((EntityPlayer)damagesource.func_76346_g()).field_71075_bZ.field_75098_d || TeamsManager.survivalCanBreakVehicles)) {
            ItemStack vehicleStack = new ItemStack(type.item, 1, this.driveableData.paintjobID);
            vehicleStack.field_77990_d = new NBTTagCompound();
            this.driveableData.writeToNBT(vehicleStack.field_77990_d);
            DriveableDeathByHandEvent driveableDeathByHandEvent = new DriveableDeathByHandEvent(this, (EntityPlayer)damagesource.func_76346_g(), vehicleStack);
            MinecraftForge.EVENT_BUS.post((Event)driveableDeathByHandEvent);
            if (!driveableDeathByHandEvent.isCanceled()) {
                if (!this.field_70170_p.field_72995_K && damagesource.func_76346_g() instanceof EntityPlayer) {
                    FlansMod.log("Player %s broke vehicle %s (%d) at (%f, %f, %f)", ((EntityPlayerMP)damagesource.func_76346_g()).getDisplayName(), type.shortName, this.func_145782_y(), this.field_70165_t, this.field_70163_u, this.field_70161_v);
                }
                this.func_70099_a(vehicleStack, 0.5f);
                this.func_70106_y();
            }
        }
        return super.func_70097_a(damagesource, i);
    }

    public VehicleType getVehicleType() {
        return VehicleType.getVehicle(this.driveableType);
    }

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    public void Recoil() {
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public String getBombInventoryName() {
        return "Mines";
    }

    @Override
    public String getMissileInventoryName() {
        return "Shells";
    }

    @Override
    public boolean hasMouseControlMode() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getCamera() {
        return null;
    }

    public boolean hasBothTracks() {
        boolean tracks = true;
        if (!this.isPartIntact(EnumDriveablePart.leftTrack)) {
            tracks = false;
        }
        if (!this.isPartIntact(EnumDriveablePart.rightTrack)) {
            tracks = false;
        }
        return tracks;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null) continue;
            wheel.func_70106_y();
        }
    }
}

