/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.CollisionBox;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.collisions.CollisionTest;
import com.flansmod.common.driveables.collisions.RidingEntityPosition;
import com.flansmod.common.guns.EntityBullet;
import com.flansmod.common.guns.raytracing.DriveableHit;
import com.flansmod.common.vector.Vector3f;
import net.minecraft.nbt.NBTTagCompound;

public class DriveablePart {
    public EnumDriveablePart type;
    public CollisionBox box;
    public float maxHealth;
    public float health;
    public float fireTime;
    public boolean onFire;
    public boolean dead;
    public EntityDriveable owner;
    public float penRes;

    public DriveablePart(EnumDriveablePart e, CollisionBox b) {
        this.type = e;
        this.box = b;
        this.maxHealth = b == null ? 0.0f : b.health;
        this.health = this.maxHealth;
        this.penRes = b == null ? 0.0f : b.penetrationResistance;
    }

    public void update(EntityDriveable driveable) {
        if (this.fireTime > 0.0f) {
            this.fireTime -= 1.0f;
        }
        if (this.fireTime == 0.0f) {
            this.onFire = false;
        }
        if (this.onFire) {
            this.health -= 1.0f;
        }
        if (this.health <= 0.0f && this.maxHealth > 0.0f) {
            this.dead = true;
        }
        if (this.health > this.maxHealth) {
            this.health = this.maxHealth;
        }
        this.owner = driveable;
    }

    public void writeToNBT(NBTTagCompound tags) {
        tags.func_74776_a(this.type.getShortName() + "_Health", this.health);
        tags.func_74757_a(this.type.getShortName() + "_Fire", this.onFire);
    }

    public void readFromNBT(NBTTagCompound tags) {
        if (!tags.func_74764_b(this.type.getShortName() + "_Health")) {
            this.health = this.maxHealth;
            this.onFire = false;
            return;
        }
        this.health = tags.func_74760_g(this.type.getShortName() + "_Health");
        this.onFire = tags.func_74767_n(this.type.getShortName() + "_Fire");
    }

    public float smashIntoGround(EntityDriveable driveable, float damage) {
        if (this.box == null || this.dead) {
            return 0.0f;
        }
        if (!driveable.canHitPart(this.type)) {
            return 0.0f;
        }
        if (this.maxHealth == 0.0f) {
            return damage;
        }
        this.health -= damage / 2.0f;
        return damage / 2.0f;
    }

    public DriveableHit rayTrace(EntityDriveable driveable, Vector3f origin, Vector3f motion) {
        float intersectX;
        float intersectZ;
        float intersectTime;
        if (this.box == null || this.health <= 0.0f || this.dead) {
            return null;
        }
        if (!driveable.canHitPart(this.type)) {
            return null;
        }
        if (motion.x != 0.0f) {
            float intersectY;
            if (origin.x < this.box.x) {
                intersectTime = (this.box.x - origin.x) / motion.x;
                intersectY = origin.y + motion.y * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectY >= this.box.y && intersectY <= this.box.y + this.box.h && intersectZ >= this.box.z && intersectZ <= this.box.z + this.box.d && intersectTime >= 0.0f) {
                    return new DriveableHit(driveable, this.type, intersectTime);
                }
            } else if (origin.x > this.box.x + this.box.w) {
                intersectTime = (this.box.x + this.box.w - origin.x) / motion.x;
                intersectY = origin.y + motion.y * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectY >= this.box.y && intersectY <= this.box.y + this.box.h && intersectZ >= this.box.z && intersectZ <= this.box.z + this.box.d && intersectTime >= 0.0f) {
                    return new DriveableHit(driveable, this.type, intersectTime);
                }
            }
        }
        if (motion.z != 0.0f) {
            float intersectY;
            if (origin.z < this.box.z) {
                intersectTime = (this.box.z - origin.z) / motion.z;
                intersectX = origin.x + motion.x * intersectTime;
                intersectY = origin.y + motion.y * intersectTime;
                if (intersectX >= this.box.x && intersectX <= this.box.x + this.box.w && intersectY >= this.box.y && intersectY <= this.box.y + this.box.h && intersectTime >= 0.0f) {
                    return new DriveableHit(driveable, this.type, intersectTime);
                }
            } else if (origin.z > this.box.z + this.box.d) {
                intersectTime = (this.box.z + this.box.d - origin.z) / motion.z;
                intersectX = origin.x + motion.x * intersectTime;
                intersectY = origin.y + motion.y * intersectTime;
                if (intersectX >= this.box.x && intersectX <= this.box.x + this.box.w && intersectY >= this.box.y && intersectY <= this.box.y + this.box.h && intersectTime >= 0.0f) {
                    return new DriveableHit(driveable, this.type, intersectTime);
                }
            }
        }
        if (motion.y != 0.0f) {
            if (origin.y < this.box.y) {
                intersectTime = (this.box.y - origin.y) / motion.y;
                intersectX = origin.x + motion.x * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectX >= this.box.x && intersectX <= this.box.x + this.box.w && intersectZ >= this.box.z && intersectZ <= this.box.z + this.box.d && intersectTime >= 0.0f) {
                    return new DriveableHit(driveable, this.type, intersectTime);
                }
            } else if (origin.y > this.box.y + this.box.h) {
                intersectTime = (this.box.y + this.box.h - origin.y) / motion.y;
                intersectX = origin.x + motion.x * intersectTime;
                intersectZ = origin.z + motion.z * intersectTime;
                if (intersectX >= this.box.x && intersectX <= this.box.x + this.box.w && intersectZ >= this.box.z && intersectZ <= this.box.z + this.box.d && intersectTime >= 0.0f) {
                    return new DriveableHit(driveable, this.type, intersectTime);
                }
            }
        }
        return null;
    }

    public RidingEntityPosition rayTraceRider(EntityDriveable driveable, CollisionTest tester) {
        if (this.box == null || this.health <= 0.0f || this.dead) {
            return null;
        }
        if (!driveable.canHitPart(this.type)) {
            return null;
        }
        double distance = 10.0;
        Vector3f collisionPoint = new Vector3f(0.0f, 0.0f, 0.0f);
        int surface = 0;
        Vector3f pos = new Vector3f(driveable.field_70165_t, driveable.field_70163_u, driveable.field_70161_v);
        RotatedAxes shift = driveable.axes;
        Vector3f p1 = shift.findLocalVectorGlobally(new Vector3f(this.box.x + this.box.w, this.box.y + this.box.h, this.box.z));
        Vector3f p2 = shift.findLocalVectorGlobally(new Vector3f(this.box.x + this.box.w, this.box.y + this.box.h, this.box.z + this.box.d));
        Vector3f p3 = shift.findLocalVectorGlobally(new Vector3f(this.box.x, this.box.y + this.box.h, this.box.z + this.box.d));
        Vector3f p4 = shift.findLocalVectorGlobally(new Vector3f(this.box.x, this.box.y + this.box.h, this.box.z));
        Vector3f p5 = shift.findLocalVectorGlobally(new Vector3f(this.box.x + this.box.w, this.box.y, this.box.z));
        Vector3f p6 = shift.findLocalVectorGlobally(new Vector3f(this.box.x + this.box.w, this.box.y, this.box.z + this.box.d));
        Vector3f p7 = shift.findLocalVectorGlobally(new Vector3f(this.box.x, this.box.y, this.box.z + this.box.d));
        Vector3f p8 = shift.findLocalVectorGlobally(new Vector3f(this.box.x, this.box.y, this.box.z));
        if (this.type == EnumDriveablePart.turret && driveable.seats[0] != null) {
            p1 = driveable.getPositionOnTurret(new Vector3f(this.box.x + this.box.w, this.box.y + this.box.h, this.box.z), false);
            p2 = driveable.getPositionOnTurret(new Vector3f(this.box.x + this.box.w, this.box.y + this.box.h, this.box.z + this.box.d), false);
            p3 = driveable.getPositionOnTurret(new Vector3f(this.box.x, this.box.y + this.box.h, this.box.z + this.box.d), false);
            p4 = driveable.getPositionOnTurret(new Vector3f(this.box.x, this.box.y + this.box.h, this.box.z), false);
            p5 = driveable.getPositionOnTurret(new Vector3f(this.box.x + this.box.w, this.box.y, this.box.z), false);
            p6 = driveable.getPositionOnTurret(new Vector3f(this.box.x + this.box.w, this.box.y, this.box.z + this.box.d), false);
            p7 = driveable.getPositionOnTurret(new Vector3f(this.box.x, this.box.y, this.box.z + this.box.d), false);
            p8 = driveable.getPositionOnTurret(new Vector3f(this.box.x, this.box.y, this.box.z), false);
        }
        double topFaceDist = 100.0;
        tester.checkTriangle(tester, p3, p2, p1);
        if (tester.didCollide && tester.nearestDistance < distance) {
            collisionPoint = tester.intersectionPoint;
            surface = 1;
            tester.part = this.type;
        }
        tester.checkTriangle(tester, p4, p3, p1);
        if (tester.didCollide && tester.nearestDistance < distance) {
            collisionPoint = tester.intersectionPoint;
            surface = 1;
            tester.part = this.type;
        }
        if (tester.didCollide) {
            tester.isOnTop = true;
            topFaceDist = tester.nearestDistance;
        }
        tester.checkTriangle(tester, p1, p2, p6);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 2;
            tester.part = this.type;
        }
        tester.checkTriangle(tester, p1, p6, p5);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 2;
            tester.part = this.type;
        }
        tester.checkTriangle(tester, p3, p4, p8);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 3;
            tester.part = this.type;
        }
        tester.checkTriangle(tester, p4, p8, p7);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 3;
            tester.part = this.type;
        }
        tester.checkTriangle(tester, p4, p1, p5);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 4;
            tester.part = this.type;
        }
        tester.checkTriangle(tester, p1, p5, p8);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 4;
            tester.part = this.type;
        }
        tester.checkTriangle(tester, p2, p3, p7);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 5;
            tester.part = this.type;
        }
        tester.checkTriangle(tester, p3, p7, p6);
        if (tester.didCollide && tester.nearestDistance < distance) {
            distance = tester.nearestDistance;
            collisionPoint = tester.intersectionPoint;
            surface = 5;
            tester.part = this.type;
        }
        if (tester.nearestDistance < topFaceDist) {
            tester.isOnTop = false;
        }
        if (surface == 1) {
            tester.isOnTop = true;
        }
        if (tester.didCollide) {
            return new RidingEntityPosition(collisionPoint.x, collisionPoint.y, collisionPoint.z, 1, distance, this.type);
        }
        return null;
    }

    public float hitByBullet(EntityBullet bullet, DriveableHit hit, float penetratingPower) {
        return this.hitByBullet(bullet, hit, penetratingPower, 1.0f);
    }

    public float hitByBullet(EntityBullet bullet, DriveableHit hit, float penetratingPower, float damageMod) {
        if (bullet != null) {
            float damageModifier = damageMod;
            if (penetratingPower <= 0.7f * this.penRes && FlansMod.useNewPenetrationSystem) {
                damageModifier *= (float)Math.pow(penetratingPower / (0.7f * this.penRes), 2.5);
            }
            bullet.lastHitPenAmount = Math.max(bullet.lastHitPenAmount, damageModifier);
            this.health = hit.driveable instanceof EntityPlane ? (this.health -= bullet.damage * bullet.type.damageVsPlanes * damageModifier) : (this.health -= bullet.damage * bullet.type.damageVsVehicles * damageModifier);
            if (bullet.type.setEntitiesOnFire) {
                this.fireTime = 20.0f;
                this.onFire = true;
            }
        }
        if (FlansMod.useNewPenetrationSystem) {
            return penetratingPower - this.box.penetrationResistance;
        }
        return penetratingPower - 5.0f;
    }

    private boolean coordIsEntering(float start, float end, float min, float max) {
        if (start < min && end >= min) {
            return true;
        }
        return start > max && end <= max;
    }

    private boolean coordIsIn(float start, float end, float min, float max) {
        if (start >= min && start <= max) {
            return true;
        }
        if (end >= min && end <= max) {
            return true;
        }
        if (start < min && end > max) {
            return true;
        }
        return end < min && start > max;
    }

    public boolean attack(float damage, boolean fireDamage) {
        this.health -= damage;
        if (fireDamage) {
            this.fireTime = 20.0f;
            this.onFire = true;
        }
        if (this.health < 0.0f) {
            this.health = 0.0f;
        }
        return this.health <= 0.0f;
    }
}

