/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.model;

import com.flansmod.client.FlansModClient;
import com.flansmod.client.FlansModResourceHandler;
import com.flansmod.client.model.EnumAnimationType;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.client.model.ModelAttachment;
import com.flansmod.client.model.ModelCasing;
import com.flansmod.client.model.ModelFlash;
import com.flansmod.client.model.ModelGun;
import com.flansmod.client.model.ModelRotateTool;
import com.flansmod.client.model.RenderArms;
import com.flansmod.common.FlansMod;
import com.flansmod.common.PlayerData;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.EnumFireMode;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.IScope;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.ItemShootable;
import com.flansmod.common.paintjob.Paintjob;
import com.flansmod.common.vector.Vector3f;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderGun
implements IItemRenderer {
    private static TextureManager renderEngine;
    public static float smoothing;

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        switch (type) {
            case ENTITY: {
                if (!Minecraft.func_71410_x().field_71474_y.field_74347_j) {
                    return false;
                }
            }
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                return item != null && item.func_77973_b() instanceof ItemGun && ((ItemGun)item.func_77973_b()).type.model != null;
            }
        }
        return false;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        EntityLivingBase entity;
        if (!(item.func_77973_b() instanceof ItemGun)) {
            return;
        }
        GunType gunType = ((ItemGun)item.func_77973_b()).type;
        if (gunType == null) {
            return;
        }
        ModelGun model = gunType.model;
        if (model == null) {
            return;
        }
        GunAnimations animations = type == IItemRenderer.ItemRenderType.ENTITY ? new GunAnimations() : FlansModClient.getGunAnimations((EntityLivingBase)data[1], false);
        this.setupGunRender(type, item, gunType, animations, false, data);
        if (gunType.getOneHanded() && type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON && (entity = (EntityLivingBase)data[1]) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            PlayerData playerData = PlayerHandler.getPlayerData(player, Side.CLIENT);
            if (playerData.offHandGunSlot != 0) {
                ItemStack offHandItem;
                animations = (GunAnimations)FlansModClient.gunAnimationsLeft.get(data[1]);
                if (animations == null) {
                    animations = new GunAnimations();
                    FlansModClient.gunAnimationsLeft.put((EntityLivingBase)data[1], animations);
                }
                if ((offHandItem = player.field_71071_by.func_70301_a(playerData.offHandGunSlot - 1)) == null || !(offHandItem.func_77973_b() instanceof ItemGun)) {
                    return;
                }
                GunType offHandGunType = ((ItemGun)offHandItem.func_77973_b()).type;
                if (!offHandGunType.getOneHanded()) {
                    return;
                }
                this.setupGunRender(type, offHandItem, offHandGunType, animations, true, data);
            }
        }
    }

    public void renderOffHandGun(EntityPlayer player, ItemStack offHandItemStack) {
        GunType offHandGunType;
        GunAnimations animations = (GunAnimations)FlansModClient.gunAnimationsLeft.get(player);
        if (animations == null) {
            animations = new GunAnimations();
            FlansModClient.gunAnimationsLeft.put(player, animations);
        }
        if (!(offHandGunType = ((ItemGun)offHandItemStack.func_77973_b()).type).getOneHanded()) {
            return;
        }
        this.setupGunRender(IItemRenderer.ItemRenderType.EQUIPPED, offHandItemStack, offHandGunType, animations, true, player);
    }

    private void setupGunRender(IItemRenderer.ItemRenderType type, ItemStack item, GunType gunType, GunAnimations animations, boolean offHand, Object ... data) {
        float f = 0.0625f;
        ModelGun model = gunType.model;
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderEntityMovement(model, data);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            this.renderEquippedMovement(model, offHand);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.renderEquippedFirstPersonMovement(gunType, item, model, offHand, animations);
        }
        this.renderGunModel(item, gunType, f, model, animations, type);
        GL11.glPopMatrix();
    }

    private void renderEntityMovement(ModelGun model, Object ... data) {
        EntityItem entity = (EntityItem)data[1];
        GL11.glRotatef((float)((float)entity.field_70292_b + (entity.field_70292_b == 0 ? 0.0f : smoothing)), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)(-0.2f + model.itemFrameOffset.x), (float)(0.2f + model.itemFrameOffset.y), (float)(0.1f + model.itemFrameOffset.z));
    }

    private void renderEquippedMovement(ModelGun model, boolean offHand) {
        if (offHand) {
            GL11.glRotatef((float)-70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)48.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)105.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.1f, (float)-0.22f, (float)-0.15f);
        } else {
            GL11.glRotatef((float)35.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.75f, (float)-0.22f, (float)-0.08f);
            GL11.glScalef((float)1.0f, (float)1.0f, (float)-1.0f);
        }
        GL11.glTranslatef((float)model.thirdPersonOffset.x, (float)model.thirdPersonOffset.y, (float)model.thirdPersonOffset.z);
    }

    private void renderEquippedFirstPersonMovement(GunType gunType, ItemStack item, ModelGun model, boolean offHand, GunAnimations animations) {
        boolean sprinting;
        int flip = offHand ? -1 : 1;
        IScope scope = gunType.getCurrentScope(item);
        float adsSwitch = FlansModClient.lastZoomProgress + (FlansModClient.zoomProgress - FlansModClient.lastZoomProgress) * smoothing;
        adsSwitch *= model.adsEffectMultiplier;
        boolean crouching = FlansModClient.zoomProgress + 0.1f > 0.9f && ItemGun.crouching && !animations.reloading;
        boolean bl = sprinting = FlansModClient.zoomProgress + 0.1f < 0.2f && ItemGun.sprinting && !animations.reloading && !ItemGun.shooting && model.fancyStance;
        if (FlansModClient.zoomProgress > 0.9f && scope.hasZoomOverlay() && !model.stillRenderGunWhenScopedOverlay) {
            GL11.glPopMatrix();
            return;
        }
        if (offHand) {
            GL11.glTranslatef((float)0.0f, (float)0.03f, (float)-0.76f);
            GL11.glRotatef((float)23.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-4.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.15f, (float)0.2f, (float)-0.6f);
        } else if (crouching) {
            GL11.glRotatef((float)(25.0f - 5.0f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.15f, (float)(0.2f + 0.175f * adsSwitch), (float)(-0.6f - 0.405f * adsSwitch));
            if (gunType.hasScopeOverlay && !model.stillRenderGunWhenScopedOverlay) {
                GL11.glTranslatef((float)(-0.3f * adsSwitch), (float)0.0f, (float)0.0f);
            }
            GL11.glRotatef((float)(4.5f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)model.crouchZoom, (float)(-0.03f * adsSwitch), (float)0.0f);
        } else {
            GL11.glRotatef((float)(25.0f - 5.0f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-5.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.15f, (float)(0.2f + 0.175f * adsSwitch), (float)(-0.6f - 0.405f * adsSwitch));
            if (gunType.hasScopeOverlay && !model.stillRenderGunWhenScopedOverlay) {
                GL11.glTranslatef((float)(-0.3f * adsSwitch), (float)0.0f, (float)0.0f);
            }
            GL11.glRotatef((float)(4.5f * adsSwitch), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)-0.0f, (float)(-0.03f * adsSwitch), (float)0.0f);
        }
        if (animations.switchAnimationProgress > 0.0f && animations.switchAnimationLength > 0.0f) {
            this.renderWeaponSwitchMovement(animations);
        }
        if (sprinting && animations.stanceTimer == 0 && FlansMod.enableWeaponSprintStance) {
            if (animations.runningStanceAnimationProgress == 0.0f) {
                animations.runningStanceAnimationProgress = 1.0f;
            }
            this.renderWeaponSprintMovement(animations, model, gunType);
        } else {
            animations.runningStanceAnimationProgress = 0.0f;
        }
        if (animations.meleeAnimationProgress > 0 && animations.meleeAnimationProgress < gunType.meleePath.size()) {
            this.renderMeleeMovement(gunType, animations);
        }
        if (model.spinningCocking) {
            GL11.glTranslatef((float)model.spinPoint.x, (float)model.spinPoint.y, (float)model.spinPoint.z);
            float pumped = animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing;
            GL11.glRotatef((float)(pumped * 180.0f + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-model.spinPoint.x), (float)(-model.spinPoint.y), (float)(-model.spinPoint.z));
        }
        if (animations.reloading) {
            this.renderReloadMovement(animations, model, gunType, item, flip);
        }
    }

    private void renderWeaponSwitchMovement(GunAnimations animations) {
        Vector3f pos1 = new Vector3f(0.0f, -0.4f, 0.0f);
        Vector3f pos2 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f startAngles = new Vector3f(90.0f, 30.0f, -40.0f);
        Vector3f endAngles = new Vector3f(0.0f, 0.0f, 0.0f);
        float interp = (animations.switchAnimationProgress + smoothing) / animations.switchAnimationLength;
        GL11.glTranslatef((float)(pos2.x + (pos2.x - pos1.x) * interp), (float)(pos1.y + (pos2.y - pos1.y) * interp), (float)(pos1.z + (pos2.z - pos1.z) * interp));
        GL11.glRotatef((float)(startAngles.y + (endAngles.y - startAngles.y) * interp), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(startAngles.z + (endAngles.z - startAngles.z) * interp), (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void renderWeaponSprintMovement(GunAnimations animations, ModelGun model, GunType gunType) {
        Vector3f defaultTranslate = new Vector3f(0.0, 0.0, -0.2);
        Vector3f defaultRotation = new Vector3f(-15.0f, 45.0f, -10.0f);
        Vector3f configuredTranslate = model.sprintStanceTranslate;
        Vector3f configuredRotation = model.sprintStanceRotate;
        float progress = (animations.runningStanceAnimationProgress + smoothing) / animations.runningStanceAnimationLength;
        if (animations.runningStanceAnimationProgress == animations.runningStanceAnimationLength) {
            progress = 1.0f;
        }
        if (FlansMod.enableRandomSprintStance) {
            animations.updateSprintStance(gunType.getShortName());
            defaultRotation = animations.sprintingStance;
        }
        if (!Objects.equals(model.sprintStanceTranslate, new Vector3f(0.0f, 0.0f, 0.0f))) {
            GL11.glTranslatef((float)(configuredTranslate.x * progress), (float)(configuredTranslate.y * progress), (float)(configuredTranslate.z * progress));
        } else {
            GL11.glTranslatef((float)(defaultTranslate.x * progress), (float)(defaultTranslate.y * progress), (float)(defaultTranslate.z * progress));
        }
        if (!Objects.equals(model.sprintStanceRotate, new Vector3f(0.0f, 0.0f, 0.0f))) {
            GL11.glRotatef((float)(configuredRotation.x * progress), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(configuredRotation.y * progress), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(configuredRotation.z * progress), (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GL11.glRotatef((float)(defaultRotation.x * progress), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(defaultRotation.y * progress), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(defaultRotation.z * progress), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    private void renderMeleeMovement(GunType gunType, GunAnimations animations) {
        Vector3f meleePos = gunType.meleePath.get(animations.meleeAnimationProgress);
        Vector3f nextMeleePos = animations.meleeAnimationProgress + 1 < gunType.meleePath.size() ? gunType.meleePath.get(animations.meleeAnimationProgress + 1) : new Vector3f();
        GL11.glTranslatef((float)(meleePos.x + (nextMeleePos.x - meleePos.x) * smoothing), (float)(meleePos.y + (nextMeleePos.y - meleePos.y) * smoothing), (float)(meleePos.z + (nextMeleePos.z - meleePos.z) * smoothing));
        Vector3f meleeAngles = gunType.meleePathAngles.get(animations.meleeAnimationProgress);
        Vector3f nextMeleeAngles = animations.meleeAnimationProgress + 1 < gunType.meleePathAngles.size() ? gunType.meleePathAngles.get(animations.meleeAnimationProgress + 1) : new Vector3f();
        GL11.glRotatef((float)(meleeAngles.y + (nextMeleeAngles.y - meleeAngles.y) * smoothing), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(meleeAngles.z + (nextMeleeAngles.z - meleeAngles.z) * smoothing), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(meleeAngles.x + (nextMeleeAngles.x - meleeAngles.x) * smoothing), (float)1.0f, (float)0.0f, (float)0.0f);
    }

    private void renderReloadMovement(GunAnimations animations, ModelGun model, GunType gunType, ItemStack item, int flip) {
        EnumAnimationType anim = model.animationType;
        if (gunType.getGrip(item) != null && gunType.getSecondaryFire(item)) {
            anim = gunType.getGrip((ItemStack)item).model.secondaryAnimType;
        }
        float reloadRotate = RenderGun.getReloadRotate(animations, model);
        switch (anim) {
            case BOTTOM_CLIP: 
            case PISTOL_CLIP: 
            case SHOTGUN: 
            case END_LOADED: {
                GL11.glRotatef((float)(60.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(30.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.25f * reloadRotate), (float)0.0f, (float)0.0f);
                break;
            }
            case CUSTOMBOTTOM_CLIP: 
            case CUSTOMPISTOL_CLIP: 
            case CUSTOMSHOTGUN: 
            case CUSTOMEND_LOADED: 
            case CUSTOMBACK_LOADED: 
            case CUSTOMBULLPUP: 
            case CUSTOMRIFLE: 
            case CUSTOMRIFLE_TOP: 
            case CUSTOMREVOLVER: 
            case CUSTOMREVOLVER2: 
            case CUSTOMALT_PISTOL_CLIP: 
            case CUSTOMSTRIKER: 
            case CUSTOMGENERIC: 
            case CUSTOM: {
                GL11.glRotatef((float)(model.rotateGunVertical * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(model.rotateGunHorizontal * reloadRotate), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(model.tiltGun * reloadRotate), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(model.translateGun.x * reloadRotate), (float)(model.translateGun.y * reloadRotate), (float)(model.translateGun.z * reloadRotate));
                break;
            }
            case BACK_LOADED: {
                GL11.glRotatef((float)(-75.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-30.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.5f * reloadRotate), (float)0.0f, (float)0.0f);
                break;
            }
            case BULLPUP: {
                GL11.glRotatef((float)(70.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(10.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.5f * reloadRotate), (float)(-0.2f * reloadRotate), (float)0.0f);
                break;
            }
            case RIFLE: {
                GL11.glRotatef((float)(30.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-30.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.5f * reloadRotate), (float)0.0f, (float)(-0.5f * reloadRotate));
                break;
            }
            case RIFLE_TOP: 
            case REVOLVER: {
                GL11.glRotatef((float)(30.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(10.0f * reloadRotate), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(-10.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.1f * reloadRotate), (float)(-0.2f * reloadRotate), (float)(-0.1f * reloadRotate));
                break;
            }
            case REVOLVER2: {
                GL11.glRotatef((float)(20.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(-10.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case ALT_PISTOL_CLIP: {
                GL11.glRotatef((float)(60.0f * reloadRotate * (float)flip), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.15f * reloadRotate), (float)(0.25f * reloadRotate), (float)0.0f);
                break;
            }
            case STRIKER: {
                GL11.glRotatef((float)(-35.0f * reloadRotate * (float)flip), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)(0.2f * reloadRotate), (float)0.0f, (float)(-0.1f * reloadRotate));
                break;
            }
            case GENERIC: {
                GL11.glRotatef((float)(45.0f * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)(-0.2f * reloadRotate), (float)(-0.5f * reloadRotate), (float)0.0f);
                break;
            }
        }
    }

    private static float getReloadRotate(GunAnimations animations, ModelGun model) {
        float reloadRotate = 1.0f;
        if (!animations.reloading) {
            return 0.0f;
        }
        float effectiveReloadAnimationProgress = animations.lastReloadAnimationProgress + (animations.reloadAnimationProgress - animations.lastReloadAnimationProgress) * smoothing;
        if (effectiveReloadAnimationProgress < model.tiltGunTime) {
            reloadRotate = effectiveReloadAnimationProgress / model.tiltGunTime;
        }
        if (effectiveReloadAnimationProgress > model.tiltGunTime + model.unloadClipTime + model.loadClipTime) {
            reloadRotate = 1.0f - (effectiveReloadAnimationProgress - (model.tiltGunTime + model.unloadClipTime + model.loadClipTime)) / model.untiltGunTime;
        }
        return reloadRotate;
    }

    public void renderGunModel(ItemStack item, GunType type, float f, ModelGun model, GunAnimations animations, IItemRenderer.ItemRenderType rtype) {
        if (renderEngine == null) {
            renderEngine = Minecraft.func_71410_x().field_71446_o;
        }
        if (animations == null) {
            animations = GunAnimations.defaults;
        }
        AttachmentType scopeAttachment = type.getScope(item);
        AttachmentType gripAttachment = type.getGrip(item);
        animations.recoilAmount = model.recoilAmount;
        ItemStack[] bulletStacks = new ItemStack[type.getNumAmmoItemsInGun(item)];
        boolean empty = true;
        int numRounds = 0;
        for (int i = 0; i < type.getNumAmmoItemsInGun(item); ++i) {
            bulletStacks[i] = ((ItemGun)item.func_77973_b()).getBulletItemStack(item, i);
            if (bulletStacks[i] == null || !(bulletStacks[i].func_77973_b() instanceof ItemShootable) || bulletStacks[i].func_77960_j() >= bulletStacks[i].func_77958_k()) continue;
            empty = false;
            numRounds += bulletStacks[i].func_77958_k() - bulletStacks[i].func_77960_j();
        }
        if (model.slideLockOnEmpty) {
            if (empty) {
                animations.onGunEmpty(true);
            } else if (!empty && !animations.reloading) {
                animations.onGunEmpty(false);
            }
        }
        GL11.glPushMatrix();
        if (rtype == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            if (FlansMod.armsEnable && model.hasArms) {
                Minecraft mc = Minecraft.func_71410_x();
                this.renderFirstPersonArm((EntityPlayer)mc.field_71439_g, model, animations);
            }
            this.handleGunRecoil(animations, model, this.getRecoilDistance(gripAttachment, type, item), this.getRecoilAngle(gripAttachment, type, item));
        }
        renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(type.getPaintjob(item.func_77960_j())));
        if (scopeAttachment != null && model.gunOffset != 0.0f && FlansModClient.zoomProgress >= 0.5f) {
            GL11.glTranslatef((float)0.0f, (float)(-scopeAttachment.model.renderOffset + model.gunOffset / 16.0f), (float)0.0f);
        }
        this.renderGunAndComponents(model, type, item, f, animations, numRounds, empty, rtype);
        this.renderCustomAttachments(model, type, item, f, animations);
        GL11.glPopMatrix();
    }

    private void renderCustomAttachments(ModelGun model, GunType type, ItemStack item, float f, GunAnimations animations) {
        ItemStack scopeItemStack = type.getScopeItemStack(item);
        ItemStack barrelItemStack = type.getBarrelItemStack(item);
        ItemStack stockItemStack = type.getStockItemStack(item);
        ItemStack gripItemStack = type.getGripItemStack(item);
        ItemStack gadgetItemStack = type.getGadgetItemStack(item);
        ItemStack slideItemStack = type.getSlideItemStack(item);
        ItemStack pumpItemStack = type.getPumpItemStack(item);
        ItemStack accessoryItemStack = type.getAccessoryItemStack(item);
        ArrayList<AttachmentType> attachments = type.getCurrentAttachments(item);
        for (AttachmentType attachment : attachments) {
            GL11.glPushMatrix();
            switch (attachment.type.name()) {
                case "sights": {
                    this.preRenderAttachment(attachment, scopeItemStack, model.scopeAttachPoint, type);
                    if (model.scopeIsOnBreakAction) {
                        GL11.glTranslatef((float)model.barrelBreakPoint.x, (float)model.barrelBreakPoint.y, (float)model.barrelBreakPoint.z);
                        GL11.glRotatef((float)(RenderGun.getReloadRotate(animations, model) * -model.breakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glTranslatef((float)(-model.barrelBreakPoint.x), (float)(-model.barrelBreakPoint.y), (float)(-model.barrelBreakPoint.z));
                    }
                    if (model.scopeIsOnSlide) {
                        GL11.glTranslatef((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.gunSlideDistance), (float)0.0f, (float)0.0f);
                    }
                    this.postRenderAttachment(attachment, scopeItemStack, f);
                    break;
                }
                case "grip": {
                    this.preRenderAttachment(attachment, gripItemStack, model.gripAttachPoint, type);
                    if (model.gripIsOnPump) {
                        GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
                    }
                    this.postRenderAttachment(attachment, gripItemStack, f);
                    break;
                }
                case "barrel": {
                    this.preRenderAttachment(attachment, barrelItemStack, model.barrelAttachPoint, type);
                    this.postRenderAttachment(attachment, barrelItemStack, f);
                    break;
                }
                case "stock": {
                    this.preRenderAttachment(attachment, stockItemStack, model.stockAttachPoint, type);
                    this.postRenderAttachment(attachment, stockItemStack, f);
                    break;
                }
                case "slide": {
                    this.preRenderAttachment(attachment, slideItemStack, model.slideAttachPoint, type);
                    GL11.glTranslatef((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.gunSlideDistance), (float)0.0f, (float)0.0f);
                    this.postRenderAttachment(attachment, slideItemStack, f);
                    break;
                }
                case "gadget": {
                    this.preRenderAttachment(attachment, gadgetItemStack, model.gadgetAttachPoint, type);
                    if (model.gadgetIsOnPump) {
                        GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
                    }
                    this.postRenderAttachment(attachment, gadgetItemStack, f);
                    break;
                }
                case "accessory": {
                    this.preRenderAttachment(attachment, accessoryItemStack, model.accessoryAttachPoint, type);
                    this.postRenderAttachment(attachment, accessoryItemStack, f);
                    break;
                }
                case "pump": {
                    this.preRenderAttachment(attachment, pumpItemStack, model.pumpAttachPoint, type);
                    GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
                    this.postRenderAttachment(attachment, pumpItemStack, f);
                    break;
                }
            }
            GL11.glPopMatrix();
        }
    }

    private void renderGunAndComponents(ModelGun model, GunType type, ItemStack item, float f, GunAnimations animations, int numRounds, boolean empty, IItemRenderer.ItemRenderType rtype) {
        AttachmentType scopeAttachment = type.getScope(item);
        AttachmentType barrelAttachment = type.getBarrel(item);
        AttachmentType stockAttachment = type.getStock(item);
        AttachmentType gripAttachment = type.getGrip(item);
        AttachmentType gadgetAttachment = type.getGadget(item);
        AttachmentType slideAttachment = type.getSlide(item);
        AttachmentType pumpAttachment = type.getPump(item);
        AttachmentType accessoryAttachment = type.getAccessory(item);
        ItemStack gripItemStack = type.getGripItemStack(item);
        GL11.glPushMatrix();
        GL11.glScalef((float)type.modelScale, (float)type.modelScale, (float)type.modelScale);
        this.renderMuzzleFlash(animations, model, type, barrelAttachment, item, f);
        model.renderGun(f);
        if (scopeAttachment == null && !model.scopeIsOnSlide && !model.scopeIsOnBreakAction) {
            model.renderDefaultScope(f);
        }
        if (barrelAttachment == null) {
            model.renderDefaultBarrel(f);
        }
        if (stockAttachment == null) {
            model.renderDefaultStock(f);
        }
        if (gripAttachment == null && !model.gripIsOnPump) {
            model.renderDefaultGrip(f);
        }
        if (gadgetAttachment == null && !model.gadgetIsOnPump) {
            model.renderDefaultGadget(f);
        }
        GL11.glPushMatrix();
        if (model.isBulletCounterActive) {
            model.renderBulletCounter(f, numRounds);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if (model.isAdvBulletCounterActive) {
            model.renderAdvBulletCounter(f, numRounds, model.countOnRightHandSide);
        }
        GL11.glPopMatrix();
        if (slideAttachment == null) {
            this.renderSlideModels(scopeAttachment, type, animations, model, f, item);
        }
        this.renderBreakAction(model, scopeAttachment, RenderGun.getReloadRotate(animations, model), f);
        this.renderHammer(model, animations, f);
        this.renderPumpAction(model, animations, pumpAttachment, f, gripAttachment, type, gadgetAttachment);
        this.renderBoltAction(model, animations, f, type);
        this.renderChargeHandle(model, animations, f);
        this.renderMinigunBarrels(type, model, animations, f);
        this.renderRevolverBarrel(model, RenderGun.getReloadRotate(animations, model), f);
        this.renderAmmo(model, type, gripAttachment, item, empty, animations, RenderGun.getReloadRotate(animations, model), rtype, f, gripItemStack);
        this.renderStaticAmmo(type, item, model, f, gripAttachment, gripItemStack);
        if (rtype == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON && FlansMod.casingEnable && type.casingModel != null && !type.getSecondaryFire(item)) {
            this.renderCasingEjection(type, animations, model, f, item);
        }
        GL11.glPopMatrix();
    }

    private void renderRevolverBarrel(ModelGun model, float reloadRotate, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)model.revolverFlipPoint.x, (float)model.revolverFlipPoint.y, (float)model.revolverFlipPoint.z);
        GL11.glRotatef((float)(reloadRotate * model.revolverFlipAngle), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(-model.revolverFlipPoint.x), (float)(-model.revolverFlipPoint.y), (float)(-model.revolverFlipPoint.z));
        model.renderRevolverBarrel(f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)model.revolverFlipPoint.x, (float)model.revolverFlipPoint.y, (float)model.revolverFlipPoint.z);
        GL11.glRotatef((float)(reloadRotate * model.revolverFlipAngle), (float)-1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(-model.revolverFlipPoint.x), (float)(-model.revolverFlipPoint.y), (float)(-model.revolverFlipPoint.z));
        model.renderRevolver2Barrel(f);
        GL11.glPopMatrix();
    }

    private void renderMinigunBarrels(GunType type, ModelGun model, GunAnimations animations, float f) {
        if (type.mode == EnumFireMode.MINIGUN) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)model.minigunBarrelOrigin.x, (float)model.minigunBarrelOrigin.y, (float)model.minigunBarrelOrigin.z);
            GL11.glRotatef((float)animations.minigunBarrelRotation, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-model.minigunBarrelOrigin.x), (float)(-model.minigunBarrelOrigin.y), (float)(-model.minigunBarrelOrigin.z));
            model.renderMinigunBarrel(f);
            GL11.glPopMatrix();
        }
    }

    private void renderChargeHandle(ModelGun model, GunAnimations animations, float f) {
        if (model.chargeHandleDistance != 0.0f) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastCharged + (animations.charged - animations.lastCharged) * smoothing)) * model.chargeHandleDistance), (float)0.0f, (float)0.0f);
            model.renderCharge(f);
            GL11.glPopMatrix();
        }
    }

    private void renderPumpAction(ModelGun model, GunAnimations animations, AttachmentType pumpAttachment, float f, AttachmentType gripAttachment, GunType type, AttachmentType gadgetAttachment) {
        if (pumpAttachment == null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
            model.renderPump(f);
            if (gripAttachment == null && model.gripIsOnPump) {
                model.renderDefaultGrip(f);
            }
            if (gadgetAttachment == null && model.gadgetIsOnPump) {
                model.renderDefaultGadget(f);
            }
            if (FlansModClient.shotState != -1 && (double)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance) != -0.0) {
                FlansModClient.shotState = -1;
                if (type.actionSound != null) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)FlansModResourceHandler.getSound(type.actionSound), (float)1.0f));
                }
            }
            GL11.glPopMatrix();
        }
        if (pumpAttachment == null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.pumpHandleDistance), (float)0.0f, (float)0.0f);
            float pumped = animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing;
            model.renderaltPump(f);
            if (gripAttachment == null && model.gripIsOnPump) {
                model.renderDefaultGrip(f);
            }
            if (gadgetAttachment == null && model.gadgetIsOnPump) {
                model.renderDefaultGadget(f);
            }
            GL11.glPopMatrix();
        }
    }

    private void renderBoltAction(ModelGun model, GunAnimations animations, float f, GunType type) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.boltCycleDistance), (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)model.boltRotationOffset.x, (float)model.boltRotationOffset.y, (float)model.boltRotationOffset.z);
        GL11.glRotatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.boltRotationAngle), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(-model.boltRotationOffset.x), (float)(-model.boltRotationOffset.y), (float)(-model.boltRotationOffset.z));
        model.renderBoltAction(f);
        GL11.glPopMatrix();
        if (FlansModClient.shotState != -1 && (double)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * model.boltCycleDistance) != -0.0) {
            FlansModClient.shotState = -1;
            if (type.actionSound != null) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)FlansModResourceHandler.getSound(type.actionSound), (float)1.0f));
            }
        }
    }

    private void renderHammer(ModelGun model, GunAnimations animations, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)model.hammerSpinPoint.x, (float)model.hammerSpinPoint.y, (float)model.hammerSpinPoint.z);
        GL11.glRotatef((float)(-animations.hammerRotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-model.hammerSpinPoint.x), (float)(-model.hammerSpinPoint.y), (float)(-model.hammerSpinPoint.z));
        model.renderHammer(f);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)model.althammerSpinPoint.x, (float)model.althammerSpinPoint.y, (float)model.althammerSpinPoint.z);
        GL11.glRotatef((float)(-animations.althammerRotation), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-model.althammerSpinPoint.x), (float)(-model.althammerSpinPoint.y), (float)(-model.althammerSpinPoint.z));
        model.renderaltHammer(f);
        GL11.glPopMatrix();
    }

    private void renderBreakAction(ModelGun model, AttachmentType scopeAttachment, float reloadRotate, float f) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)model.barrelBreakPoint.x, (float)model.barrelBreakPoint.y, (float)model.barrelBreakPoint.z);
        GL11.glRotatef((float)(reloadRotate * -model.breakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-model.barrelBreakPoint.x), (float)(-model.barrelBreakPoint.y), (float)(-model.barrelBreakPoint.z));
        model.renderBreakAction(f);
        if (scopeAttachment == null && model.scopeIsOnBreakAction) {
            model.renderDefaultScope(f);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)model.altbarrelBreakPoint.x, (float)model.altbarrelBreakPoint.y, (float)model.altbarrelBreakPoint.z);
        GL11.glRotatef((float)(reloadRotate * -model.altbreakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-model.altbarrelBreakPoint.x), (float)(-model.altbarrelBreakPoint.y), (float)(-model.altbarrelBreakPoint.z));
        model.renderaltBreakAction(f);
        GL11.glPopMatrix();
    }

    private void renderCasingEjection(GunType type, GunAnimations animations, ModelGun model, float f, ItemStack item) {
        ModelCasing casing = type.casingModel;
        GL11.glPushMatrix();
        float casingProg = ((float)animations.lastCasingStage + (float)(animations.casingStage - animations.lastCasingStage) * smoothing) / (float)model.casingAnimTime;
        if (casingProg >= 1.0f) {
            casingProg = 0.0f;
        }
        float moveX = model.casingAnimDistance.x + animations.casingRandom.x * model.casingAnimSpread.x;
        float moveY = model.casingAnimDistance.y + animations.casingRandom.y * model.casingAnimSpread.y;
        float moveZ = model.casingAnimDistance.z + animations.casingRandom.z * model.casingAnimSpread.z;
        GL11.glScalef((float)model.caseScale, (float)model.caseScale, (float)model.caseScale);
        GL11.glTranslatef((float)(model.casingAttachPoint.x + casingProg * moveX), (float)(model.casingAttachPoint.y + casingProg * moveY), (float)(model.casingAttachPoint.z + casingProg * moveZ));
        GL11.glRotatef((float)(casingProg * 180.0f), (float)model.casingRotateVector.x, (float)model.casingRotateVector.y, (float)model.casingRotateVector.z);
        renderEngine.func_110577_a(FlansModResourceHandler.getAuxiliaryTexture(type.casingTexture));
        casing.renderCasing(f);
        renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(type.getPaintjob(item.func_77960_j())));
        GL11.glPopMatrix();
    }

    private void renderStaticAmmo(GunType type, ItemStack item, ModelGun model, float f, AttachmentType gripAttachment, ItemStack gripItemStack) {
        GL11.glPushMatrix();
        if (type.getSecondaryFire(item)) {
            model.renderAmmo(f);
        } else if (gripAttachment != null && !type.getSecondaryFire(item)) {
            this.renderAttachmentAmmo(f, gripAttachment, model, gripAttachment.getPaintjob(gripItemStack.func_77960_j()), type.getPaintjob(item.func_77960_j()));
        }
        GL11.glPopMatrix();
    }

    private void renderAmmo(ModelGun model, GunType type, AttachmentType gripAttachment, ItemStack item, boolean empty, GunAnimations animations, float reloadRotate, IItemRenderer.ItemRenderType rtype, float f, ItemStack gripItemStack) {
        float effectiveReloadAnimationProgress;
        GL11.glPushMatrix();
        boolean shouldRender = true;
        EnumAnimationType anim = model.animationType;
        if (gripAttachment != null && type.getSecondaryFire(item)) {
            anim = gripAttachment.model.secondaryAnimType;
        }
        float tiltGunTime = model.tiltGunTime;
        float unloadClipTime = model.unloadClipTime;
        float loadClipTime = model.loadClipTime;
        if (gripAttachment != null && type.getSecondaryFire(item)) {
            tiltGunTime = gripAttachment.model.tiltGunTime;
            unloadClipTime = gripAttachment.model.unloadClipTime;
            loadClipTime = gripAttachment.model.loadClipTime;
        }
        if ((anim == EnumAnimationType.END_LOADED || anim == EnumAnimationType.BACK_LOADED) && empty && !animations.reloading) {
            shouldRender = false;
        }
        if (shouldRender && animations.reloading && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            effectiveReloadAnimationProgress = animations.lastReloadAnimationProgress + (animations.reloadAnimationProgress - animations.lastReloadAnimationProgress) * smoothing;
            float clipPosition = 0.0f;
            if (effectiveReloadAnimationProgress > tiltGunTime && effectiveReloadAnimationProgress < tiltGunTime + unloadClipTime) {
                clipPosition = (effectiveReloadAnimationProgress - tiltGunTime) / unloadClipTime;
            }
            if (effectiveReloadAnimationProgress >= tiltGunTime + unloadClipTime && effectiveReloadAnimationProgress < tiltGunTime + unloadClipTime + loadClipTime) {
                clipPosition = 1.0f - (effectiveReloadAnimationProgress - (tiltGunTime + unloadClipTime)) / loadClipTime;
            }
            float loadOnlyClipPosition = Math.max(0.0f, Math.min(1.0f, 1.0f - (effectiveReloadAnimationProgress - tiltGunTime) / (unloadClipTime + loadClipTime)));
            switch (anim) {
                case BREAK_ACTION: 
                case CUSTOMBREAK_ACTION: {
                    GL11.glTranslatef((float)model.barrelBreakPoint.x, (float)model.barrelBreakPoint.y, (float)model.barrelBreakPoint.z);
                    GL11.glRotatef((float)(reloadRotate * -model.breakAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-model.barrelBreakPoint.x), (float)(-model.barrelBreakPoint.y), (float)(-model.barrelBreakPoint.z));
                    GL11.glTranslatef((float)(-model.breakActionAmmoDistance * clipPosition * 1.0f / type.modelScale), (float)0.0f, (float)0.0f);
                    break;
                }
                case CUSTOMREVOLVER: 
                case REVOLVER: {
                    GL11.glTranslatef((float)model.revolverFlipPoint.x, (float)model.revolverFlipPoint.y, (float)model.revolverFlipPoint.z);
                    GL11.glRotatef((float)(reloadRotate * model.revolverFlipAngle), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(-model.revolverFlipPoint.x), (float)(-model.revolverFlipPoint.y), (float)(-model.revolverFlipPoint.z));
                    GL11.glTranslatef((float)(-1.0f * clipPosition * 1.0f / type.modelScale), (float)0.0f, (float)0.0f);
                    break;
                }
                case CUSTOMREVOLVER2: 
                case REVOLVER2: {
                    GL11.glTranslatef((float)model.revolver2FlipPoint.x, (float)model.revolver2FlipPoint.y, (float)model.revolver2FlipPoint.z);
                    GL11.glRotatef((float)(reloadRotate * model.revolver2FlipAngle), (float)-1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(-model.revolver2FlipPoint.x), (float)(-model.revolver2FlipPoint.y), (float)(-model.revolver2FlipPoint.z));
                    GL11.glTranslatef((float)(-1.0f * clipPosition * 1.0f / type.modelScale), (float)0.0f, (float)0.0f);
                    break;
                }
                case BOTTOM_CLIP: 
                case CUSTOMBOTTOM_CLIP: {
                    GL11.glRotatef((float)(-180.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(60.0f * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(0.5f * clipPosition * 1.0f / type.modelScale), (float)0.0f, (float)0.0f);
                    break;
                }
                case PISTOL_CLIP: 
                case CUSTOMPISTOL_CLIP: {
                    GL11.glRotatef((float)(-90.0f * clipPosition * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-1.0f * clipPosition * 1.0f / type.modelScale), (float)0.0f);
                    break;
                }
                case CUSTOMALT_PISTOL_CLIP: 
                case ALT_PISTOL_CLIP: {
                    GL11.glRotatef((float)(5.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(-3.0f * clipPosition * 1.0f / type.modelScale), (float)0.0f);
                    break;
                }
                case SIDE_CLIP: 
                case CUSTOMSIDE_CLIP: {
                    GL11.glRotatef((float)(180.0f * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(60.0f * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)(0.5f * clipPosition * 1.0f / type.modelScale), (float)0.0f, (float)0.0f);
                    break;
                }
                case CUSTOMBULLPUP: 
                case BULLPUP: {
                    GL11.glRotatef((float)(-150.0f * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(60.0f * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(1.0f * clipPosition * 1.0f / type.modelScale), (float)(-0.5f * clipPosition * 1.0f / type.modelScale), (float)0.0f);
                    break;
                }
                case P90: 
                case CUSTOMP90: {
                    GL11.glRotatef((float)(-15.0f * reloadRotate * reloadRotate), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)0.0f, (float)(0.075f * reloadRotate), (float)0.0f);
                    GL11.glTranslatef((float)(-2.0f * clipPosition * 1.0f / type.modelScale), (float)(-0.3f * clipPosition * 1.0f / type.modelScale), (float)(0.5f * clipPosition * 1.0f / type.modelScale));
                    break;
                }
                case RIFLE: {
                    float ammoPosition = clipPosition * this.getNumBulletsInReload(animations, gripAttachment, type, item);
                    int bulletNum = MathHelper.func_76141_d((float)ammoPosition);
                    float bulletProgress = ammoPosition - (float)bulletNum;
                    GL11.glRotatef((float)(bulletProgress * 15.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(bulletProgress * 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(bulletProgress * -1.0f * 1.0f / type.modelScale), (float)0.0f, (float)(bulletProgress * 0.5f * 1.0f / type.modelScale));
                    break;
                }
                case CUSTOMRIFLE: {
                    float maxBullets = this.getNumBulletsInReload(animations, gripAttachment, type, item);
                    float ammoPosition = clipPosition * maxBullets;
                    int bulletNum = MathHelper.func_76141_d((float)ammoPosition);
                    float bulletProgress = ammoPosition - (float)bulletNum;
                    if (type.getNumAmmoItemsInGun(item) > 1 && type.bulletInsert != null && FlansModClient.lastBulletReload != -2) {
                        if (maxBullets == 2.0f && FlansModClient.lastBulletReload != -1) {
                            int time = (int)(animations.reloadAnimationTime / maxBullets);
                            Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)FlansModResourceHandler.getSound(type.bulletInsert), (float)1.0f), time);
                            FlansModClient.lastBulletReload = -1;
                        } else if (bulletNum == (int)maxBullets || bulletNum == FlansModClient.lastBulletReload - 1) {
                            FlansModClient.lastBulletReload = bulletNum;
                            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)FlansModResourceHandler.getSound(type.bulletInsert), (float)1.0f));
                        }
                        if ((double)ammoPosition < 0.03 && bulletProgress > 0.0f) {
                            FlansModClient.lastBulletReload = -2;
                            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)FlansModResourceHandler.getSound(type.bulletInsert), (float)1.0f));
                        }
                    }
                    GL11.glRotatef((float)(bulletProgress * model.rotateClipVertical), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(bulletProgress * model.rotateClipHorizontal), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(bulletProgress * model.tiltClip), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(bulletProgress * model.translateClip.x / type.modelScale), (float)(bulletProgress * model.translateClip.y / type.modelScale), (float)(bulletProgress * model.translateClip.z / type.modelScale));
                    break;
                }
                case CUSTOMRIFLE_TOP: 
                case RIFLE_TOP: {
                    float ammoPosition = clipPosition * this.getNumBulletsInReload(animations, gripAttachment, type, item);
                    int bulletNum = MathHelper.func_76141_d((float)ammoPosition);
                    float bulletProgress = ammoPosition - (float)bulletNum;
                    GL11.glRotatef((float)(bulletProgress * 55.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(bulletProgress * 95.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(bulletProgress * -0.1f * 1.0f / type.modelScale), (float)(bulletProgress * 1.0f * 1.0f / type.modelScale), (float)(bulletProgress * 0.5f * 1.0f / type.modelScale));
                    break;
                }
                case SHOTGUN: 
                case CUSTOMSHOTGUN: 
                case CUSTOMSTRIKER: 
                case STRIKER: {
                    float maxBullets = this.getNumBulletsInReload(animations, gripAttachment, type, item);
                    float ammoPosition = clipPosition * maxBullets;
                    int bulletNum = MathHelper.func_76141_d((float)ammoPosition);
                    float bulletProgress = ammoPosition - (float)bulletNum;
                    if (maxBullets > 1.0f && type.getNumAmmoItemsInGun(item) > 1 && type.bulletInsert != null && FlansModClient.lastBulletReload != -2) {
                        if (maxBullets == 2.0f && FlansModClient.lastBulletReload != -1) {
                            int time = (int)(animations.reloadAnimationTime / maxBullets);
                            Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)FlansModResourceHandler.getSound(type.bulletInsert), (float)1.0f), time);
                            FlansModClient.lastBulletReload = -1;
                        } else if (bulletNum == (int)maxBullets || bulletNum == FlansModClient.lastBulletReload - 1) {
                            FlansModClient.lastBulletReload = bulletNum;
                            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)FlansModResourceHandler.getSound(type.bulletInsert), (float)1.0f));
                        }
                        if ((double)ammoPosition < 0.03 && bulletProgress > 0.0f) {
                            FlansModClient.lastBulletReload = -2;
                            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)FlansModResourceHandler.getSound(type.bulletInsert), (float)1.0f));
                        }
                    }
                    GL11.glRotatef((float)(bulletProgress * -30.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(bulletProgress * -0.5f * 1.0f / type.modelScale), (float)(bulletProgress * -1.0f * 1.0f / type.modelScale), (float)0.0f);
                    break;
                }
                case CUSTOM: {
                    if ((double)effectiveReloadAnimationProgress < 0.5 && model.stagedReload) {
                        GL11.glRotatef((float)(model.rotateClipVertical * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(model.rotateClipHorizontal * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(model.tiltClip * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(model.translateClip.x * clipPosition * 1.0f / type.modelScale), (float)(model.translateClip.y * clipPosition * 1.0f / type.modelScale), (float)(model.translateClip.z * clipPosition * 1.0f / type.modelScale));
                        break;
                    }
                    if ((double)effectiveReloadAnimationProgress > 0.5 && model.stagedReload) {
                        GL11.glRotatef((float)(model.stagedrotateClipVertical * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glRotatef((float)(model.stagedrotateClipHorizontal * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                        GL11.glRotatef((float)(model.stagedtiltClip * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                        GL11.glTranslatef((float)(model.stagedtranslateClip.x * clipPosition * 1.0f / type.modelScale), (float)(model.stagedtranslateClip.y * clipPosition * 1.0f / type.modelScale), (float)(model.stagedtranslateClip.z * clipPosition * 1.0f / type.modelScale));
                        break;
                    }
                    GL11.glRotatef((float)(model.rotateClipVertical * clipPosition), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glRotatef((float)(model.rotateClipHorizontal * clipPosition), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(model.tiltClip * clipPosition), (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)(model.translateClip.x * clipPosition * 1.0f / type.modelScale), (float)(model.translateClip.y * clipPosition * 1.0f / type.modelScale), (float)(model.translateClip.z * clipPosition * 1.0f / type.modelScale));
                    break;
                }
                case END_LOADED: 
                case CUSTOMEND_LOADED: {
                    float dYaw = loadOnlyClipPosition > 0.5f ? loadOnlyClipPosition * 2.0f - 1.0f : 0.0f;
                    GL11.glRotatef((float)(-45.0f * dYaw), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-this.getEndLoadedDistance(gripAttachment, type, item) * dYaw), (float)(-0.5f * dYaw), (float)0.0f);
                    float xDisplacement = loadOnlyClipPosition < 0.5f ? loadOnlyClipPosition * 2.0f : 1.0f;
                    GL11.glTranslatef((float)(this.getEndLoadedDistance(gripAttachment, type, item) * xDisplacement), (float)0.0f, (float)0.0f);
                    break;
                }
                case CUSTOMBACK_LOADED: 
                case BACK_LOADED: {
                    float dYaw = loadOnlyClipPosition > 0.5f ? loadOnlyClipPosition * 2.0f - 1.0f : 0.0f;
                    GL11.glTranslatef((float)(this.getEndLoadedDistance(gripAttachment, type, item) * dYaw), (float)(-0.5f * dYaw), (float)0.0f);
                    float xDisplacement = loadOnlyClipPosition < 0.5f ? loadOnlyClipPosition * 2.0f : 1.0f;
                    GL11.glTranslatef((float)(-this.getEndLoadedDistance(gripAttachment, type, item) * xDisplacement), (float)0.0f, (float)0.0f);
                }
            }
        }
        if (rtype == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON && model.hasArms && FlansMod.armsEnable) {
            Minecraft mc = Minecraft.func_71410_x();
            this.renderAnimArm((EntityPlayer)mc.field_71439_g, model, type, animations);
        }
        renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(type.getPaintjob(item.func_77960_j())));
        if (shouldRender) {
            if (gripAttachment != null && type.getSecondaryFire(item)) {
                this.renderAttachmentAmmo(f, gripAttachment, model, gripAttachment.getPaintjob(gripItemStack.func_77960_j()), type.getPaintjob(item.func_77960_j()));
            } else {
                model.renderAmmo(f);
            }
        }
        if ((double)(effectiveReloadAnimationProgress = animations.lastReloadAnimationProgress + (animations.reloadAnimationProgress - animations.lastReloadAnimationProgress) * smoothing) > 0.5) {
            model.renderfullAmmo(f);
        }
        GL11.glPopMatrix();
    }

    private void renderMuzzleFlash(GunAnimations animations, ModelGun model, GunType type, AttachmentType barrelAttachment, ItemStack item, float f) {
        boolean isFlashEnabled;
        boolean bl = isFlashEnabled = barrelAttachment == null || !barrelAttachment.disableMuzzleFlash;
        if (isFlashEnabled && animations.muzzleFlashTime > 0 && type.flashModel != null && !type.getSecondaryFire(item)) {
            Vector3f base;
            GL11.glPushMatrix();
            ModelFlash flash = type.flashModel;
            GL11.glScalef((float)model.flashScale, (float)model.flashScale, (float)model.flashScale);
            Vector3f vector3f = base = model.muzzleFlashPoint == null ? Vector3f.Zero : model.muzzleFlashPoint;
            if (barrelAttachment != null) {
                Vector3f barrelOffset = barrelAttachment.model != null && barrelAttachment.model.attachmentFlashOffset != null ? barrelAttachment.model.attachmentFlashOffset : Vector3f.Zero;
                GL11.glTranslatef((float)(base.x + barrelOffset.x), (float)(base.y + barrelOffset.y), (float)(base.z + barrelOffset.z));
            } else {
                Vector3f defaultOffset = model.defaultBarrelFlashPoint == null ? Vector3f.Zero : model.defaultBarrelFlashPoint;
                GL11.glTranslatef((float)(base.x + defaultOffset.x), (float)(base.y + defaultOffset.y), (float)(base.z + defaultOffset.z));
            }
            renderEngine.func_110577_a(FlansModResourceHandler.getAuxiliaryTexture(type.flashTexture));
            ModelGun.glowOn();
            flash.renderFlash(f, animations.flashInt);
            ModelGun.glowOff();
            renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(type.getPaintjob(item.func_77960_j())));
            GL11.glPopMatrix();
        }
    }

    private void renderSlideModels(AttachmentType scopeAttachment, GunType type, GunAnimations animations, ModelGun model, float f, ItemStack item) {
        GL11.glPushMatrix();
        if (!type.getSecondaryFire(item)) {
            GL11.glTranslatef((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.gunSlideDistance), (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)(-(1.0f - Math.abs(animations.lastCharged + (animations.charged - animations.lastCharged) * smoothing)) * model.chargeHandleDistance), (float)0.0f, (float)0.0f);
        }
        model.renderSlide(f);
        if (scopeAttachment == null && model.scopeIsOnSlide) {
            model.renderDefaultScope(f);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if (!type.getSecondaryFire(item)) {
            GL11.glTranslatef((float)(-(animations.lastGunSlide + (animations.gunSlide - animations.lastGunSlide) * smoothing) * model.altgunSlideDistance), (float)0.0f, (float)0.0f);
            model.renderaltSlide(f);
        }
        GL11.glPopMatrix();
    }

    private void handleGunRecoil(GunAnimations animations, ModelGun model, float recoilDistance, float recoilAngle) {
        float min = -1.5f;
        float max = 1.5f;
        float randomNum = new Random().nextFloat();
        float result = min + randomNum * (max - min);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)(-(animations.lastGunRecoil + (animations.gunRecoil - animations.lastGunRecoil) * smoothing) * recoilDistance), (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(-(animations.lastGunRecoil + (animations.gunRecoil - animations.lastGunRecoil) * smoothing) * recoilAngle), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)((-animations.lastGunRecoil + (animations.gunRecoil - animations.lastGunRecoil) * smoothing) * result * smoothing * model.ShakeDistance), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)((-animations.lastGunRecoil + (animations.gunRecoil - animations.lastGunRecoil) * smoothing) * result * smoothing * model.ShakeDistance), (float)1.0f, (float)0.0f, (float)0.0f);
        if (model.animationType == EnumAnimationType.SHOTGUN && !animations.reloading) {
            GL11.glRotatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * -5.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-(1.0f - Math.abs(animations.lastPumped + (animations.pumped - animations.lastPumped) * smoothing)) * 5.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (model.isSingleAction) {
            GL11.glRotatef((float)(-(1.0f - Math.abs(animations.lastGunPullback + (animations.gunPullback - animations.lastGunPullback) * smoothing)) * -5.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)(-(1.0f - Math.abs(animations.lastGunPullback + (animations.gunPullback - animations.lastGunPullback) * smoothing)) * 2.5f), (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    private void preRenderAttachment(AttachmentType attachment, ItemStack stack, Vector3f model, GunType type) {
        Paintjob paintjob = attachment.getPaintjob(stack.func_77960_j());
        renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(paintjob));
        GL11.glTranslatef((float)(model.x * type.modelScale), (float)(model.y * type.modelScale), (float)(model.z * type.modelScale));
        GL11.glScalef((float)attachment.modelScale, (float)attachment.modelScale, (float)attachment.modelScale);
    }

    private void postRenderAttachment(AttachmentType attachment, ItemStack stack, float f) {
        Paintjob paintjob = attachment.getPaintjob(stack.func_77960_j());
        ModelAttachment model = attachment.model;
        if (model != null) {
            model.renderAttachment(f);
        }
        renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(paintjob));
    }

    private void renderAttachmentAmmo(float f, AttachmentType grip, ModelGun model, Paintjob ammo, Paintjob otherAmmo) {
        renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(ammo));
        GL11.glTranslatef((float)model.gripAttachPoint.x, (float)model.gripAttachPoint.y, (float)model.gripAttachPoint.z);
        grip.model.renderAttachmentAmmo(f);
        renderEngine.func_110577_a(FlansModResourceHandler.getPaintjobTexture(otherAmmo));
    }

    private void renderArms(EntityPlayer player, ModelGun model, GunType type, GunAnimations anim) {
    }

    private void renderFirstPersonArm(EntityPlayer player, ModelGun model, GunAnimations anim) {
        Minecraft mc = Minecraft.func_71410_x();
        ModelBiped modelBipedMain = new ModelBiped(0.0f);
        mc.field_71446_o.func_110577_a(mc.field_71439_g.func_110306_p());
        float f = 1.0f;
        GL11.glColor3f((float)f, (float)f, (float)f);
        modelBipedMain.field_78095_p = 0.0f;
        GL11.glPushMatrix();
        if (!anim.reloading && model.righthandPump) {
            RenderArms.renderArmPump(model, anim, smoothing, model.rightArmRot, model.rightArmPos);
        } else if ((double)anim.charged < 0.9 && model.leftHandAmmo && model.rightHandCharge && anim.charged != -1.0f) {
            RenderArms.renderArmCharge(model, anim, smoothing, model.rightArmChargeRot, model.rightArmChargePos);
        } else if ((double)anim.pumped < 0.9 && model.rightHandBolt && model.leftHandAmmo) {
            RenderArms.renderArmBolt(model, anim, smoothing, model.rightArmChargeRot, model.rightArmChargePos);
        } else if (!anim.reloading && !model.righthandPump) {
            RenderArms.renderArmDefault(model, anim, smoothing, model.rightArmRot, model.rightArmPos);
        } else {
            RenderArms.renderArmReload(model, anim, smoothing, model.rightArmReloadRot, model.rightArmReloadPos);
        }
        GL11.glScalef((float)model.rightArmScale.x, (float)model.rightArmScale.y, (float)model.rightArmScale.z);
        modelBipedMain.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        modelBipedMain.field_78112_f.field_82908_p = 0.0f;
        if (!model.rightHandAmmo) {
            modelBipedMain.field_78112_f.func_78785_a(0.0625f);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if (!anim.reloading && model.lefthandPump) {
            RenderArms.renderArmPump(model, anim, smoothing, model.leftArmRot, model.leftArmPos);
        } else if ((double)anim.charged < 0.9 && model.rightHandCharge && model.leftHandAmmo && anim.charged != -1.0f) {
            RenderArms.renderArmCharge(model, anim, smoothing, model.leftArmChargeRot, model.leftArmChargePos);
        } else if ((double)anim.pumped < 0.9 && model.rightHandBolt && model.leftHandAmmo) {
            RenderArms.renderArmBolt(model, anim, smoothing, model.leftArmChargeRot, model.leftArmChargePos);
        } else if (!anim.reloading && !model.lefthandPump) {
            RenderArms.renderArmDefault(model, anim, smoothing, model.leftArmRot, model.leftArmPos);
        } else {
            RenderArms.renderArmReload(model, anim, smoothing, model.leftArmReloadRot, model.leftArmReloadPos);
        }
        GL11.glScalef((float)model.leftArmScale.x, (float)model.leftArmScale.y, (float)model.leftArmScale.z);
        modelBipedMain.field_78113_g.field_82908_p = 0.0f;
        if (!model.leftHandAmmo) {
            modelBipedMain.field_78113_g.func_78785_a(0.0625f);
        }
        GL11.glPopMatrix();
    }

    private void renderAnimArm(EntityPlayer player, ModelGun model, GunType type, GunAnimations anim) {
        Minecraft mc = Minecraft.func_71410_x();
        ModelBiped modelBipedMain = new ModelBiped(0.0f);
        mc.field_71446_o.func_110577_a(mc.field_71439_g.func_110306_p());
        GL11.glPushMatrix();
        GL11.glScalef((float)(1.0f / type.modelScale), (float)(1.0f / type.modelScale), (float)(1.0f / type.modelScale));
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        float effectiveReloadAnimationProgress = anim.lastReloadAnimationProgress + (anim.reloadAnimationProgress - anim.lastReloadAnimationProgress) * smoothing;
        if ((double)anim.charged < 0.9 && model.rightHandCharge && model.rightHandAmmo && anim.charged != -1.0f) {
            RenderArms.renderArmPump(model, anim, smoothing, model.rightArmRot, model.rightArmPos);
        } else if ((double)anim.pumped < 0.9 && model.rightHandBolt && model.rightHandAmmo) {
            RenderArms.renderArmBolt(model, anim, smoothing, model.rightArmChargeRot, model.rightArmChargePos);
        } else if (!anim.reloading) {
            RenderArms.renderArmDefault(model, anim, smoothing, model.rightArmRot, model.rightArmPos);
        } else {
            RenderArms.renderArmReload(model, anim, smoothing, model.rightArmReloadRot, model.rightArmReloadPos);
        }
        GL11.glScalef((float)model.rightArmScale.x, (float)model.rightArmScale.y, (float)model.rightArmScale.z);
        modelBipedMain.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        modelBipedMain.field_78112_f.field_82908_p = 0.0f;
        if (model.rightHandAmmo) {
            modelBipedMain.field_78112_f.func_78785_a(0.0625f);
        }
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        if ((double)anim.charged < 0.9 && model.leftHandCharge && model.leftHandAmmo && anim.charged != -1.0f) {
            RenderArms.renderArmCharge(model, anim, smoothing, model.leftArmChargeRot, model.leftArmChargePos);
        } else if (!anim.reloading && model.lefthandPump) {
            RenderArms.renderArmPump(model, anim, smoothing, model.leftArmRot, model.leftArmPos);
        } else if (!anim.reloading) {
            RenderArms.renderArmDefault(model, anim, smoothing, model.leftArmRot, model.leftArmPos);
        } else if ((double)effectiveReloadAnimationProgress < 0.5 && model.stagedleftArmReloadPos.x != 0.0f) {
            RenderArms.renderArmReload(model, anim, smoothing, model.leftArmReloadRot, model.leftArmReloadPos);
        } else if ((double)effectiveReloadAnimationProgress > 0.5 && model.stagedleftArmReloadPos.x != 0.0f) {
            RenderArms.renderArmReload(model, anim, smoothing, model.stagedleftArmReloadRot, model.stagedleftArmReloadPos);
        } else {
            RenderArms.renderArmReload(model, anim, smoothing, model.leftArmReloadRot, model.leftArmReloadPos);
        }
        GL11.glScalef((float)model.leftArmScale.x, (float)model.leftArmScale.y, (float)model.leftArmScale.z);
        modelBipedMain.field_78113_g.field_82908_p = 0.0f;
        if (model.leftHandAmmo) {
            modelBipedMain.field_78113_g.func_78785_a(0.0625f);
        }
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    private float getEndLoadedDistance(AttachmentType grip, GunType gun, ItemStack gunStack) {
        if (grip != null && gun.getSecondaryFire(gunStack)) {
            return grip.model.endLoadedAmmoDistance;
        }
        return gun.model.endLoadedAmmoDistance;
    }

    private float getNumBulletsInReload(GunAnimations animations, AttachmentType grip, GunType gun, ItemStack gunStack) {
        if (animations.singlesReload) {
            return animations.reloadAmmoCount;
        }
        return gun.model.numBulletsInReloadAnimation;
    }

    private float getRecoilDistance(AttachmentType grip, GunType gun, ItemStack gunStack) {
        if (grip != null && gun.getSecondaryFire(gunStack)) {
            return grip.model.recoilDistance;
        }
        return gun.model.RecoilSlideDistance;
    }

    private float getRecoilAngle(AttachmentType grip, GunType gun, ItemStack gunStack) {
        if (grip != null && gun.getSecondaryFire(gunStack)) {
            return grip.model.recoilAngle;
        }
        return gun.model.RotateSlideDistance;
    }

    private void injectRotationTool(float f, ModelGun model) {
        ModelRotateTool rotateToolModel = new ModelRotateTool();
        GL11.glPushMatrix();
        ModelRotateTool tool = rotateToolModel;
        GL11.glTranslatef((float)model.rotationToolOffset.x, (float)model.rotationToolOffset.y, (float)model.rotationToolOffset.z);
        renderEngine.func_110577_a(new ResourceLocation(null, "err"));
        tool.renderRotateTool(f);
        GL11.glTranslatef((float)(-model.rotationToolOffset.x), (float)(-model.rotationToolOffset.y), (float)(-model.rotationToolOffset.z));
        GL11.glPopMatrix();
    }
}

