/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.client.gui;

import com.flansmod.client.ClientProxy;
import com.flansmod.client.model.GunAnimations;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.ContainerGunModTable;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.network.PacketGunPaint;
import com.flansmod.common.paintjob.Paintjob;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiGunModTable
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("flansmod", "gui/gunTableNew.png");
    private Paintjob hoveringOver = null;
    private String hoveringOverModSlots = null;
    private int mouseX;
    private int mouseY;
    private InventoryPlayer inventory;
    private boolean flipGunModel = false;
    private int[] lastStats = new int[]{0, 0, 0, 0};

    public GuiGunModTable(InventoryPlayer inv, World w) {
        super((Container)new ContainerGunModTable(inv, w));
        this.inventory = inv;
        this.field_146999_f = 331;
        this.field_147000_g = 236;
    }

    protected void func_146979_b(int x, int y) {
        this.field_146289_q.func_78276_b("Gun Modification Table", 6, 6, 0x404040);
        this.field_146289_q.func_78276_b("Inventory", 7, 142, 0x404040);
        this.field_146289_q.func_78276_b("Gun Information", 179, 22, 0x404040);
        this.field_146289_q.func_78276_b("Paint Jobs", 179, 128, 0x404040);
        ItemStack gunStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (gunStack != null && gunStack.func_77973_b() instanceof ItemGun) {
            GunType gunType = ((ItemGun)gunStack.func_77973_b()).type;
            int reload = Math.round(gunType.getReloadTime(gunStack));
            if (gunType.model != null) {
                GL11.glPushMatrix();
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslatef((float)105.0f, (float)55.0f, (float)100.0f);
                GL11.glRotatef((float)160.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)20.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                if (this.flipGunModel) {
                    GL11.glTranslatef((float)-30.0f, (float)0.0f, (float)0.0f);
                    GL11.glRotatef((float)190.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                RenderHelper.func_74519_b();
                GL11.glScalef((float)-60.0f, (float)60.0f, (float)60.0f);
                ClientProxy.gunRenderer.renderGunModel(gunStack, gunType, 0.0625f, gunType.model, GunAnimations.defaults, IItemRenderer.ItemRenderType.ENTITY);
                GL11.glPopMatrix();
            }
            if (gunStack.func_82833_r() != null) {
                this.field_146289_q.func_78276_b(gunStack.func_82833_r(), 207, 36, 0x404040);
            }
            this.field_146289_q.func_78276_b(gunType.description, 207, 46, 0x404040);
            this.field_146289_q.func_78276_b("Damage", 181, 61, 0x404040);
            this.field_146289_q.func_78276_b("Accuracy", 181, 73, 0x404040);
            this.field_146289_q.func_78276_b("Recoil", 181, 85, 0x404040);
            this.field_146289_q.func_78276_b("Reload", 181, 97, 0x404040);
            this.field_146289_q.func_78276_b("Control", 181, 109, 0x404040);
            this.field_146289_q.func_78276_b("Sprint", 240, 119, 0x404040);
            this.field_146289_q.func_78276_b("Sneak", 290, 119, 0x404040);
            this.field_146289_q.func_78276_b(String.valueOf(GuiGunModTable.roundFloat(gunType.getDamage(gunStack))), 241, 62, 0x404040);
            this.field_146289_q.func_78276_b(String.valueOf(GuiGunModTable.roundFloat(gunType.getSpread(gunStack, false, false))), 241, 74, 0x404040);
            this.field_146289_q.func_78276_b(String.valueOf(GuiGunModTable.roundFloat(gunType.getRecoilDisplay(gunStack))), 241, 86, 0x404040);
            this.field_146289_q.func_78276_b(GuiGunModTable.roundFloat((float)reload / 20.0f) + "s", 241, 98, 0x404040);
            Float sprinting = Float.valueOf(GuiGunModTable.roundFloat(1.0f - gunType.getRecoilControl(gunStack, true, false), 2));
            Float normal = Float.valueOf(GuiGunModTable.roundFloat(1.0f - gunType.getRecoilControl(gunStack, false, false), 2));
            Float sneaking = Float.valueOf(GuiGunModTable.roundFloat(1.0f - gunType.getRecoilControl(gunStack, false, true), 2));
            this.field_146289_q.func_78276_b(String.format("%3.2f  %3.2f  %3.2f", sprinting, normal, sneaking), 241, 110, 0x404040);
            if (this.hoveringOverModSlots != null) {
                this.drawHoveringText(Collections.singletonList(this.hoveringOverModSlots), this.mouseX - this.field_147003_i, this.mouseY - this.field_147009_r, this.field_146289_q);
            }
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        int numDyes;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOrigin = (this.field_146294_l - this.field_146999_f) / 2;
        int yOrigin = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(texture);
        this.func_73729_b(xOrigin, yOrigin, 0, 0, this.field_146999_f, this.field_147000_g);
        for (int z = 1; z < 17; ++z) {
            this.field_147002_h.func_75139_a((int)z).field_75221_f = -1000;
        }
        ItemStack gunStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (gunStack == null) {
            this.lastStats = new int[]{0, 0, 0, 0, 0};
        }
        if (gunStack != null && gunStack.func_77973_b() instanceof ItemGun) {
            int x;
            int y;
            GunType gunType = ((ItemGun)gunStack.func_77973_b()).type;
            int reload = Math.round(gunType.getReloadTime(gunStack));
            int[] stats = new int[]{Math.round(gunType.getDamage(gunStack)) * 4, Math.round(gunType.getSpread(gunStack, false, false)) * 4, Math.round(gunType.getRecoilDisplay(gunStack)) * 4, reload / 20 * 8, 0};
            this.displayGunValues(stats);
            boolean[] allowBooleans = new boolean[]{gunType.allowBarrelAttachments, gunType.allowScopeAttachments, gunType.allowStockAttachments, gunType.allowGripAttachments, gunType.allowGadgetAttachments, gunType.allowSlideAttachments, gunType.allowPumpAttachments, gunType.allowAccessoryAttachments};
            this.func_73729_b(xOrigin + 146, yOrigin + 63, 340, 166, 20, 10);
            for (int m = 0; m < allowBooleans.length; ++m) {
                if (!allowBooleans[m]) continue;
                this.func_73729_b(xOrigin + 16 + m * 18, yOrigin + 88, 340 + m * 18, 136, 18, 18);
                this.field_147002_h.func_75139_a((int)(m + 1)).field_75221_f = 89;
            }
            for (int x2 = 0; x2 < 8; ++x2) {
                if (x2 >= gunType.numGenericAttachmentSlots) continue;
                this.func_73729_b(xOrigin + 16 + 18 * x2, yOrigin + 114, 340, 100, 18, 18);
                this.field_147002_h.func_75139_a((int)(allowBooleans.length + 1 + x2)).field_75221_f = 115;
            }
            ArrayList<Paintjob> applicablePaintjobs = new ArrayList<Paintjob>();
            if (gunType.addAnyPaintjobToTables.booleanValue()) {
                for (Paintjob paintjob : gunType.paintjobs) {
                    if (!paintjob.addToTables.booleanValue()) continue;
                    applicablePaintjobs.add(paintjob);
                }
            }
            int numPaintjobs = applicablePaintjobs.size();
            int numRows = numPaintjobs / 2 + 1;
            for (y = 0; y < numRows; ++y) {
                for (x = 0; x < 2; ++x) {
                    if (2 * y + x >= numPaintjobs) continue;
                    this.func_73729_b(xOrigin + 181 + 18 * x, yOrigin + 150 + 18 * y, 340, 100, 18, 18);
                }
            }
            for (y = 0; y < numRows; ++y) {
                for (x = 0; x < 2; ++x) {
                    if (2 * y + x >= numPaintjobs) continue;
                    Paintjob paintjob = (Paintjob)applicablePaintjobs.get(2 * y + x);
                    ItemStack stack = gunStack.func_77946_l();
                    stack.func_77964_b(paintjob.ID);
                    field_146296_j.func_77015_a(this.field_146297_k.field_71466_p, this.field_146297_k.func_110434_K(), stack, xOrigin + 182 + x * 18, yOrigin + 151 + y * 18);
                }
            }
        }
        if (this.hoveringOver != null && (numDyes = this.hoveringOver.dyesNeeded.length) != 0 && !this.inventory.field_70458_d.field_71075_bZ.field_75098_d) {
            int s;
            boolean[] haveDyes = new boolean[numDyes];
            for (int n = 0; n < numDyes; ++n) {
                int amountNeeded = this.hoveringOver.dyesNeeded[n].field_77994_a;
                for (int s2 = 0; s2 < this.inventory.func_70302_i_(); ++s2) {
                    ItemStack stack = this.inventory.func_70301_a(s2);
                    if (stack == null || stack.func_77973_b() != Items.field_151100_aR || stack.func_77960_j() != this.hoveringOver.dyesNeeded[n].func_77960_j()) continue;
                    amountNeeded -= stack.field_77994_a;
                }
                if (amountNeeded > 0) continue;
                haveDyes[n] = true;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            this.field_146297_k.field_71446_o.func_110577_a(texture);
            for (s = 0; s < numDyes; ++s) {
                this.func_73729_b(xOrigin + 223 + 18 * s, yOrigin + 150, haveDyes[s] ? 358 : 340, 118, 18, 18);
            }
            for (s = 0; s < numDyes; ++s) {
                field_146296_j.func_77015_a(this.field_146289_q, this.field_146297_k.func_110434_K(), this.hoveringOver.dyesNeeded[s], xOrigin + 224 + s * 18, yOrigin + 151);
                field_146296_j.func_77021_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.hoveringOver.dyesNeeded[s], xOrigin + 224 + s * 18, yOrigin + 151);
            }
        }
    }

    private void displayGunValues(int[] stats) {
        int xOrigin = (this.field_146294_l - this.field_146999_f) / 2;
        int yOrigin = (this.field_146295_m - this.field_147000_g) / 2;
        for (int y = 0; y < 5; ++y) {
            this.func_73729_b(xOrigin + 239, yOrigin + 60 + 12 * y, 340, 80, 80, 10);
        }
        for (int k = 0; k < 5; ++k) {
            int finalWidth;
            int difference = stats[k] - this.lastStats[k];
            if (k == 0) {
                if (stats[k] < 80 && difference > 0) {
                    int n = k;
                    int n2 = this.lastStats[n] + 2;
                    this.lastStats[n] = n2;
                    finalWidth = n2;
                } else if (difference < 0) {
                    int n = k;
                    int n3 = this.lastStats[n] - 2;
                    this.lastStats[n] = n3;
                    finalWidth = n3;
                } else {
                    finalWidth = stats[k] < 80 ? stats[k] : 80;
                }
                this.func_73729_b(xOrigin + 239, yOrigin + 60 + 12 * k, 340, 90, finalWidth, 10);
                continue;
            }
            if (k == 4) {
                this.func_73729_b(xOrigin + 239, yOrigin + 60 + 12 * k, 340, 80, 32, 10);
                this.func_73729_b(xOrigin + 239 + 26, yOrigin + 60 + 12 * k, 341, 90, 28, 10);
                this.func_73729_b(xOrigin + 239 + 26 + 28, yOrigin + 60 + 12 * k, 394, 70, 32, 10);
                continue;
            }
            difference = 80 - stats[k] - this.lastStats[k];
            if (80 - stats[k] > 2 && difference > 0) {
                int n = k;
                int n4 = this.lastStats[n] + 2;
                this.lastStats[n] = n4;
                finalWidth = n4;
            } else if (difference < 0) {
                int n = k;
                int n5 = this.lastStats[n] - 2;
                this.lastStats[n] = n5;
                finalWidth = n5;
            } else {
                finalWidth = 80 - stats[k] > 2 ? 80 - stats[k] : 2;
            }
            this.func_73729_b(xOrigin + 239, yOrigin + 60 + 12 * k, 340, 90, finalWidth, 10);
        }
    }

    public void func_73729_b(int xPos, int yPos, int u, int v, int width, int height) {
        float f = 0.001953125f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)xPos, (double)(yPos + height), (double)this.field_73735_i, (double)((float)u * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(xPos + width), (double)(yPos + height), (double)this.field_73735_i, (double)((float)(u + width) * f), (double)((float)(v + height) * f1));
        tessellator.func_78374_a((double)(xPos + width), (double)yPos, (double)this.field_73735_i, (double)((float)(u + width) * f), (double)((float)v * f1));
        tessellator.func_78374_a((double)xPos, (double)yPos, (double)this.field_73735_i, (double)((float)u * f), (double)((float)v * f1));
        tessellator.func_78381_a();
    }

    public void func_146274_d() {
        super.func_146274_d();
        this.mouseX = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        this.mouseY = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
        int mouseXInGUI = this.mouseX - this.field_147003_i;
        int mouseYInGUI = this.mouseY - this.field_147009_r;
        this.hoveringOver = null;
        ItemStack gunStack = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (gunStack != null && gunStack.func_77973_b() instanceof ItemGun) {
            int slotY;
            int slotX;
            GunType gunType = ((ItemGun)gunStack.func_77973_b()).type;
            ArrayList<Paintjob> applicablePaintjobs = new ArrayList<Paintjob>();
            if (gunType.addAnyPaintjobToTables.booleanValue()) {
                for (Paintjob paintjob : gunType.paintjobs) {
                    if (!paintjob.addToTables.booleanValue()) continue;
                    applicablePaintjobs.add(paintjob);
                }
            }
            int numPaintjobs = applicablePaintjobs.size();
            int numRows = numPaintjobs / 2 + 1;
            for (int j = 0; j < numRows; ++j) {
                for (int i = 0; i < 2; ++i) {
                    if (2 * j + i >= numPaintjobs) continue;
                    Paintjob paintjob = (Paintjob)applicablePaintjobs.get(2 * j + i);
                    slotX = 181 + i * 18;
                    slotY = 150 + j * 18;
                    if (mouseXInGUI < slotX || mouseXInGUI >= slotX + 18 || mouseYInGUI < slotY || mouseYInGUI >= slotY + 18) continue;
                    this.hoveringOver = paintjob;
                }
            }
            this.hoveringOverModSlots = null;
            String[] text = new String[]{"Barrel", "Scope", "Stock", "Grip", "Gadget", "Slide", "Pump", "Accessory"};
            boolean[] allowBools = new boolean[]{gunType.allowBarrelAttachments, gunType.allowScopeAttachments, gunType.allowStockAttachments, gunType.allowGripAttachments, gunType.allowGadgetAttachments, gunType.allowSlideAttachments, gunType.allowPumpAttachments, gunType.allowAccessoryAttachments};
            for (int a = 0; a < allowBools.length; ++a) {
                slotX = 16 + a * 18;
                slotY = 88;
                if (mouseXInGUI < slotX || mouseXInGUI >= slotX + 18 || mouseYInGUI < slotY || mouseYInGUI >= slotY + 18 || this.field_147002_h.func_75139_a(a + 1).func_75216_d() || !allowBools[a]) continue;
                this.hoveringOverModSlots = text[a];
            }
        }
    }

    protected void func_73864_a(int x, int y, int button) {
        int xOrigin = (this.field_146294_l - this.field_146999_f) / 2;
        int yOrigin = (this.field_146295_m - this.field_147000_g) / 2;
        super.func_73864_a(x, y, button);
        int m = x - xOrigin;
        int n = y - yOrigin;
        if ((button == 0 || button == 1) && m >= 146 && m <= 165 && n >= 63 && n <= 72) {
            boolean bl = this.flipGunModel = !this.flipGunModel;
        }
        if (button != 0) {
            return;
        }
        if (this.hoveringOver == null) {
            return;
        }
        FlansMod.getPacketHandler().sendToServer(new PacketGunPaint(this.hoveringOver.ID));
        ((ContainerGunModTable)this.field_147002_h).clickPaintjob(this.hoveringOver);
    }

    private static float roundFloat(float value) {
        int pow = 10;
        for (int i = 1; i < 2; ++i) {
            pow *= 10;
        }
        float result = value * (float)pow;
        return (float)((int)(result - (float)((int)result) >= 0.5f ? result + 1.0f : result)) / (float)pow;
    }

    public static float roundFloat(float value, int points) {
        int pow = 10;
        for (int i = 1; i < points; ++i) {
            pow *= 10;
        }
        float result = value * (float)pow;
        return (float)((int)(result - (float)((int)result) >= 0.5f ? result + 1.0f : result)) / (float)pow;
    }
}

