/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemFlamethrower;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class PacketFlamethrowerData
implements IMessageHandler<FlamethrowerDataMessage, IMessage> {
    public IMessage onMessage(FlamethrowerDataMessage message, MessageContext context) {
        ItemStack stack;
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (message.packetType == FlamethrowerPacket.UPDATE) {
            if (message.value) {
                Mekanism.flamethrowerActive.add(message.username);
            } else {
                Mekanism.flamethrowerActive.remove(message.username);
            }
            if (!player.field_70170_p.field_72995_K) {
                Mekanism.packetHandler.sendToDimension(new FlamethrowerDataMessage(FlamethrowerPacket.UPDATE, message.username, message.value), player.field_70170_p.field_73011_w.field_76574_g);
            }
        } else if (message.packetType == FlamethrowerPacket.MODE && (stack = player.func_71045_bC()) != null && stack.func_77973_b() instanceof ItemFlamethrower) {
            ((ItemFlamethrower)stack.func_77973_b()).incrementMode(stack);
        }
        return null;
    }

    public static enum FlamethrowerPacket {
        UPDATE,
        MODE;

    }

    public static class FlamethrowerDataMessage
    implements IMessage {
        public FlamethrowerPacket packetType;
        public String username;
        public boolean value;

        public FlamethrowerDataMessage() {
        }

        public FlamethrowerDataMessage(FlamethrowerPacket type, String name, boolean state) {
            this.packetType = type;
            if (type == FlamethrowerPacket.UPDATE) {
                this.username = name;
                this.value = state;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == FlamethrowerPacket.UPDATE) {
                PacketHandler.writeString(dataStream, this.username);
                dataStream.writeBoolean(this.value);
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = FlamethrowerPacket.values()[dataStream.readInt()];
            if (this.packetType == FlamethrowerPacket.UPDATE) {
                this.username = PacketHandler.readString(dataStream);
                this.value = dataStream.readBoolean();
            }
        }
    }
}

