/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.IConfigCardAccess;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.item.ItemMekanism;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemConfigurationCard
extends ItemMekanism {
    public ItemConfigurationCard() {
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        super.func_77624_a(itemstack, entityplayer, list, flag);
        list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.data") + ": " + (Object)((Object)EnumColor.INDIGO) + LangUtils.localize(this.getDataType(itemstack)));
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (!world.field_72995_K && (tileEntity = world.func_147438_o(x, y, z)) instanceof IConfigCardAccess) {
            if (player.func_70093_af()) {
                NBTTagCompound data = this.getBaseData(tileEntity);
                if (tileEntity instanceof IConfigCardAccess.ISpecialConfigData) {
                    data = ((IConfigCardAccess.ISpecialConfigData)tileEntity).getConfigurationData(data);
                }
                if (data != null) {
                    data.func_74778_a("dataType", this.getNameFromTile(tileEntity));
                    this.setData(stack, data);
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configurationCard.got").replaceAll("%s", (Object)((Object)EnumColor.INDIGO) + LangUtils.localize(data.func_74779_i("dataType")) + (Object)((Object)EnumColor.GREY))));
                }
                return true;
            }
            if (this.getData(stack) != null) {
                if (this.getNameFromTile(tileEntity).equals(this.getDataType(stack))) {
                    this.setBaseData(this.getData(stack), tileEntity);
                    if (tileEntity instanceof IConfigCardAccess.ISpecialConfigData) {
                        ((IConfigCardAccess.ISpecialConfigData)tileEntity).setConfigurationData(this.getData(stack));
                    }
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("tooltip.configurationCard.set").replaceAll("%s", (Object)((Object)EnumColor.INDIGO) + LangUtils.localize(this.getDataType(stack)) + (Object)((Object)EnumColor.DARK_GREEN))));
                    this.setData(stack, null);
                } else {
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.RED) + LangUtils.localize("tooltip.configurationCard.unequal") + "."));
                }
                return true;
            }
        }
        return false;
    }

    private NBTTagCompound getBaseData(TileEntity tile) {
        NBTTagCompound nbtTags = new NBTTagCompound();
        if (tile instanceof IRedstoneControl) {
            nbtTags.func_74768_a("controlType", ((IRedstoneControl)tile).getControlType().ordinal());
        }
        if (tile instanceof ISideConfiguration) {
            ((ISideConfiguration)tile).getConfig().write(nbtTags);
            ((ISideConfiguration)tile).getEjector().write(nbtTags);
        }
        return nbtTags;
    }

    private void setBaseData(NBTTagCompound nbtTags, TileEntity tile) {
        if (tile instanceof IRedstoneControl) {
            ((IRedstoneControl)tile).setControlType(IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")]);
        }
        if (tile instanceof ISideConfiguration) {
            ((ISideConfiguration)tile).getConfig().read(nbtTags);
            ((ISideConfiguration)tile).getEjector().read(nbtTags);
        }
    }

    private String getNameFromTile(TileEntity tile) {
        String ret = Integer.toString(tile.hashCode());
        if (tile instanceof TileEntityContainerBlock) {
            ret = tile.func_145838_q().func_149739_a() + "." + ((TileEntityContainerBlock)tile).fullName + ".name";
        }
        if (tile instanceof IConfigCardAccess.ISpecialConfigData) {
            ret = ((IConfigCardAccess.ISpecialConfigData)tile).getDataType();
        }
        return ret;
    }

    public void setData(ItemStack itemstack, NBTTagCompound data) {
        if (itemstack.field_77990_d == null) {
            itemstack.func_77982_d(new NBTTagCompound());
        }
        if (data != null) {
            itemstack.field_77990_d.func_74782_a("data", (NBTBase)data);
        } else {
            itemstack.field_77990_d.func_82580_o("data");
        }
    }

    public NBTTagCompound getData(ItemStack itemstack) {
        if (itemstack.field_77990_d == null) {
            return null;
        }
        NBTTagCompound data = itemstack.field_77990_d.func_74775_l("data");
        if (data.func_82582_d()) {
            return null;
        }
        return itemstack.field_77990_d.func_74775_l("data");
    }

    public String getDataType(ItemStack itemstack) {
        NBTTagCompound data = this.getData(itemstack);
        if (data != null) {
            return data.func_74779_i("dataType");
        }
        return "gui.none";
    }
}

