/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.util.ListUtils;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSecurityTab;
import mekanism.client.gui.element.GuiSideConfigurationTab;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiTransporterConfigTab;
import mekanism.client.gui.element.GuiUpgradeTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerFormulaicAssemblicator;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiFormulaicAssemblicator
extends GuiMekanism {
    public TileEntityFormulaicAssemblicator tileEntity;
    public ResourceLocation guiLocation = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiFormulaicAssemblicator.png");

    public GuiFormulaicAssemblicator(InventoryPlayer inventory, TileEntityFormulaicAssemblicator tentity) {
        super(tentity, new ContainerFormulaicAssemblicator(inventory, tentity));
        this.tileEntity = tentity;
        this.guiElements.add(new GuiSecurityTab(this, this.tileEntity, this.guiLocation));
        this.guiElements.add(new GuiUpgradeTab(this, this.tileEntity, this.guiLocation));
        this.guiElements.add(new GuiRedstoneControl(this, this.tileEntity, this.guiLocation));
        this.guiElements.add(new GuiSideConfigurationTab(this, this.tileEntity, this.guiLocation));
        this.guiElements.add(new GuiTransporterConfigTab(this, 34, this.tileEntity, this.guiLocation));
        this.guiElements.add(new GuiPowerBar((IGuiWrapper)this, this.tileEntity, this.guiLocation, 159, 15));
        this.guiElements.add(new GuiEnergyInfo(new GuiElement.IInfoHandler(){

            @Override
            public List<String> getInfo() {
                String multiplier = MekanismUtils.getEnergyDisplay(GuiFormulaicAssemblicator.this.tileEntity.energyPerTick);
                return ListUtils.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(GuiFormulaicAssemblicator.this.tileEntity.getMaxEnergy() - GuiFormulaicAssemblicator.this.tileEntity.getEnergy()));
            }
        }, (IGuiWrapper)this, this.guiLocation));
        this.guiElements.add(new GuiSlot(GuiSlot.SlotType.POWER, this, this.guiLocation, 151, 75).with(GuiSlot.SlotOverlay.POWER));
        this.field_147000_g += 64;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(this.tileEntity.func_145825_b(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.tileEntity.func_145825_b()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        if (xAxis >= 44 && xAxis <= 60 && yAxis >= 75 && yAxis <= 91) {
            this.func_146279_a(LangUtils.localize("gui.fillEmpty"), xAxis, yAxis);
        }
        if (xAxis >= 7 && xAxis <= 21 && yAxis >= 45 && yAxis <= 59) {
            this.func_146279_a(LangUtils.localize("gui.encodeFormula"), xAxis, yAxis);
        }
        if (xAxis >= 71 && xAxis <= 87 && yAxis >= 75 && yAxis <= 91) {
            this.func_146279_a(LangUtils.localize("gui.craftSingle"), xAxis, yAxis);
        }
        if (xAxis >= 89 && xAxis <= 105 && yAxis >= 75 && yAxis <= 91) {
            this.func_146279_a(LangUtils.localize("gui.craftAvailable"), xAxis, yAxis);
        }
        if (xAxis >= 107 && xAxis <= 123 && yAxis >= 75 && yAxis <= 91) {
            this.func_146279_a(LangUtils.localize("gui.autoModeToggle") + " " + LangUtils.transOnOff(!this.tileEntity.autoMode), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(this.guiLocation);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        int xAxis = mouseX - guiWidth;
        int yAxis = mouseY - guiHeight;
        if (!this.tileEntity.autoMode) {
            if (xAxis >= 44 && xAxis <= 60 && yAxis >= 75 && yAxis <= 91) {
                this.func_73729_b(guiWidth + 44, guiHeight + 75, 238, 0, 16, 16);
            } else {
                this.func_73729_b(guiWidth + 44, guiHeight + 75, 238, 16, 16, 16);
            }
        } else {
            this.func_73729_b(guiWidth + 44, guiHeight + 75, 238, 32, 16, 16);
        }
        if (!this.tileEntity.autoMode && this.tileEntity.isRecipe) {
            if (this.canEncode()) {
                if (xAxis >= 7 && xAxis <= 21 && yAxis >= 45 && yAxis <= 59) {
                    this.func_73729_b(guiWidth + 7, guiHeight + 45, 176, 0, 14, 14);
                } else {
                    this.func_73729_b(guiWidth + 7, guiHeight + 45, 176, 14, 14, 14);
                }
            } else {
                this.func_73729_b(guiWidth + 7, guiHeight + 45, 176, 28, 14, 14);
            }
            if (xAxis >= 71 && xAxis <= 87 && yAxis >= 75 && yAxis <= 91) {
                this.func_73729_b(guiWidth + 71, guiHeight + 75, 190, 0, 16, 16);
            } else {
                this.func_73729_b(guiWidth + 71, guiHeight + 75, 190, 16, 16, 16);
            }
            if (xAxis >= 89 && xAxis <= 105 && yAxis >= 75 && yAxis <= 91) {
                this.func_73729_b(guiWidth + 89, guiHeight + 75, 206, 0, 16, 16);
            } else {
                this.func_73729_b(guiWidth + 89, guiHeight + 75, 206, 16, 16, 16);
            }
        } else {
            this.func_73729_b(guiWidth + 7, guiHeight + 45, 176, 28, 14, 14);
            this.func_73729_b(guiWidth + 71, guiHeight + 75, 190, 32, 16, 16);
            this.func_73729_b(guiWidth + 89, guiHeight + 75, 206, 32, 16, 16);
        }
        if (this.tileEntity.formula != null) {
            if (xAxis >= 107 && xAxis <= 123 && yAxis >= 75 && yAxis <= 91) {
                this.func_73729_b(guiWidth + 107, guiHeight + 75, 222, 0, 16, 16);
            } else {
                this.func_73729_b(guiWidth + 107, guiHeight + 75, 222, 16, 16, 16);
            }
        } else {
            this.func_73729_b(guiWidth + 107, guiHeight + 75, 222, 32, 16, 16);
        }
        if (this.tileEntity.operatingTicks > 0) {
            int display = (int)((double)this.tileEntity.operatingTicks * 22.0 / (double)this.tileEntity.ticksRequired);
            this.func_73729_b(guiWidth + 86, guiHeight + 43, 176, 48, display, 16);
        }
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiSlot.png"));
        this.func_73729_b(guiWidth + 90, guiHeight + 25, this.tileEntity.isRecipe ? 2 : 20, 39, 14, 12);
        if (this.tileEntity.formula != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.tileEntity.formula.input[i];
                if (stack == null) continue;
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i + 20);
                GL11.glPushMatrix();
                if (slot.func_75211_c() == null || !slot.func_75211_c().func_77969_a(stack)) {
                    this.func_73733_a(guiWidth + slot.field_75223_e, guiHeight + slot.field_75221_f, guiWidth + slot.field_75223_e + 16, guiHeight + slot.field_75221_f + 16, -2137456640, -2137456640);
                }
                GL11.glEnable((int)2896);
                MekanismRenderer.blendOn();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), stack, guiWidth + slot.field_75223_e, guiHeight + slot.field_75221_f);
                MekanismRenderer.blendOff();
                GL11.glDisable((int)2896);
                GL11.glPopMatrix();
            }
        }
        super.func_146976_a(partialTick, mouseX, mouseY);
    }

    private boolean canEncode() {
        return this.tileEntity.formula == null && this.tileEntity.inventory[2] != null && this.tileEntity.inventory[2].func_77973_b() instanceof ItemCraftingFormula && ((ItemCraftingFormula)this.tileEntity.inventory[2].func_77973_b()).getInventory(this.tileEntity.inventory[2]) == null;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 0) {
            ArrayList<Integer> data;
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (!this.tileEntity.autoMode) {
                if (xAxis >= 44 && xAxis <= 60 && yAxis >= 75 && yAxis <= 91) {
                    SoundHandler.playSound("gui.button.press");
                    data = new ArrayList<Integer>();
                    data.add(4);
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                }
                if (this.tileEntity.isRecipe) {
                    if (this.canEncode() && xAxis >= 7 && xAxis <= 21 && yAxis >= 45 && yAxis <= 59) {
                        SoundHandler.playSound("gui.button.press");
                        data = new ArrayList();
                        data.add(1);
                        Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                    }
                    if (xAxis >= 71 && xAxis <= 87 && yAxis >= 75 && yAxis <= 91) {
                        SoundHandler.playSound("gui.button.press");
                        data = new ArrayList();
                        data.add(2);
                        Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                    }
                    if (xAxis >= 89 && xAxis <= 105 && yAxis >= 75 && yAxis <= 91) {
                        SoundHandler.playSound("gui.button.press");
                        data = new ArrayList();
                        data.add(3);
                        Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                    }
                }
            }
            if (this.tileEntity.formula != null && xAxis >= 107 && xAxis <= 123 && yAxis >= 75 && yAxis <= 91) {
                SoundHandler.playSound("gui.button.press");
                data = new ArrayList();
                data.add(0);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            }
        }
    }
}

