/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.fusionReactor;

import ic2.api.item.IC2Items;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.init.ModBlocks;
import techreborn.powerSystem.TilePowerAcceptor;

public class TileEntityFusionController
extends TilePowerAcceptor
implements IInventory {
    public Inventory inventory = new Inventory(3, "TileEntityFusionController", 64);
    public int coilStatus = 0;
    int emptyCellCount = 0;
    int topStackSlot = 0;
    int bottomStackSlot = 1;
    int outputStackSlot = 2;
    public int crafingTickTime = 0;
    public int finalTickTime = 0;
    public int neededPower = 0;
    FusionReactorRecipe currentRecipe = null;
    boolean hasStartedCrafting = false;

    public TileEntityFusionController() {
        super(4);
    }

    @Override
    public double getMaxPower() {
        return 1.0E8;
    }

    @Override
    public boolean canAcceptEnergy(ForgeDirection direction) {
        return direction != ForgeDirection.DOWN && direction != ForgeDirection.UP;
    }

    @Override
    public boolean canProvideEnergy(ForgeDirection direction) {
        return direction == ForgeDirection.DOWN || direction == ForgeDirection.UP;
    }

    @Override
    public double getMaxOutput() {
        if (!this.hasStartedCrafting || !(this.currentRecipe.getEuTick() > 0.0)) {
            return 0.0;
        }
        return 1000000.0;
    }

    @Override
    public double getMaxInput() {
        if (this.hasStartedCrafting && this.currentRecipe.getEuTick() > 0.0) {
            return 0.0;
        }
        return 8192.0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        this.crafingTickTime = tagCompound.func_74762_e("crafingTickTime");
        this.finalTickTime = tagCompound.func_74762_e("finalTickTime");
        this.neededPower = tagCompound.func_74762_e("neededPower");
        this.hasStartedCrafting = tagCompound.func_74767_n("hasStartedCrafting");
        this.emptyCellCount = tagCompound.func_74762_e("emptyCellCount");
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        if (this.crafingTickTime == -1) {
            this.crafingTickTime = 0;
        }
        if (this.finalTickTime == -1) {
            this.finalTickTime = 0;
        }
        if (this.neededPower == -1) {
            this.neededPower = 0;
        }
        tagCompound.func_74768_a("crafingTickTime", this.crafingTickTime);
        tagCompound.func_74768_a("finalTickTime", this.finalTickTime);
        tagCompound.func_74768_a("neededPower", this.neededPower);
        tagCompound.func_74757_a("hasStartedCrafting", this.hasStartedCrafting);
        tagCompound.func_74768_a("emptyCellCount", this.emptyCellCount);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 2;
    }

    public boolean checkCoils() {
        if (this.isCoil(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e + 1) && this.isCoil(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e) && this.isCoil(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 1) && this.isCoil(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 1) && this.isCoil(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e) && this.isCoil(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e - 1) && this.isCoil(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 2) && this.isCoil(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1) && this.isCoil(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1) && this.isCoil(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 2) && this.isCoil(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 2) && this.isCoil(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1) && this.isCoil(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1) && this.isCoil(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 2) && this.isCoil(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 3) && this.isCoil(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2) && this.isCoil(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2) && this.isCoil(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 3) && this.isCoil(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 3) && this.isCoil(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2) && this.isCoil(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2) && this.isCoil(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 3) && this.isCoil(this.field_145851_c, this.field_145848_d, this.field_145849_e + 3) && this.isCoil(this.field_145851_c, this.field_145848_d, this.field_145849_e - 3)) {
            this.coilStatus = 1;
            return true;
        }
        this.coilStatus = 0;
        return false;
    }

    private boolean isCoil(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.FusionCoil;
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.checkCoils();
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.emptyCellCount > 0 && this.func_70301_a(this.outputStackSlot) == null) {
                this.func_70299_a(this.outputStackSlot, IC2Items.getItem("cell").func_77979_a(this.emptyCellCount));
                this.emptyCellCount = 0;
            }
            if (this.coilStatus == 1) {
                if (this.currentRecipe == null) {
                    if (this.inventory.hasChanged || this.crafingTickTime != 0) {
                        for (FusionReactorRecipe reactorRecipe : FusionReactorRecipeHelper.reactorRecipes) {
                            if (!ItemUtils.isItemEqual((ItemStack)this.func_70301_a(this.topStackSlot), (ItemStack)reactorRecipe.getTopInput(), (boolean)true, (boolean)true, (boolean)true)) continue;
                            if (reactorRecipe.getBottomInput() == null || ItemUtils.isItemEqual((ItemStack)this.func_70301_a(this.bottomStackSlot), (ItemStack)reactorRecipe.getBottomInput(), (boolean)true, (boolean)true, (boolean)true)) {
                                if (!this.canFitStack(reactorRecipe.getOutput(), this.outputStackSlot, true)) continue;
                                this.currentRecipe = reactorRecipe;
                                if (this.crafingTickTime != 0) {
                                    this.finalTickTime = this.currentRecipe.getTickTime();
                                    this.neededPower = (int)this.currentRecipe.getStartEU();
                                }
                                this.hasStartedCrafting = false;
                                this.crafingTickTime = 0;
                                this.finalTickTime = this.currentRecipe.getTickTime();
                                this.neededPower = (int)this.currentRecipe.getStartEU();
                            }
                            break;
                        }
                    }
                } else if (!this.hasStartedCrafting) {
                    if (this.canUseEnergy(this.currentRecipe.getStartEU() + 64.0)) {
                        this.useEnergy(this.currentRecipe.getStartEU());
                        this.hasStartedCrafting = true;
                    }
                } else if (this.crafingTickTime < this.currentRecipe.getTickTime()) {
                    if (this.crafingTickTime == 0) {
                        this.func_70298_a(this.topStackSlot, this.currentRecipe.getTopInput().field_77994_a);
                        if (this.currentRecipe.getBottomInput() != null) {
                            this.func_70298_a(this.bottomStackSlot, this.currentRecipe.getBottomInput().field_77994_a);
                        }
                    }
                    if (this.currentRecipe.getEuTick() > 0.0) {
                        this.addEnergy(this.currentRecipe.getEuTick());
                        ++this.crafingTickTime;
                    } else if (this.canUseEnergy(this.currentRecipe.getEuTick() * -1.0)) {
                        this.setEnergy(this.getEnergy() - this.currentRecipe.getEuTick() * -1.0);
                        ++this.crafingTickTime;
                    } else {
                        this.resetCrafter();
                    }
                } else if (this.canFitStack(this.currentRecipe.getOutput(), this.outputStackSlot, true)) {
                    if (this.func_70301_a(this.outputStackSlot) == null) {
                        this.func_70299_a(this.outputStackSlot, this.currentRecipe.getOutput().func_77946_l());
                    } else {
                        this.func_70298_a(this.outputStackSlot, -this.currentRecipe.getOutput().field_77994_a);
                    }
                    if (this.currentRecipe.getTopInput().func_77973_b().func_77658_a().toLowerCase().contains("cell")) {
                        ++this.emptyCellCount;
                    }
                    if (this.currentRecipe.getBottomInput().func_77973_b().func_77658_a().toLowerCase().contains("cell")) {
                        ++this.emptyCellCount;
                    }
                    if (this.currentRecipe.getOutput().func_77973_b().func_77658_a().toLowerCase().contains("cell")) {
                        --this.emptyCellCount;
                    }
                    if (this.emptyCellCount > 64) {
                        this.emptyCellCount = 64;
                    }
                    this.crafingTickTime = 0;
                    if (!this.validateRecipe()) {
                        this.resetCrafter();
                    }
                }
            } else if (this.currentRecipe != null) {
                this.resetCrafter();
            }
        }
        if (this.inventory.hasChanged) {
            this.inventory.hasChanged = false;
        }
    }

    private boolean validateRecipe() {
        if (ItemUtils.isItemEqual((ItemStack)this.func_70301_a(this.topStackSlot), (ItemStack)this.currentRecipe.getTopInput(), (boolean)true, (boolean)true, (boolean)true)) {
            if (this.currentRecipe.getBottomInput() != null && !ItemUtils.isItemEqual((ItemStack)this.func_70301_a(this.bottomStackSlot), (ItemStack)this.currentRecipe.getBottomInput(), (boolean)true, (boolean)true, (boolean)true)) {
                return false;
            }
            if (this.canFitStack(this.currentRecipe.getOutput(), this.outputStackSlot, true)) {
                return true;
            }
        }
        return false;
    }

    private void resetCrafter() {
        this.currentRecipe = null;
        this.crafingTickTime = -1;
        this.finalTickTime = -1;
        this.neededPower = -1;
        this.hasStartedCrafting = false;
    }

    public boolean canFitStack(ItemStack stack, int slot, boolean oreDic) {
        if (stack == null) {
            return true;
        }
        if (this.inventory.func_70301_a(slot) == null) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)this.inventory.func_70301_a(slot), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)oreDic) && stack.field_77994_a + this.inventory.func_70301_a((int)slot).field_77994_a <= stack.func_77976_d();
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.checkCoils();
    }
}

