/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import ic2.api.tile.IWrenchable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.util.Inventory;
import techreborn.api.recipe.RecipeCrafter;
import techreborn.init.ModBlocks;
import techreborn.lib.Reference;
import techreborn.powerSystem.TilePowerAcceptor;

public class TileVacuumFreezer
extends TilePowerAcceptor
implements IWrenchable,
IInventory {
    public int tickTime;
    public Inventory inventory = new Inventory(3, "TileVacuumFreezer", 64);
    public RecipeCrafter crafter;
    public int multiBlockStatus = 0;

    public TileVacuumFreezer() {
        super(2);
        int[] inputs = new int[]{0};
        int[] outputs = new int[]{1};
        this.crafter = new RecipeCrafter(Reference.vacuumFreezerRecipe, this, 2, 1, this.inventory, inputs, outputs);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.crafter.updateEntity();
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.multiBlockStatus = this.checkMachine() ? 1 : 0;
        }
    }

    @Override
    public double getMaxPower() {
        return 10000.0;
    }

    @Override
    public boolean canAcceptEnergy(ForgeDirection direction) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ForgeDirection direction) {
        return false;
    }

    @Override
    public double getMaxOutput() {
        return 0.0;
    }

    @Override
    public double getMaxInput() {
        return 128.0;
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return false;
    }

    @Override
    public short getFacing() {
        return 0;
    }

    @Override
    public void setFacing(short facing) {
    }

    @Override
    public boolean wrenchCanRemove(EntityPlayer entityPlayer) {
        return entityPlayer.func_70093_af();
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.AlloySmelter, 1);
    }

    public boolean isComplete() {
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.inventory.readFromNBT(tagCompound);
        this.crafter.readFromNBT(tagCompound);
    }

    @Override
    public void func_145841_b(NBTTagCompound tagCompound) {
        super.func_145841_b(tagCompound);
        this.inventory.writeToNBT(tagCompound);
        this.crafter.writeToNBT(tagCompound);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inventory.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70305_f();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }

    public int getProgressScaled(int scale) {
        if (this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public boolean checkMachine() {
        int xDir = ForgeDirection.UP.offsetX * 2;
        int yDir = ForgeDirection.UP.offsetY * 2;
        int zDir = ForgeDirection.UP.offsetZ * 2;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (i != 0 || j != 0 || k != 0) {
                        if (this.field_145850_b.func_147439_a(this.field_145851_c - xDir + i, this.field_145848_d - yDir + j, this.field_145849_e - zDir + k) != ModBlocks.MachineCasing) {
                            return false;
                        }
                        if (this.field_145850_b.func_72805_g(this.field_145851_c - xDir + i, this.field_145848_d - yDir + j, this.field_145849_e - zDir + k) == (i == 0 && j == 0 && k != 0 || i == 0 && j != 0 && k == 0 || i != 0 && j == 0 && k == 0 ? 2 : 1)) continue;
                        return false;
                    }
                    if (this.field_145850_b.func_147437_c(this.field_145851_c - xDir + i, this.field_145848_d - yDir + j, this.field_145849_e - zDir + k)) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

