/*
 * Decompiled with CFR 0.152.
 */
package techreborn.powerSystem.traits;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import reborncore.jtraits.JTrait;
import techreborn.api.power.IEnergyInterfaceItem;

public abstract class BasePowerTrait
extends JTrait<Item>
implements IEnergyInterfaceItem {
    @Override
    public double getEnergy(ItemStack stack) {
        NBTTagCompound tagCompound = this.getOrCreateNbtData(stack);
        if (tagCompound.func_74764_b("charge")) {
            return tagCompound.func_74769_h("charge");
        }
        return 0.0;
    }

    @Override
    public void setEnergy(double energy, ItemStack stack) {
        NBTTagCompound tagCompound = this.getOrCreateNbtData(stack);
        tagCompound.func_74780_a("charge", energy);
        if (this.getEnergy(stack) > this.getMaxPower(stack)) {
            this.setEnergy(this.getMaxPower(stack), stack);
        } else if (this.getEnergy(stack) < 0.0) {
            this.setEnergy(0.0, stack);
        }
    }

    @Override
    public double addEnergy(double energy, ItemStack stack) {
        return this.addEnergy(energy, false, stack);
    }

    @Override
    public double addEnergy(double energy, boolean simulate, ItemStack stack) {
        double energyReceived = Math.min(this.getMaxPower(stack) - energy, Math.min(this.getMaxPower(stack), energy));
        if (!simulate) {
            this.setEnergy(energy + energyReceived, stack);
        }
        return energyReceived;
    }

    @Override
    public boolean canUseEnergy(double input, ItemStack stack) {
        return input <= this.getEnergy(stack);
    }

    @Override
    public double useEnergy(double energy, ItemStack stack) {
        return this.useEnergy(energy, false, stack);
    }

    @Override
    public double useEnergy(double extract, boolean simulate, ItemStack stack) {
        double energyExtracted = Math.min(extract, Math.min(this.getMaxTransfer(stack), extract));
        if (!simulate) {
            this.setEnergy(this.getEnergy(stack) - energyExtracted, stack);
        }
        return energyExtracted;
    }

    @Override
    public boolean canAddEnergy(double energy, ItemStack stack) {
        return this.getEnergy(stack) + energy <= this.getMaxPower(stack);
    }

    public NBTTagCompound getOrCreateNbtData(ItemStack itemStack) {
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            itemStack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }
}

