/*
 * Decompiled with CFR 0.152.
 */
package techreborn.powerSystem;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.Random;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import techreborn.api.power.IEnergyInterfaceTile;
import techreborn.powerSystem.PowerSystem;
import techreborn.tiles.TileMachineBase;

public abstract class RFProviderTile
extends TileMachineBase
implements IEnergyReceiver,
IEnergyProvider,
IEnergyInterfaceTile {
    Random random = new Random();

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.sendPower();
    }

    public void sendPower() {
        if (!PowerSystem.RFPOWENET) {
            return;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            int neededRF;
            IEnergyHandler handler;
            int extracted = this.getEnergyStored(direction);
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
            if (!this.isPoweredTile(tile, direction) || !this.canProvideEnergy(direction)) continue;
            if (tile instanceof IEnergyHandler) {
                handler = (IEnergyHandler)tile;
                neededRF = handler.receiveEnergy(direction.getOpposite(), extracted, false);
                this.extractEnergy(direction.getOpposite(), neededRF, false);
                continue;
            }
            if (!(tile instanceof IEnergyReceiver)) continue;
            handler = (IEnergyReceiver)tile;
            neededRF = handler.receiveEnergy(direction.getOpposite(), extracted, false);
            this.extractEnergy(direction.getOpposite(), neededRF, false);
        }
    }

    public boolean isPoweredTile(TileEntity tile, ForgeDirection side) {
        if (tile == null) {
            return false;
        }
        if (tile instanceof IEnergyHandler || tile instanceof IEnergyReceiver) {
            return ((IEnergyConnection)tile).canConnectEnergy(side.getOpposite());
        }
        return false;
    }
}

