/*
 * Decompiled with CFR 0.152.
 */
package techreborn.partSystem.fmp;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import reborncore.common.misc.Location;
import reborncore.common.misc.vecmath.Vecs3d;
import reborncore.common.misc.vecmath.Vecs3dCube;
import techreborn.partSystem.IPartDesc;
import techreborn.partSystem.ModPart;

public class FMPModPart
extends TMultiPart
implements TSlottedPart,
JNormalOcclusion,
ISidedHollowConnect {
    ModPart iModPart;

    public FMPModPart(ModPart iModPart) {
        this.iModPart = iModPart;
    }

    public int getHollowSize(int i) {
        return 0;
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        ArrayList<Cuboid6> cubes = new ArrayList<Cuboid6>();
        for (Vecs3dCube c : this.iModPart.getOcclusionBoxes()) {
            if (c == null) continue;
            cubes.add(new Cuboid6(c.toAABB()));
        }
        return cubes;
    }

    public boolean occlusionTest(TMultiPart npart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)npart);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        ArrayList<Cuboid6> cubes = new ArrayList<Cuboid6>();
        ArrayList boxes = new ArrayList();
        this.iModPart.addCollisionBoxesToList(boxes, null);
        for (Vecs3dCube c : boxes) {
            if (c == null) continue;
            cubes.add(new Cuboid6(c.toAABB()));
        }
        return cubes;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        ArrayList<IndexedCuboid6> cubes = new ArrayList<IndexedCuboid6>();
        if (this.iModPart.getSelectionBoxes() != null) {
            for (Vecs3dCube c : this.iModPart.getSelectionBoxes()) {
                if (c == null) continue;
                cubes.add(new IndexedCuboid6((Object)0, new Cuboid6(c.toAABB())));
            }
            if (cubes.size() == 0) {
                cubes.add(new IndexedCuboid6((Object)0, new Cuboid6(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)));
            }
        }
        return cubes;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 pos, float frame, int pass) {
        this.iModPart.renderDynamic(new Vecs3d(pos.x, pos.y, pos.z), frame);
    }

    public String getType() {
        return this.iModPart.getName();
    }

    public int getSlotMask() {
        return 0;
    }

    public World getWorld() {
        return this.world();
    }

    public int getX() {
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.world());
            this.iModPart.setLocation(new Location(this.x(), this.y(), this.z()));
        }
        return this.x();
    }

    public int getY() {
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.world());
            this.iModPart.setLocation(new Location(this.x(), this.y(), this.z()));
        }
        return this.y();
    }

    public int getZ() {
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.world());
            this.iModPart.setLocation(new Location(this.x(), this.y(), this.z()));
        }
        return this.z();
    }

    public void onAdded() {
        this.iModPart.setWorld(this.world());
        this.iModPart.setLocation(new Location(this.x(), this.y(), this.z()));
        this.iModPart.nearByChange();
        this.iModPart.onAdded();
    }

    public void update() {
        if (this.iModPart.location != null) {
            this.iModPart.tick();
        }
    }

    public void onNeighborChanged() {
        super.onNeighborChanged();
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.world());
            this.iModPart.setLocation(new Location(this.x(), this.y(), this.z()));
        }
        this.iModPart.nearByChange();
    }

    public void onRemoved() {
        this.iModPart.onRemoved();
        super.onRemoved();
    }

    public boolean renderStatic(Vector3 pos, int pass) {
        boolean render = this.iModPart.renderStatic(new Vecs3d((double)((int)pos.x), (double)((int)pos.y), (double)((int)pos.z)), pass);
        return render;
    }

    public Iterable<ItemStack> getDrops() {
        ArrayList<ItemStack> stackArrayList = new ArrayList<ItemStack>();
        if (this.iModPart.getItem() != null) {
            stackArrayList.add(this.iModPart.getItem().func_77946_l());
        }
        return stackArrayList;
    }

    public void onPartChanged(TMultiPart part) {
        super.onPartChanged(part);
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.world());
            this.iModPart.setLocation(new Location(this.x(), this.y(), this.z()));
        }
        this.iModPart.nearByChange();
    }

    public void readDesc(MCDataInput packet) {
        super.readDesc(packet);
        if (this.iModPart instanceof IPartDesc) {
            ((IPartDesc)((Object)this.iModPart)).readDesc(packet.readNBTTagCompound());
        }
    }

    public void writeDesc(MCDataOutput packet) {
        super.writeDesc(packet);
        if (this.iModPart instanceof IPartDesc) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((IPartDesc)((Object)this.iModPart)).writeDesc(tagCompound);
            packet.writeNBTTagCompound(tagCompound);
        }
    }

    public void onWorldJoin() {
        if (this.iModPart.world == null || this.iModPart.location == null) {
            this.iModPart.setWorld(this.world());
            this.iModPart.setLocation(new Location(this.x(), this.y(), this.z()));
        }
        this.iModPart.onAdded();
    }

    public void onWorldSeparate() {
        this.iModPart.onChunkUnload();
    }
}

