/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import reborncore.common.util.TorchHelper;
import techreborn.api.power.IEnergyItemInfo;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.powerSystem.PoweredItem;

public class ItemOmniTool
extends ItemPickaxe
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.OmniToolCharge;
    public static final int tier = ConfigTechReborn.OmniToolTier;
    public int cost = 100;
    public int hitCost = 125;

    public ItemOmniTool() {
        super(Item.ToolMaterial.EMERALD);
        this.field_77864_a = 13.0f;
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77625_d(1);
        this.func_77656_e(200);
        this.func_77655_b("techreborn.omniTool");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("techreborn:tool/omnitool");
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int par4, int par5, int par6, EntityLivingBase entityLiving) {
        PoweredItem.useEnergy(this.cost, stack);
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return Items.field_151056_x.canHarvestBlock(block, stack) || Items.field_151048_u.canHarvestBlock(block, stack) || Items.field_151046_w.canHarvestBlock(block, stack) || Items.field_151047_v.canHarvestBlock(block, stack) || Items.field_151097_aZ.canHarvestBlock(block, stack);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (PoweredItem.canUseEnergy(this.cost, stack)) {
            PoweredItem.useEnergy(this.cost, stack);
            return 5.0f;
        }
        if (Items.field_151053_p.getDigSpeed(stack, block, meta) > 1.0f || Items.field_151041_m.getDigSpeed(stack, block, meta) > 1.0f || Items.field_151039_o.getDigSpeed(stack, block, meta) > 1.0f || Items.field_151038_n.getDigSpeed(stack, block, meta) > 1.0f || Items.field_151097_aZ.getDigSpeed(stack, block, meta) > 1.0f) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase attacker) {
        if (PoweredItem.canUseEnergy(this.hitCost, itemstack)) {
            PoweredItem.useEnergy(this.hitCost, itemstack);
            entityliving.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 8.0f);
        }
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        return TorchHelper.placeTorch((ItemStack)stack, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z, (int)side, (float)xOffset, (float)yOffset, (float)zOffset);
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    @Override
    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxTransfer(ItemStack stack) {
        return 200.0;
    }

    @Override
    public int getStackTeir(ItemStack stack) {
        return 2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        itemList.add(itemStack);
        ItemStack charged = new ItemStack((Item)this, 1);
        PoweredItem.setEnergy(this.getMaxPower(charged), charged);
        itemList.add(charged);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = PoweredItem.getEnergy(stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

