/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.ElectricItem;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import reborncore.common.util.TorchHelper;
import techreborn.api.power.IEnergyItemInfo;
import techreborn.client.TechRebornCreativeTab;
import techreborn.config.ConfigTechReborn;
import techreborn.powerSystem.PoweredItem;

public class ItemAdvancedDrill
extends ItemPickaxe
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.AdvancedDrillCharge;
    public int cost = 250;
    public static final int tier = ConfigTechReborn.AdvancedDrillTier;
    public double transferLimit = 100.0;

    public ItemAdvancedDrill() {
        super(Item.ToolMaterial.EMERALD);
        this.field_77864_a = 20.0f;
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77625_d(1);
        this.func_77656_e(240);
        this.func_77655_b("techreborn.advancedDrill");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("techreborn:tool/advancedDrill");
    }

    public boolean func_150894_a(ItemStack stack, World world, Block block, int par4, int par5, int par6, EntityLivingBase entityLiving) {
        ElectricItem.manager.use(stack, this.cost, entityLiving);
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return Items.field_151046_w.canHarvestBlock(block, stack) || Items.field_151047_v.canHarvestBlock(block, stack);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        if (!ElectricItem.manager.canUse(stack, this.cost)) {
            return 4.0f;
        }
        if (Items.field_151039_o.getDigSpeed(stack, block, meta) > 1.0f || Items.field_151038_n.getDigSpeed(stack, block, meta) > 1.0f) {
            return this.field_77864_a;
        }
        return super.getDigSpeed(stack, block, meta);
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        return TorchHelper.placeTorch((ItemStack)stack, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z, (int)side, (float)xOffset, (float)yOffset, (float)zOffset);
    }

    public boolean isRepairable() {
        return false;
    }

    @Override
    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    @Override
    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxTransfer(ItemStack stack) {
        return this.transferLimit;
    }

    @Override
    public int getStackTeir(ItemStack stack) {
        return tier;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        itemList.add(itemStack);
        ItemStack charged = new ItemStack((Item)this, 1);
        PoweredItem.setEnergy(this.getMaxPower(charged), charged);
        itemList.add(charged);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        double charge = PoweredItem.getEnergy(stack) / this.getMaxPower(stack);
        return 1.0 - charge;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }
}

