/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import ic2.api.item.IC2Items;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import techreborn.Core;
import techreborn.client.TechRebornCreativeTab;
import techreborn.init.ModItems;
import techreborn.items.ItemTR;

public class ItemCells
extends ItemTR
implements IFluidContainerItem {
    public static final String[] types = new String[]{"Berylium", "biomass", "calciumCarbonate", "calcium", "carbon", "chlorine", "deuterium", "diesel", "ethanol", "glyceryl", "helium3", "helium", "heliumPlasma", "hydrogen", "ice", "lithium", "mercury", "methane", "nitrocarbon", "nitroCoalfuel", "nitroDiesel", "nitrogen", "nitrogenDioxide", "oil", "potassium", "seedOil", "silicon", "sodium", "sodiumPersulfate", "sodiumSulfide", "sulfur", "sulfuricAcid", "tritium", "wolframium", "empty"};
    private IIcon[] textures;

    public static ItemStack getCellByName(String name, int count) {
        return ItemCells.getCellByName(name, count, true);
    }

    public static ItemStack getCellByName(String name, int count, boolean lookForIC2) {
        Fluid fluid = FluidRegistry.getFluid((String)("fluid" + name.toLowerCase()));
        if (lookForIC2 && IC2Items.getItem("cell") != null) {
            if (fluid != null) {
                ItemStack stack = IC2Items.getItem("cell").func_77946_l();
                if (stack != null && stack.func_77973_b() instanceof IFluidContainerItem) {
                    IFluidContainerItem containerItem = (IFluidContainerItem)stack.func_77973_b();
                    containerItem.fill(stack, new FluidStack(fluid.getID(), Integer.MAX_VALUE), true);
                    stack.field_77994_a = count;
                    return stack;
                }
            } else {
                Core.logHelper.debug((Object)("Could not find fluid" + name + " in the fluid registry!"));
            }
        }
        int index = -1;
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals(name)) continue;
            index = i;
            break;
        }
        return new ItemStack(ModItems.cells, count, index);
    }

    public static ItemStack getCellByName(String name) {
        return ItemCells.getCellByName(name, 1);
    }

    public ItemCells() {
        this.func_77655_b("techreborn.cell");
        this.func_77627_a(true);
        this.func_77637_a(TechRebornCreativeTab.instance);
    }

    @Override
    public void func_94581_a(IIconRegister iconRegister) {
        this.textures = new IIcon[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a("techreborn:cells/" + types[i] + "Cell");
        }
    }

    public IIcon func_77617_a(int meta) {
        if (meta < 0 || meta >= this.textures.length) {
            meta = 0;
        }
        return this.textures[meta];
    }

    public String func_77667_c(ItemStack itemStack) {
        int meta = itemStack.func_77960_j();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.func_77658_a() + "." + types[meta];
    }

    public void func_150895_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < types.length; ++meta) {
            ItemStack stack = new ItemStack(item, 1, meta);
            if (FluidRegistry.getFluid((String)("fluid" + types[meta].toLowerCase())) != null) {
                this.fill(stack, new FluidStack(FluidRegistry.getFluid((String)("fluid" + types[meta].toLowerCase())), this.getCapacity(stack)), true);
            }
            list.add(stack);
        }
    }

    public FluidStack getFluid(ItemStack container) {
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p());
    }

    public int getCapacity(ItemStack container) {
        return 1000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.field_77994_a != 1) {
            return 0;
        }
        if (resource == null || resource.amount != this.getCapacity(container)) {
            return 0;
        }
        if (FluidRegistry.getFluid((String)("fluid" + types[container.func_77960_j()].toLowerCase())) == null) {
            return 0;
        }
        if (doFill) {
            NBTTagCompound tag = container.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            resource.writeToNBT(tag);
            container.func_77982_d(tag);
        }
        return this.getCapacity(container);
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (maxDrain < this.getCapacity(container)) {
            return null;
        }
        FluidStack fluidStack = this.getFluid(container);
        if (doDrain && fluidStack != null) {
            ItemStack empty = ItemCells.getCellByName("empty");
            if (empty != null) {
                container.func_77964_b(empty.func_77960_j());
                container.func_77982_d(empty.func_77978_p());
            } else {
                container.field_77994_a = 0;
            }
        }
        return fluidStack;
    }
}

