/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.info.IC2Classic;
import ic2.api.item.IC2Items;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import reborncore.common.misc.Functions;
import reborncore.common.misc.vecmath.Vecs3d;
import reborncore.common.misc.vecmath.Vecs3dCube;
import techreborn.client.IconSupplier;
import techreborn.partSystem.parts.CablePart;

public class RenderCablePart {
    public static void renderBox(Vecs3dCube cube, Block block, Tessellator tessellator, RenderBlocks renderblocks, IIcon texture, Double xD, Double yD, double zD, float thickness) {
        block.func_149676_a((float)cube.getMinX(), (float)cube.getMinY(), (float)cube.getMinZ(), (float)cube.getMaxX() + thickness, (float)cube.getMaxY() + thickness, (float)cube.getMaxZ() + thickness);
        renderblocks.func_147775_a(block);
        tessellator.func_78386_a(0.5f, 0.5f, 0.5f);
        renderblocks.func_147768_a(block, xD.doubleValue(), yD.doubleValue(), zD, texture);
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        renderblocks.func_147806_b(block, xD.doubleValue(), yD.doubleValue(), zD, texture);
        tessellator.func_78386_a(0.8f, 0.8f, 0.8f);
        renderblocks.func_147761_c(block, xD.doubleValue(), yD.doubleValue(), zD, texture);
        renderblocks.func_147734_d(block, xD.doubleValue(), yD.doubleValue(), zD, texture);
        tessellator.func_78386_a(0.6f, 0.6f, 0.6f);
        renderblocks.func_147798_e(block, xD.doubleValue(), yD.doubleValue(), zD, texture);
        renderblocks.func_147764_f(block, xD.doubleValue(), yD.doubleValue(), zD, texture);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderStatic(Vecs3d translation, int pass, CablePart part) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon texture = RenderCablePart.getIconFromType(part.type);
        RenderBlocks renderblocks = RenderBlocks.getInstance();
        double xD = part.field_145851_c;
        double yD = part.field_145848_d;
        double zD = part.field_145849_e;
        Block block = part.func_145838_q();
        tessellator.func_78380_c(block.func_149677_c((IBlockAccess)part.getWorld(), part.getX(), part.getY(), part.getZ()));
        RenderCablePart.renderBox(part.boundingBoxes[6], block, tessellator, renderblocks, texture, xD, yD, zD, 0.0f);
        for (ForgeDirection direction : ForgeDirection.values()) {
            if (part.connectedSides.get(direction) == null) continue;
            RenderCablePart.renderBox(part.boundingBoxes[Functions.getIntDirFromDirection((ForgeDirection)direction)], block, tessellator, renderblocks, texture, xD, yD, zD, 0.0f);
        }
        block.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        renderblocks.func_147775_a(block);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getIconFromType(int cableType) {
        if (IC2Classic.getLoadedIC2Type() == IC2Classic.IC2Type.SpeigersClassic) {
            return Block.func_149634_a((Item)IC2Items.getItem("copperCableBlock").func_77973_b()).func_149691_a(0, cableType * 16);
        }
        IIcon p = null;
        switch (cableType) {
            case 0: {
                p = IconSupplier.insulatedCopperCable;
                break;
            }
            case 1: {
                p = IconSupplier.copperCable;
                break;
            }
            case 2: {
                p = IconSupplier.goldCable;
                break;
            }
            case 3: {
                p = IconSupplier.insulatedGoldCable;
                break;
            }
            case 4: {
                p = IconSupplier.doubleInsulatedGoldCable;
                break;
            }
            case 5: {
                p = IconSupplier.ironCable;
                break;
            }
            case 6: {
                p = IconSupplier.insulatedIronCable;
                break;
            }
            case 7: {
                p = IconSupplier.doubleInsulatedIronCable;
                break;
            }
            case 8: {
                p = IconSupplier.trippleInsulatedIronCable;
                break;
            }
            case 9: {
                p = IconSupplier.glassFiberCable;
                break;
            }
            case 10: {
                p = IconSupplier.tinCable;
                break;
            }
            case 11: {
                p = IconSupplier.detectorCableBlock;
                break;
            }
            case 12: {
                p = IconSupplier.splitterCableBlock;
                break;
            }
            case 13: {
                p = IconSupplier.insulatedtinCableBlock;
                break;
            }
            case 14: {
                p = IconSupplier.copperCable;
            }
        }
        return p;
    }
}

