/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import techreborn.blocks.BlockMachineBase;
import techreborn.client.TechRebornCreativeTab;
import techreborn.tiles.TilePlayerDectector;

public class BlockPlayerDetector
extends BlockMachineBase {
    public static final String[] types = new String[]{"all", "others", "you"};
    private IIcon[] textures;

    public BlockPlayerDetector() {
        super(Material.field_151576_e);
        this.func_149663_c("techreborn.playerDetector");
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_149711_c(2.0f);
    }

    public Item func_149650_a(int par1, Random random, int par2) {
        return Item.func_150898_a((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add(new ItemStack(item, 1, meta));
        }
    }

    public int func_149692_a(int metaData) {
        return metaData;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.textures = new IIcon[types.length];
        for (int i = 0; i < types.length; ++i) {
            this.textures[i] = iconRegister.func_94245_a("techreborn:machine/player_detector_" + types[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metaData) {
        return this.textures[MathHelper.func_76125_a((int)metaData, (int)0, (int)(types.length - 1))];
    }

    @Override
    public void func_149726_b(World world, int x, int y, int z) {
    }

    @Override
    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TilePlayerDectector();
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149748_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity entity = blockAccess.func_147438_o(x, y, z);
        if (entity instanceof TilePlayerDectector) {
            return ((TilePlayerDectector)entity).isProvidingPower() ? 15 : 0;
        }
        return 0;
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity entity = blockAccess.func_147438_o(x, y, z);
        if (entity instanceof TilePlayerDectector) {
            return ((TilePlayerDectector)entity).isProvidingPower() ? 15 : 0;
        }
        return 0;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemstack) {
        super.func_149689_a(world, x, y, z, player, itemstack);
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePlayerDectector) {
            ((TilePlayerDectector)tile).owenerUdid = player.func_110124_au().toString();
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float hitX, float hitY, float hitZ) {
        if (super.func_149727_a(world, x, y, z, entityplayer, side, hitX, hitY, hitZ)) {
            return true;
        }
        int newMeta = (world.func_72805_g(x, y, z) + 1) % 3;
        String message = "";
        switch (newMeta) {
            case 0: {
                message = EnumChatFormatting.GREEN + "Detects all Players";
                break;
            }
            case 1: {
                message = EnumChatFormatting.RED + "Detects only other Players";
                break;
            }
            case 2: {
                message = EnumChatFormatting.BLUE + "Detects only you";
            }
        }
        if (!world.field_72995_K) {
            entityplayer.func_146105_b((IChatComponent)new ChatComponentText(message));
            world.func_72921_c(x, y, z, newMeta, 2);
        }
        return true;
    }
}

