/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks;

import cpw.mods.fml.common.Loader;
import ic2.api.item.IC2Items;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import techreborn.client.TechRebornCreativeTab;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileMachineBase;

public class BlockMachineBase
extends BlockContainer {
    public BlockMachineBase(Material material) {
        super(Material.field_151576_e);
        this.func_149647_a(TechRebornCreativeTab.instance);
        this.func_149711_c(2.0f);
        this.func_149672_a(field_149777_j);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileMachineBase();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block1 = world.func_147439_a(x, y, z - 1);
            Block block2 = world.func_147439_a(x, y, z + 1);
            Block block3 = world.func_147439_a(x - 1, y, z);
            Block block4 = world.func_147439_a(x + 1, y, z);
            int b = 3;
            if (block1.func_149730_j() && !block2.func_149730_j()) {
                b = 3;
            }
            if (block2.func_149730_j() && !block1.func_149730_j()) {
                b = 2;
            }
            if (block3.func_149730_j() && !block4.func_149730_j()) {
                b = 5;
            }
            if (block4.func_149730_j() && !block3.func_149730_j()) {
                b = 4;
            }
            world.func_72921_c(x, y, z, b, 2);
            this.setTileRotation(world, x, y, z, b);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemstack) {
        int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (l == 0) {
            this.setTileRotation(world, x, y, z, 2);
        }
        if (l == 1) {
            this.setTileRotation(world, x, y, z, 5);
        }
        if (l == 2) {
            this.setTileRotation(world, x, y, z, 3);
        }
        if (l == 3) {
            this.setTileRotation(world, x, y, z, 4);
        }
        super.func_149689_a(world, x, y, z, player, itemstack);
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        this.dropInventory(world, x, y, z);
        super.func_149749_a(world, x, y, z, block, meta);
    }

    protected void dropInventory(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack == null || itemStack.field_77994_a <= 0) continue;
            if (itemStack.func_77973_b() instanceof ItemBlock && (((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockFluidBase || ((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockStaticLiquid || ((ItemBlock)itemStack.func_77973_b()).field_150939_a instanceof BlockDynamicLiquid)) {
                return;
            }
            Random rand = new Random();
            float dX = rand.nextFloat() * 0.8f + 0.1f;
            float dY = rand.nextFloat() * 0.8f + 0.1f;
            float dZ = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), itemStack.func_77946_l());
            if (itemStack.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)itemStack.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            itemStack.field_77994_a = 0;
        }
    }

    public void setTileRotation(World world, int x, int y, int z, int meta) {
        if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileMachineBase) {
            ((TileMachineBase)world.func_147438_o(x, y, z)).setRotation(meta);
        }
    }

    public int getTileRotation(World world, int x, int y, int z) {
        if (world.func_147438_o(x, y, z) != null && world.func_147438_o(x, y, z) instanceof TileMachineBase) {
            return ((TileMachineBase)world.func_147438_o(x, y, z)).getRotation();
        }
        return 0;
    }

    public int getTileRotation(IBlockAccess blockAccess, int x, int y, int z) {
        return blockAccess.func_147438_o(x, y, z) != null ? this.getTileRotation(blockAccess.func_147438_o(x, y, z).func_145831_w(), x, y, z) : 0;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (Loader.isModLoaded((String)"IC2")) {
            ItemStack stack = IC2Items.getItem(this.isAdvanced() ? "advancedMachine" : "machine").func_77946_l();
            stack.field_77994_a = 1;
            items.add(stack);
        } else {
            items.add(this.isAdvanced() ? new ItemStack(Item.func_150898_a((Block)ModBlocks.MachineCasing), 1, 2) : new ItemStack(Item.func_150898_a((Block)ModBlocks.MachineCasing), 1, 0));
        }
        return items;
    }

    public boolean isAdvanced() {
        return false;
    }

    public boolean rotateBlock(World worldObj, int x, int y, int z, ForgeDirection axis) {
        if (axis == ForgeDirection.UNKNOWN) {
            return false;
        }
        TileEntity tile = worldObj.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileMachineBase) {
            TileMachineBase machineBase = (TileMachineBase)tile;
            machineBase.setRotation(ForgeDirection.getOrientation((int)machineBase.getRotation()).getRotation(axis).ordinal());
            return true;
        }
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float hitX, float hitY, float hitZ) {
        if (this.fillBlockWithFluid(world, x, y, z, entityplayer, side, hitX, hitY, hitZ)) {
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityplayer, side, hitX, hitY, hitZ);
    }

    public boolean fillBlockWithFluid(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (current != null && (tile = world.func_147438_o(x, y, z)) instanceof IFluidHandler) {
            IFluidHandler tank = (IFluidHandler)tile;
            if (FluidContainerRegistry.isContainer((ItemStack)current)) {
                ItemStack filled;
                FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
                if (liquid != null) {
                    int qty = tank.fill(ForgeDirection.UNKNOWN, liquid, true);
                    if (qty != 0 && !entityplayer.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (!entityplayer.field_71071_by.func_70441_a(FluidContainerRegistry.drainFluidContainer((ItemStack)current))) {
                                entityplayer.func_71019_a(FluidContainerRegistry.drainFluidContainer((ItemStack)current), false);
                            }
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, BlockMachineBase.consumeItem(current));
                        } else {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, FluidContainerRegistry.drainFluidContainer((ItemStack)current));
                        }
                    }
                    return true;
                }
                FluidStack available = tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
                if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                                return false;
                            }
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, BlockMachineBase.consumeItem(current));
                        } else {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, BlockMachineBase.consumeItem(current));
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, filled);
                        }
                    }
                    tank.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                    return true;
                }
            } else if (current.func_77973_b() instanceof IFluidContainerItem) {
                if (current.field_77994_a != 1) {
                    return false;
                }
                if (!world.field_72995_K) {
                    boolean mustFill;
                    IFluidContainerItem container = (IFluidContainerItem)current.func_77973_b();
                    FluidStack liquid = container.getFluid(current);
                    FluidStack tankLiquid = tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
                    boolean mustDrain = liquid == null || liquid.amount == 0;
                    boolean bl = mustFill = tankLiquid == null || tankLiquid.amount == 0;
                    if (!mustDrain || !mustFill) {
                        if (mustDrain || !entityplayer.func_70093_af()) {
                            liquid = tank.drain(ForgeDirection.UNKNOWN, 1000, false);
                            int qtyToFill = container.fill(current, liquid, true);
                            tank.drain(ForgeDirection.UNKNOWN, qtyToFill, true);
                        } else if ((mustFill || entityplayer.func_70093_af()) && liquid.amount > 0) {
                            int qty = tank.fill(ForgeDirection.UNKNOWN, liquid, false);
                            tank.fill(ForgeDirection.UNKNOWN, container.drain(current, qty, true), true);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static ItemStack consumeItem(ItemStack stack) {
        if (stack.field_77994_a == 1) {
            if (stack.func_77973_b().hasContainerItem(stack)) {
                return stack.func_77973_b().getContainerItem(stack);
            }
            return null;
        }
        stack.func_77979_a(1);
        return stack;
    }
}

