/*
 * Decompiled with CFR 0.152.
 */
package techreborn.api.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.time.StopWatch;
import reborncore.common.util.ItemUtils;
import techreborn.Core;
import techreborn.api.recipe.IBaseRecipeType;
import techreborn.api.recipe.recipeConfig.RecipeConfigManager;

public class RecipeHandler {
    public static final ArrayList<IBaseRecipeType> recipeList = new ArrayList();
    public static HashMap<IBaseRecipeType, String> stackMap = new HashMap();
    public static ArrayList<String> machineNames = new ArrayList();

    public static List<IBaseRecipeType> getRecipeClassFromName(String name) {
        ArrayList<IBaseRecipeType> baseRecipeList = new ArrayList<IBaseRecipeType>();
        for (IBaseRecipeType baseRecipe : recipeList) {
            if (!baseRecipe.getRecipeName().equals(name)) continue;
            baseRecipeList.add(baseRecipe);
        }
        return baseRecipeList;
    }

    public static String getUserFreindlyName(String name) {
        for (IBaseRecipeType baseRecipe : recipeList) {
            if (!baseRecipe.getRecipeName().equals(name)) continue;
            return baseRecipe.getUserFreindlyName();
        }
        return "";
    }

    public static void addRecipe(IBaseRecipeType recipe) {
        if (recipe == null) {
            return;
        }
        if (recipeList.contains(recipe)) {
            return;
        }
        if (!RecipeConfigManager.canLoadRecipe(recipe)) {
            return;
        }
        if (!machineNames.contains(recipe.getRecipeName())) {
            machineNames.add(recipe.getRecipeName());
        }
        recipeList.add(recipe);
        StringBuffer buffer = new StringBuffer();
        for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
            buffer.append(ste);
        }
        stackMap.put(recipe, buffer.toString());
    }

    public static void scanForDupeRecipes() throws Exception {
        StopWatch watch = new StopWatch();
        watch.start();
        for (IBaseRecipeType baseRecipeType : recipeList) {
            for (IBaseRecipeType recipe : recipeList) {
                if (baseRecipeType == recipe || !baseRecipeType.getRecipeName().equals(recipe.getRecipeName())) continue;
                for (int i = 0; i < baseRecipeType.getInputs().size(); ++i) {
                    if (!ItemUtils.isItemEqual((ItemStack)baseRecipeType.getInputs().get(i), (ItemStack)recipe.getInputs().get(i), (boolean)true, (boolean)false, (boolean)false)) continue;
                    StringBuffer itemInfo = new StringBuffer();
                    for (ItemStack inputs : baseRecipeType.getInputs()) {
                        itemInfo.append(":" + inputs.func_77973_b().func_77658_a() + "," + inputs.func_82833_r() + "," + inputs.field_77994_a);
                    }
                    Core.logHelper.all((Object)stackMap.get(baseRecipeType));
                }
            }
        }
        Core.logHelper.all((Object)(watch + " : Scanning dupe recipes"));
        watch.stop();
    }
}

