/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world.ranks;

import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryString;
import ftb.lib.api.config.ConfigFile;
import ftb.lib.api.config.ConfigGroup;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.ranks.Rank;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.util.EnumChatFormatting;

public class Ranks {
    public static final Rank PLAYER = new Rank("Player");
    public static final Rank ADMIN = new Rank("Admin");
    private static ConfigFile file;
    private static final ConfigEntryString default_rank;
    private static final ConfigGroup ranks_group;
    private static Rank defaultRank;
    private static final HashMap<String, Rank> ranks;
    private static final HashMap<UUID, Rank> playerMap;

    public static Rank getRankFor(LMPlayerServer p) {
        boolean enabled = false;
        if (enabled) {
            if (p == null || p.isFake()) {
                return defaultRank;
            }
            Rank r = playerMap.get(p.getProfile().getId());
            return r == null ? defaultRank : r;
        }
        if (p == null || p.isFake()) {
            return PLAYER;
        }
        return p.isOP() ? ADMIN : PLAYER;
    }

    public static void load(ConfigFile file) {
        ADMIN.setDefaults();
        Ranks.ADMIN.color.set((Object)EnumChatFormatting.DARK_GREEN);
        PLAYER.setDefaults();
        Ranks.PLAYER.color.set((Object)EnumChatFormatting.WHITE);
        file.add((ConfigEntry)Ranks.ADMIN.config.getAsGroup("permissions_admin", false), false);
        file.add((ConfigEntry)Ranks.PLAYER.config.getAsGroup("permissions_player", false), false);
        Ranks.reload();
    }

    public static void reload() {
        ranks.clear();
        playerMap.clear();
    }

    public static void saveRanks() {
    }

    public static Rank getRankFor(String s) {
        return ranks.get(s);
    }

    public static void setRank(Rank r) {
    }

    static {
        default_rank = new ConfigEntryString("default_rank", "Player");
        ranks_group = new ConfigGroup("ranks");
        ranks = new HashMap();
        playerMap = new HashMap();
    }
}

