/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world.claims;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ftb.lib.LMDimUtils;
import ftb.utils.world.claims.ClaimedChunks;
import ftb.utils.world.claims.LMWorldSettings;
import latmod.lib.MathHelperLM;
import latmod.lib.util.Pos2I;

public class WorldBorder {
    public final LMWorldSettings settings;
    public final int dim;
    public final Pos2I pos;
    public int size;

    public WorldBorder(LMWorldSettings s, int d) {
        this.settings = s;
        this.dim = d;
        this.pos = new Pos2I(0, 0);
        this.size = 0;
    }

    public JsonElement toJson() {
        JsonObject o = new JsonObject();
        o.add("dim", (JsonElement)new JsonPrimitive((Number)this.dim));
        o.add("x", (JsonElement)new JsonPrimitive((Number)this.pos.x));
        o.add("z", (JsonElement)new JsonPrimitive((Number)this.pos.y));
        o.add("size", (JsonElement)new JsonPrimitive((Number)this.size));
        return o;
    }

    public static WorldBorder fromJson(LMWorldSettings s, JsonElement e) {
        JsonObject a = e.getAsJsonObject();
        WorldBorder wb = new WorldBorder(s, a.get("dim").getAsInt());
        wb.pos.x = a.get("x").getAsInt();
        wb.pos.y = a.get("z").getAsInt();
        wb.size = a.get("size").getAsInt();
        return wb;
    }

    public int getSize() {
        if (!this.settings.border_enabled.get()) {
            return 0;
        }
        if (this.size > 0) {
            this.size = Math.max(this.size, 20);
        }
        if (this.dim == 0) {
            return Math.max(0, this.size);
        }
        return this.size == -1 ? (int)((double)this.settings.worldBorder0.size * LMDimUtils.getWorldScale((int)this.dim)) : this.size;
    }

    public void setSize(int s) {
        if (this.settings.world.side.isServer() && this.size != s) {
            this.size = s;
            this.settings.world.getServerWorld().update(null);
        }
    }

    public void setPos(int x, int z) {
        if (this.settings.world.side.isServer() && (this.pos.x != x || this.pos.y != z)) {
            this.pos.set(x, z);
            this.settings.world.getServerWorld().update(null);
        }
    }

    public boolean isOutside(int cx, int cz) {
        if (ClaimedChunks.isInSpawn(this.dim, cx, cz)) {
            return false;
        }
        int size1 = this.getSize();
        if (size1 == 0) {
            return false;
        }
        int minX = MathHelperLM.chunk((int)(this.pos.x - size1));
        int maxX = MathHelperLM.chunk((int)(this.pos.x + size1));
        int minZ = MathHelperLM.chunk((int)(this.pos.y - size1));
        int maxZ = MathHelperLM.chunk((int)(this.pos.y + size1));
        return cx >= maxX || cx <= minX || cz >= maxZ || cz <= minZ;
    }

    public boolean isOutsideD(double x, double z) {
        return this.isOutside(MathHelperLM.chunk((double)x), MathHelperLM.chunk((double)z));
    }
}

