/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.world;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.LMNBTUtils;
import ftb.lib.api.client.FTBLibClient;
import ftb.utils.api.EventLMPlayerClient;
import ftb.utils.world.LMPlayer;
import ftb.utils.world.LMPlayerClientSelf;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorld;
import ftb.utils.world.LMWorldClient;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import latmod.lib.ByteCount;
import latmod.lib.ByteIOStream;
import latmod.lib.IntList;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class LMPlayerClient
extends LMPlayer {
    public final LMWorldClient world;
    public final List<String> clientInfo;
    public boolean isOnline;

    public LMPlayerClient(LMWorldClient w, int i, GameProfile gp) {
        super(i, gp);
        this.world = w;
        this.clientInfo = new ArrayList<String>();
        this.isOnline = false;
    }

    public ResourceLocation getSkin() {
        return FTBLibClient.getSkinTexture((String)this.getProfile().getName());
    }

    @Override
    public LMWorld getWorld() {
        return this.world;
    }

    public Side getSide() {
        return Side.CLIENT;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public LMPlayerServer toPlayerMP() {
        return null;
    }

    @Override
    public LMPlayerClient toPlayerSP() {
        return this;
    }

    public LMPlayerClientSelf toPlayerSPSelf() {
        return null;
    }

    public EntityPlayerSP getPlayer() {
        return this.isOnline() ? FTBLibClient.getPlayerSP((UUID)this.getProfile().getId()) : null;
    }

    public void receiveInfo(List<IChatComponent> info) {
        this.clientInfo.clear();
        for (IChatComponent c : info) {
            this.clientInfo.add(c.func_150254_d());
        }
        new EventLMPlayerClient.CustomInfo(this, this.clientInfo).post();
    }

    public void readFromNet(ByteIOStream io, boolean self) {
        this.isOnline = io.readBoolean();
        this.renderBadge = io.readBoolean();
        this.friends.clear();
        this.friends.addAll(io.readIntArray(ByteCount.SHORT));
        IntList otherFriends = IntList.asList((int[])io.readIntArray(ByteCount.SHORT));
        for (LMPlayerClient p : this.world.playerMap.values()) {
            if (p.equalsPlayer(this)) continue;
            p.friends.clear();
            if (!otherFriends.contains(p.getPlayerID())) continue;
            p.friends.add(this.getPlayerID());
            otherFriends.removeValue(p.getPlayerID());
        }
        this.commonPublicData = LMNBTUtils.readTag((ByteIOStream)io);
    }
}

