/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.net;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.BlockDimPos;
import ftb.lib.api.net.LMNetworkWrapper;
import ftb.utils.mod.client.gui.claims.ClaimedAreasClient;
import ftb.utils.net.FTBUNetHandler;
import ftb.utils.net.MessageFTBU;
import ftb.utils.world.LMPlayerServer;
import ftb.utils.world.LMWorldServer;
import ftb.utils.world.claims.ChunkType;
import latmod.lib.ByteCount;
import latmod.lib.MathHelperLM;

public class MessageAreaUpdate
extends MessageFTBU {
    public MessageAreaUpdate() {
        super(ByteCount.INT);
    }

    public MessageAreaUpdate(LMPlayerServer p, int x, int z, int d, int sx, int sz) {
        this();
        sx = MathHelperLM.clampInt((int)sx, (int)1, (int)255);
        sz = MathHelperLM.clampInt((int)sx, (int)1, (int)255);
        this.io.writeInt(x);
        this.io.writeInt(z);
        this.io.writeInt(d);
        this.io.writeByte(sx);
        this.io.writeByte(sz);
        for (int z1 = z; z1 < z + sz; ++z1) {
            for (int x1 = x; x1 < x + sx; ++x1) {
                ChunkType type = LMWorldServer.inst.claimedChunks.getType(d, x1, z1);
                if (type instanceof ChunkType.PlayerClaimed && type.isChunkOwner(p) && LMWorldServer.inst.claimedChunks.getChunk((int)d, (int)x1, (int)z1).isChunkloaded) {
                    type = ChunkType.LOADED_SELF;
                }
                this.io.writeInt(type.ID);
            }
        }
    }

    public MessageAreaUpdate(LMPlayerServer p, BlockDimPos pos, int sx, int sz) {
        this(p, pos.chunkX() - (sx / 2 + 1), pos.chunkZ() - (sz / 2 + 1), pos.dim, sx, sz);
    }

    @Override
    public LMNetworkWrapper getWrapper() {
        return FTBUNetHandler.NET_WORLD;
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageContext ctx) {
        int chunkX = this.io.readInt();
        int chunkZ = this.io.readInt();
        int dim = this.io.readInt();
        int sx = this.io.readUnsignedByte();
        int sz = this.io.readUnsignedByte();
        int[] types = new int[sx * sz];
        for (int i = 0; i < types.length; ++i) {
            types[i] = this.io.readInt();
        }
        ClaimedAreasClient.setTypes(dim, chunkX, chunkZ, sx, sz, types);
        return null;
    }
}

