/*
 * Decompiled with CFR 0.152.
 */
package ftb.utils.mod.client.gui.claims;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ftb.lib.api.client.FTBLibClient;
import ftb.utils.mod.client.gui.claims.GuiClaimChunks;
import java.nio.ByteBuffer;
import java.util.Arrays;
import latmod.lib.LMColorUtils;
import latmod.lib.MathHelperLM;
import latmod.lib.PixelBuffer;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

@SideOnly(value=Side.CLIENT)
public class ThreadReloadArea
extends Thread {
    private static final short defHeight = -1;
    public static final PixelBuffer pixels = new PixelBuffer(256, 256);
    public static final short[] heightMap = new short[ThreadReloadArea.pixels.pixels.length];
    public final World worldObj;
    public final GuiClaimChunks gui;
    public Chunk chunkMC;
    public short maxHeight = 0;
    public boolean isNether;

    public ThreadReloadArea(World w, GuiClaimChunks m) {
        super("LM_MapReloader");
        this.setDaemon(true);
        this.worldObj = w;
        this.gui = m;
        Arrays.fill(heightMap, (short)-1);
        Arrays.fill(ThreadReloadArea.pixels.pixels, 0);
        this.isNether = this.worldObj.field_73011_w.field_76574_g == -1;
    }

    @Override
    public void run() {
        try {
            ByteBuffer buffer;
            for (int cz = 0; cz < 15; ++cz) {
                for (int cx = 0; cx < 15; ++cx) {
                    if (!this.worldObj.func_72863_F().func_73149_a(this.gui.startX, this.gui.startY)) continue;
                    this.chunkMC = this.worldObj.func_72964_e(this.gui.startX, this.gui.startY);
                    this.maxHeight = (short)Math.max(255, this.chunkMC.func_76625_h() + 15);
                    int x = (this.gui.startX + cx) * 16;
                    int y = (this.gui.startY + cz) * 16;
                    for (int i = 0; i < 256; ++i) {
                        int bx = x + i % 16;
                        int by = y + i / 16;
                        int col = this.getBlockColor(bx, by);
                        pixels.setRGB(cx * 16 + i % 16, cz * 16 + i / 16, col);
                    }
                }
            }
            GuiClaimChunks.pixelBuffer = buffer = FTBLibClient.toByteBuffer((int[])ThreadReloadArea.pixels.pixels, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getBlockColor(int bx, int bz) {
        short by = this.getTopY(bx, bz);
        if (by == -1 || by > 255) {
            return 0;
        }
        Block block = this.worldObj.func_147439_a(bx, (int)by, bz);
        if (!block.isAir((IBlockAccess)this.worldObj, bx, (int)by, bz)) {
            int col = 0xFF000000 | this.getBlockColor(block, bx, by, bz);
            short bw = this.getTopY(bx - 1, bz);
            short be = this.getTopY(bx + 1, bz);
            short bn = this.getTopY(bx, bz - 1);
            short bs = this.getTopY(bx, bz + 1);
            if (bw != -1 && bw < by || bn != -1 && bn < by) {
                return LMColorUtils.addBrightness((int)col, (int)25);
            }
            if (be != -1 && be < by || bs != -1 && bs < by) {
                return LMColorUtils.addBrightness((int)col, (int)-25);
            }
            return col;
        }
        return 0;
    }

    private short getTopY(int bx, int bz) {
        int x = MathHelperLM.wrap((int)bx, (int)16);
        int z = MathHelperLM.wrap((int)bz, (int)16);
        Chunk c = this.chunkMC;
        short max = this.maxHeight;
        boolean mapValue = false;
        int cx = MathHelperLM.chunk((int)bx);
        int cz = MathHelperLM.chunk((int)bz);
        if (cx == this.gui.startX && cz == this.gui.startY) {
            mapValue = true;
            if (heightMap[x + z * 16] != -1) {
                return heightMap[x + z * 16];
            }
        } else {
            c = this.worldObj.func_72964_e(MathHelperLM.chunk((int)bx), MathHelperLM.chunk((int)bz));
            max = (short)Math.max(255, c.func_76625_h() + 15);
        }
        for (short y = max; y > 0; y = (short)(y - 1)) {
            Block block = c.func_150810_a(x, (int)y, z);
            if (this.isNether && (block == Blocks.field_150357_h || block == Blocks.field_150424_aL) || block == Blocks.field_150329_H || block.isAir((IBlockAccess)this.worldObj, bx, (int)y, bz)) continue;
            if (mapValue) {
                ThreadReloadArea.heightMap[x + z * 16] = y;
            }
            return y;
        }
        return -1;
    }

    private int getBlockColor(Block b, int x, int y, int z) {
        if (b == Blocks.field_150322_A) {
            return MapColor.field_151658_d.field_76291_p;
        }
        if (b == Blocks.field_150480_ab) {
            return MapColor.field_151645_D.field_76291_p;
        }
        if (b == Blocks.field_150327_N) {
            return MapColor.field_151673_t.field_76291_p;
        }
        if (b == Blocks.field_150353_l) {
            return MapColor.field_151676_q.field_76291_p;
        }
        if (b == Blocks.field_150377_bs) {
            return MapColor.field_151658_d.field_76291_p;
        }
        if (b == Blocks.field_150343_Z) {
            return -15400889;
        }
        if (b == Blocks.field_150351_n) {
            return -7497829;
        }
        if (b == Blocks.field_150359_w) {
            return 868022783;
        }
        if (b == Blocks.field_150424_aL) {
            return -5821888;
        }
        if (b == Blocks.field_150357_h) {
            return -10461088;
        }
        if (b == Blocks.field_150425_aM) {
            return -6275014;
        }
        if (b == Blocks.field_150426_aN) {
            return -10240;
        }
        if (b.func_149688_o() == Material.field_151586_h) {
            return LMColorUtils.multiply((int)MapColor.field_151662_n.field_76291_p, (int)b.func_149720_d((IBlockAccess)this.worldObj, x, y, z), (int)200);
        }
        if (b == Blocks.field_150328_O) {
            int m = this.worldObj.func_72805_g(x, y, z);
            if (m == 0) {
                return MapColor.field_151645_D.field_76291_p;
            }
            if (m == 1) {
                return MapColor.field_151674_s.field_76291_p;
            }
            if (m == 2) {
                return MapColor.field_151675_r.field_76291_p;
            }
            if (m == 3) {
                return MapColor.field_151680_x.field_76291_p;
            }
            if (m == 4) {
                return MapColor.field_151645_D.field_76291_p;
            }
            if (m == 5) {
                return MapColor.field_151676_q.field_76291_p;
            }
            if (m == 6) {
                return MapColor.field_151666_j.field_76291_p;
            }
            if (m == 7) {
                return MapColor.field_151671_v.field_76291_p;
            }
            if (m == 8) {
                return MapColor.field_151680_x.field_76291_p;
            }
        } else if (b == Blocks.field_150344_f) {
            int m = this.worldObj.func_72805_g(x, y, z);
            if (m == 0) {
                return -3762103;
            }
            if (m == 1) {
                return -8626642;
            }
            if (m == 2) {
                return -860013;
            }
            if (m == 3) {
                return -3770797;
            }
            if (m == 4) {
                return -2064578;
            }
            if (m == 5) {
                return -11457260;
            }
        }
        if (b == Blocks.field_150362_t || b == Blocks.field_150395_bd || b == Blocks.field_150392_bi) {
            return LMColorUtils.addBrightness((int)b.func_149720_d((IBlockAccess)this.worldObj, x, y, z), (int)-40);
        }
        if (b == Blocks.field_150349_c && this.worldObj.func_72805_g(x, y, z) == 0) {
            return LMColorUtils.addBrightness((int)b.func_149720_d((IBlockAccess)this.worldObj, x, y, z), (int)-15);
        }
        return b.func_149728_f((int)this.worldObj.func_72805_g((int)x, (int)y, (int)z)).field_76291_p;
    }
}

