/*
 * Decompiled with CFR 0.152.
 */
package shedar.mods.ic2.nuclearcontrol.panel;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import shedar.mods.ic2.nuclearcontrol.IScreenPart;
import shedar.mods.ic2.nuclearcontrol.tileentities.TileEntityInfoPanel;

public class Screen {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;
    private int coreX;
    private int coreY;
    private int coreZ;
    private boolean powered = false;

    public TileEntityInfoPanel getCore(IBlockAccess world) {
        TileEntity tileEntity = world.func_147438_o(this.coreX, this.coreY, this.coreZ);
        if (tileEntity == null || !(tileEntity instanceof TileEntityInfoPanel)) {
            return null;
        }
        return (TileEntityInfoPanel)tileEntity;
    }

    public void setCore(TileEntityInfoPanel core) {
        this.coreX = core.field_145851_c;
        this.coreY = core.field_145848_d;
        this.coreZ = core.field_145849_e;
        this.powered = core.getPowered();
    }

    public boolean isBlockNearby(TileEntity tileEntity) {
        int x = tileEntity.field_145851_c;
        int y = tileEntity.field_145848_d;
        int z = tileEntity.field_145849_e;
        return x == this.minX - 1 && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ || x == this.maxX + 1 && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ || x >= this.minX && x <= this.maxX && y == this.minY - 1 && z >= this.minZ && z <= this.maxZ || x >= this.minX && x <= this.maxX && y == this.maxY + 1 && z >= this.minZ && z <= this.maxZ || x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z == this.minZ - 1 || x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z == this.maxZ + 1;
    }

    public boolean isBlockPartOf(TileEntity tileEntity) {
        int x = tileEntity.field_145851_c;
        int y = tileEntity.field_145848_d;
        int z = tileEntity.field_145849_e;
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public void init(boolean force, World world) {
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    TileEntity tileEntity = world.func_147438_o(x, y, z);
                    if (tileEntity == null || !(tileEntity instanceof IScreenPart)) continue;
                    ((IScreenPart)tileEntity).setScreen(this);
                    if (!this.powered && !force) continue;
                    world.func_147471_g(x, y, z);
                    world.func_147451_t(x, y, z);
                }
            }
        }
    }

    public void destroy(boolean force, World world) {
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    TileEntity tileEntity = world.func_147438_o(x, y, z);
                    if (tileEntity == null || !(tileEntity instanceof IScreenPart)) continue;
                    IScreenPart part = (IScreenPart)tileEntity;
                    Screen targetScreen = part.getScreen();
                    if (targetScreen != null && targetScreen.equals(this)) {
                        part.setScreen(null);
                        part.updateData();
                    }
                    if (!this.powered && !force) continue;
                    world.func_147471_g(x, y, z);
                    world.func_147451_t(x, y, z);
                }
            }
        }
    }

    public void turnPower(boolean on, World world) {
        if (this.powered != on) {
            this.powered = on;
            for (int x = this.minX; x <= this.maxX; ++x) {
                for (int y = this.minY; y <= this.maxY; ++y) {
                    for (int z = this.minZ; z <= this.maxZ; ++z) {
                        world.func_147471_g(x, y, z);
                        world.func_147451_t(x, y, z);
                    }
                }
            }
        }
    }

    public void markUpdate(World world) {
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int y = this.minY; y <= this.maxY; ++y) {
                for (int z = this.minZ; z <= this.maxZ; ++z) {
                    world.func_147471_g(x, y, z);
                    world.func_147451_t(x, y, z);
                }
            }
        }
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("minX", this.minX);
        tag.func_74768_a("minY", this.minY);
        tag.func_74768_a("minZ", this.minZ);
        tag.func_74768_a("maxX", this.maxX);
        tag.func_74768_a("maxY", this.maxY);
        tag.func_74768_a("maxZ", this.maxZ);
        return tag;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.coreX;
        result = 31 * result + this.coreY;
        result = 31 * result + this.coreZ;
        result = 31 * result + this.maxX;
        result = 31 * result + this.maxY;
        result = 31 * result + this.maxZ;
        result = 31 * result + this.minX;
        result = 31 * result + this.minY;
        result = 31 * result + this.minZ;
        return result;
    }

    public boolean isCore(int x, int y, int z) {
        return x == this.coreX && y == this.coreY && z == this.coreZ;
    }

    public int getDx() {
        return this.maxX - this.minX;
    }

    public int getDy() {
        return this.maxY - this.minY;
    }

    public int getDz() {
        return this.maxZ - this.minZ;
    }

    public int getHeight(TileEntityInfoPanel core) {
        if (core == null) {
            return 0;
        }
        int rotation = core.getRotation();
        switch (core.getFacing()) {
            case 0: 
            case 1: {
                if (rotation == 0 || rotation == 3) {
                    return this.getDz() + 1;
                }
                return this.getDx() + 1;
            }
            case 2: 
            case 3: {
                if (rotation == 0 || rotation == 3) {
                    return this.getDy() + 1;
                }
                return this.getDx() + 1;
            }
            case 4: 
            case 5: {
                if (rotation == 0 || rotation == 3) {
                    return this.getDy() + 1;
                }
                return this.getDz() + 1;
            }
        }
        return 1;
    }

    public int getWidth(TileEntityInfoPanel core) {
        if (core == null) {
            return 0;
        }
        int rotation = core.getRotation();
        switch (core.getFacing()) {
            case 0: 
            case 1: {
                if (rotation == 0 || rotation == 3) {
                    return this.getDx() + 1;
                }
                return this.getDz() + 1;
            }
            case 2: 
            case 3: {
                if (rotation == 0 || rotation == 3) {
                    return this.getDx() + 1;
                }
                return this.getDy() + 1;
            }
            case 4: 
            case 5: {
                if (rotation == 0 || rotation == 3) {
                    return this.getDz() + 1;
                }
                return this.getDy() + 1;
            }
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Screen other = (Screen)obj;
        if (this.coreX != other.coreX) {
            return false;
        }
        if (this.coreY != other.coreY) {
            return false;
        }
        if (this.coreZ != other.coreZ) {
            return false;
        }
        if (this.maxX != other.maxX) {
            return false;
        }
        if (this.maxY != other.maxY) {
            return false;
        }
        if (this.maxZ != other.maxZ) {
            return false;
        }
        if (this.minX != other.minX) {
            return false;
        }
        if (this.minY != other.minY) {
            return false;
        }
        return this.minZ == other.minZ;
    }
}

