/*
 * Decompiled with CFR 0.152.
 */
package com.jadarstudios.developercapes;

import com.jadarstudios.developercapes.RenderEventHandler;
import com.jadarstudios.developercapes.cape.CapeConfig;
import com.jadarstudios.developercapes.cape.CapeConfigManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DevCapes {
    private static DevCapes instance;
    public static final Logger logger;

    protected DevCapes() {
        MinecraftForge.EVENT_BUS.register((Object)new RenderEventHandler());
    }

    public static DevCapes getInstance() {
        if (instance == null) {
            instance = new DevCapes();
        }
        return instance;
    }

    public InputStream getStreamForURL(URL url) {
        InputStream is = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setRequestProperty("User-Agent", System.getProperty("java.version"));
            connection.connect();
            is = connection.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return is;
    }

    public InputStream getStreamForFile(File file) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return is;
    }

    @Deprecated
    public int registerConfig(String jsonURL, String identifier) {
        return this.registerConfig(jsonURL);
    }

    public int registerConfig(String jsonUrl) {
        int id = -1;
        try {
            URL url = new URL(jsonUrl);
            id = this.registerConfig(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return id;
    }

    @Deprecated
    public int registerConfig(URL url, String identifier) {
        return this.registerConfig(url);
    }

    public int registerConfig(URL jsonUrl) {
        int id = -1;
        InputStream is = this.getStreamForURL(jsonUrl);
        if (is == null) {
            logger.error(String.format("Unable to establish a connection to the server, %s", jsonUrl.getHost()));
            return id;
        }
        CapeConfig config = CapeConfigManager.getInstance().parse(is);
        try {
            id = CapeConfigManager.getUniqueId();
            CapeConfigManager.getInstance().addConfig(id, config);
        }
        catch (CapeConfigManager.InvalidCapeConfigIdException e) {
            e.printStackTrace();
        }
        DevCapes.silentClose(is);
        return id;
    }

    private static void silentClose(InputStream is) {
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        logger = LogManager.getLogger((String)"DevCapes");
    }
}

