/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.statements;

import buildcraft.api.robots.DockingStation;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.robotics.EntityRobot;
import buildcraft.robotics.RobotUtils;
import buildcraft.robotics.statements.StatementParameterRobot;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;

public class TriggerRobotInStation
extends BCStatement
implements ITriggerInternal {
    public TriggerRobotInStation() {
        super(new String[]{"buildcraft:robot.in.station"});
    }

    public String getDescription() {
        return StringUtils.localize((String)"gate.trigger.robot.in.station");
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraftrobotics:triggers/trigger_robot_in_station");
    }

    public int minParameters() {
        return 0;
    }

    public int maxParameters() {
        return 0;
    }

    public IStatementParameter createParameter(int index) {
        return new StatementParameterRobot();
    }

    public boolean isTriggerActive(IStatementContainer container, IStatementParameter[] parameters) {
        List<DockingStation> stations = RobotUtils.getStations(container.getTile());
        for (DockingStation station : stations) {
            EntityRobot robot;
            if (station.robotTaking() == null || (robot = (EntityRobot)station.robotTaking()).getDockingStation() != station) continue;
            if (parameters.length > 0 && parameters[0] != null && parameters[0].getItemStack() != null) {
                if (!StatementParameterRobot.matches(parameters[0], robot)) continue;
                return true;
            }
            return true;
        }
        return false;
    }
}

