/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.statements;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.items.IMapLocation;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.IRobotRegistry;
import buildcraft.api.robots.RobotManager;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementParameterItemStack;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.statements.BCStatement;
import buildcraft.robotics.EntityRobot;
import buildcraft.robotics.RobotUtils;
import buildcraft.robotics.ai.AIRobotGoAndLinkToDock;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionRobotGotoStation
extends BCStatement
implements IActionInternal {
    public ActionRobotGotoStation() {
        super(new String[]{"buildcraft:robot.goto_station"});
    }

    public String getDescription() {
        return StringUtils.localize((String)"gate.action.robot.goto_station");
    }

    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraftrobotics:triggers/action_robot_goto_station");
    }

    public void actionActivate(IStatementContainer container, IStatementParameter[] parameters) {
        IRobotRegistry registry = RobotManager.registryProvider.getRegistry(container.getTile().func_145831_w());
        List<DockingStation> stations = RobotUtils.getStations(container.getTile());
        for (DockingStation station : stations) {
            EntityRobot robot;
            AIRobot ai;
            if (station.robotTaking() == null || (ai = (robot = (EntityRobot)station.robotTaking()).getOverridingAI()) != null) continue;
            DockingStation newStation = station;
            if (parameters[0] != null) {
                newStation = this.getStation((StatementParameterItemStack)parameters[0], registry);
            }
            if (newStation == null) continue;
            robot.overrideAI(new AIRobotGoAndLinkToDock(robot, newStation));
        }
    }

    private DockingStation getStation(StatementParameterItemStack stackParam, IRobotRegistry registry) {
        ForgeDirection side;
        DockingStation paramStation;
        IMapLocation map;
        BlockIndex index;
        ItemStack item = stackParam.getItemStack();
        if (item != null && item.func_77973_b() instanceof IMapLocation && (index = (map = (IMapLocation)item.func_77973_b()).getPoint(item)) != null && (paramStation = registry.getStation(index.x, index.y, index.z, side = map.getPointSide(item))) != null) {
            return paramStation;
        }
        return null;
    }

    public int maxParameters() {
        return 1;
    }

    public IStatementParameter createParameter(int index) {
        return new StatementParameterItemStack();
    }
}

