/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.render;

import buildcraft.BuildCraftRobotics;
import buildcraft.api.robots.IRobotOverlayItem;
import buildcraft.core.DefaultProps;
import buildcraft.core.EntityLaser;
import buildcraft.core.LaserData;
import buildcraft.core.lib.render.RenderUtils;
import buildcraft.core.render.RenderLaser;
import buildcraft.robotics.EntityRobot;
import buildcraft.robotics.ItemRobot;
import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderBiped;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySkullRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderRobot
extends Render
implements IItemRenderer {
    private static final ResourceLocation overlay_red = new ResourceLocation(DefaultProps.TEXTURE_PATH_ROBOTS + "/overlay_side.png");
    private static final ResourceLocation overlay_cyan = new ResourceLocation(DefaultProps.TEXTURE_PATH_ROBOTS + "/overlay_bottom.png");
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem;
    private ModelBase model = new ModelBase(){};
    private ModelBase modelHelmet = new ModelBase(){};
    private ModelBase modelSkullOverlay = new ModelBase(){};
    private ModelRenderer box;
    private ModelRenderer helmetBox;
    private ModelRenderer skullOverlayBox;
    private Map<String, GameProfile> gameProfileCache = new HashMap<String, GameProfile>();

    public RenderRobot() {
        this.customRenderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
        this.box = new ModelRenderer(this.model, 0, 0);
        this.box.func_78789_a(-4.0f, -4.0f, -4.0f, 8, 8, 8);
        this.box.func_78793_a(0.0f, 0.0f, 0.0f);
        this.helmetBox = new ModelRenderer(this.modelHelmet, 0, 0);
        this.helmetBox.func_78789_a(-4.0f, -8.0f, -4.0f, 8, 8, 8);
        this.helmetBox.func_78793_a(0.0f, 0.0f, 0.0f);
        this.skullOverlayBox = new ModelRenderer(this.modelSkullOverlay, 32, 0);
        this.skullOverlayBox.func_78790_a(-4.0f, -8.0f, -4.0f, 8, 8, 8, 0.5f);
        this.skullOverlayBox.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float f, float f1) {
        this.doRender((EntityRobot)entity, x, y, z, f1);
    }

    private void doRender(EntityRobot robot, double x, double y, double z, float partialTicks) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        float robotYaw = this.interpolateRotation(robot.field_70760_ar, robot.field_70761_aq, partialTicks);
        GL11.glRotatef((float)(-robotYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (robot.func_70301_a(0) != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.125f, (float)0.0f, (float)-0.125f);
            this.doRenderItem(robot.func_70301_a(0));
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        if (robot.func_70301_a(1) != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.125f, (float)0.0f, (float)-0.125f);
            this.doRenderItem(robot.func_70301_a(1));
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        if (robot.func_70301_a(2) != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.125f, (float)0.0f, (float)0.125f);
            this.doRenderItem(robot.func_70301_a(2));
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        if (robot.func_70301_a(3) != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)-0.125f, (float)0.0f, (float)0.125f);
            this.doRenderItem(robot.func_70301_a(3));
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        if (robot.itemInUse != null) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)robot.itemAngle2, (float)0.0f, (float)0.0f, (float)1.0f);
            if (robot.itemActive) {
                long newDate = new Date().getTime();
                robot.itemActiveStage = (robot.itemActiveStage + (float)((newDate - robot.lastUpdateTime) / 10L)) % 45.0f;
                GL11.glRotatef((float)robot.itemActiveStage, (float)0.0f, (float)0.0f, (float)1.0f);
                robot.lastUpdateTime = newDate;
            }
            GL11.glTranslatef((float)-0.4f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.8f, (float)0.8f, (float)0.8f);
            ItemStack itemstack1 = robot.itemInUse;
            if (itemstack1.func_77973_b().func_77623_v()) {
                for (int k = 0; k < itemstack1.func_77973_b().getRenderPasses(itemstack1.func_77960_j()); ++k) {
                    RenderUtils.setGLColorFromInt((int)itemstack1.func_77973_b().func_82790_a(itemstack1, k));
                    this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)robot, itemstack1, k);
                }
            } else {
                RenderUtils.setGLColorFromInt((int)itemstack1.func_77973_b().func_82790_a(itemstack1, 0));
                this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)robot, itemstack1, 0);
            }
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
        if (robot.laser.isVisible) {
            robot.laser.head.x = robot.field_70165_t;
            robot.laser.head.y = robot.field_70163_u;
            robot.laser.head.z = robot.field_70161_v;
            RenderLaser.doRenderLaser((TextureManager)this.field_76990_c.field_78724_e, (LaserData)robot.laser, (ResourceLocation)EntityLaser.LASER_TEXTURES[1]);
        }
        if (robot.getTexture() != null) {
            this.field_76990_c.field_78724_e.func_110577_a(robot.getTexture());
            float storagePercent = (float)robot.getBattery().getEnergyStored() / (float)robot.getBattery().getMaxEnergyStored();
            if (robot.field_70737_aN > 0) {
                GL11.glColor3f((float)1.0f, (float)0.6f, (float)0.6f);
                GL11.glRotatef((float)((float)robot.field_70737_aN * 0.01f), (float)0.0f, (float)0.0f, (float)1.0f);
            }
            this.doRenderRobot(0.0625f, this.field_76990_c.field_78724_e, storagePercent, robot.isActive());
        }
        for (ItemStack s : robot.getWearables()) {
            this.doRenderWearable(robot, this.field_76990_c.field_78724_e, s);
        }
        GL11.glPopMatrix();
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return ((EntityRobot)entity).getTexture();
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (RenderManager.field_78727_a == null || RenderManager.field_78727_a.field_78724_e == null) {
            return;
        }
        GL11.glPushMatrix();
        if (item.func_77973_b() == BuildCraftRobotics.robotItem) {
            ItemRobot robot = (ItemRobot)item.func_77973_b();
            RenderManager.field_78727_a.field_78724_e.func_110577_a(robot.getTextureRobot(item));
        }
        if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslated((double)0.0, (double)1.0, (double)0.7);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glScaled((double)0.6, (double)0.6, (double)0.6);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
        }
        this.doRenderRobot(0.0625f, RenderManager.field_78727_a.field_78724_e, 0.9f, false);
        GL11.glPopMatrix();
    }

    private void doRenderItem(ItemStack stack) {
        float renderScale = 0.5f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.28f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.func_92058_a(stack);
        this.customRenderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        GL11.glPopMatrix();
    }

    private void doRenderWearable(EntityRobot entity, TextureManager textureManager, ItemStack wearable) {
        if (wearable.func_77973_b() instanceof IRobotOverlayItem) {
            ((IRobotOverlayItem)wearable.func_77973_b()).renderRobotOverlay(wearable, textureManager);
        } else if (wearable.func_77973_b() instanceof ItemArmor) {
            GL11.glPushMatrix();
            GL11.glScalef((float)1.0125f, (float)1.0125f, (float)1.0125f);
            GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            int color = wearable.func_77973_b().func_82790_a(wearable, 0);
            if (color != 0xFFFFFF) {
                GL11.glPushAttrib((int)16384);
                GL11.glColor3ub((byte)((byte)(color >> 16)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
            }
            textureManager.func_110577_a(RenderBiped.getArmorResource((Entity)entity, (ItemStack)wearable, (int)0, null));
            ModelBiped armorModel = ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)wearable, (int)0, null);
            if (armorModel != null) {
                armorModel.func_78088_a((Entity)entity, 0.0f, 0.0f, 0.0f, -90.0f, 0.0f, 0.0625f);
                if (color != 0xFFFFFF) {
                    GL11.glPopAttrib();
                }
            } else {
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                this.helmetBox.func_78785_a(0.0625f);
                if (color != 0xFFFFFF) {
                    this.func_110776_a(RenderBiped.getArmorResource((Entity)entity, (ItemStack)wearable, (int)0, (String)"overlay"));
                    this.helmetBox.func_78785_a(0.0625f);
                    GL11.glPopAttrib();
                }
            }
            GL11.glPopMatrix();
        } else if (wearable.func_77973_b() instanceof ItemSkull) {
            this.doRenderSkull(wearable);
        }
    }

    private void doRenderSkull(ItemStack wearable) {
        GL11.glPushMatrix();
        GL11.glScalef((float)1.0125f, (float)1.0125f, (float)1.0125f);
        GameProfile gameProfile = null;
        if (wearable.func_77942_o()) {
            NBTTagCompound nbt = wearable.func_77978_p();
            if (nbt.func_74764_b("Name")) {
                gameProfile = this.gameProfileCache.get(nbt.func_74779_i("Name"));
            } else if (nbt.func_150297_b("SkullOwner", 10)) {
                gameProfile = NBTUtil.func_152459_a((NBTTagCompound)nbt.func_74775_l("SkullOwner"));
                nbt.func_74778_a("Name", gameProfile.getName());
                this.gameProfileCache.put(gameProfile.getName(), gameProfile);
            }
        }
        TileEntitySkullRenderer.field_147536_b.func_152674_a(-0.5f, -0.25f, -0.5f, 1, -90.0f, wearable.func_77960_j(), gameProfile);
        if (gameProfile != null) {
            GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.skullOverlayBox.func_78785_a(0.0625f);
        }
        GL11.glPopMatrix();
    }

    private void doRenderRobot(float factor, TextureManager texManager, float storagePercent, boolean isAsleep) {
        this.box.func_78785_a(factor);
        if (!isAsleep) {
            float lastBrightnessX = OpenGlHelper.lastBrightnessX;
            float lastBrightnessY = OpenGlHelper.lastBrightnessY;
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glEnable((int)3008);
            GL11.glDisable((int)2896);
            GL11.glBlendFunc((int)770, (int)771);
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)storagePercent);
            texManager.func_110577_a(overlay_red);
            this.box.func_78785_a(factor);
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            texManager.func_110577_a(overlay_cyan);
            this.box.func_78785_a(factor);
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lastBrightnessX, (float)lastBrightnessY);
        }
    }

    private float interpolateRotation(float prevRot, float rot, float partialTicks) {
        float angle;
        for (angle = rot - prevRot; angle < -180.0f; angle += 360.0f) {
        }
        while (angle >= 180.0f) {
            angle -= 360.0f;
        }
        return prevRot + partialTicks * angle;
    }
}

