/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.map;

import buildcraft.api.core.INBTStoreable;
import buildcraft.robotics.map.MapChunk;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IntHashMap;

public class MapRegion
implements INBTStoreable {
    private final IntHashMap chunks = new IntHashMap();
    private final int x;
    private final int z;

    public MapRegion(int x, int z) {
        this.x = x;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public boolean hasChunk(int x, int z) {
        return this.chunks.func_76037_b(z << 4 | x);
    }

    public MapChunk getChunk(int x, int z) {
        int id = z << 4 | x;
        MapChunk chunk = (MapChunk)this.chunks.func_76041_a(id);
        if (chunk == null) {
            chunk = new MapChunk(x, z);
            this.chunks.func_76038_a(id, (Object)chunk);
        }
        return chunk;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.chunks.func_76046_c();
        if (tag != null) {
            for (int i = 0; i < 256; ++i) {
                if (!tag.func_74764_b("r" + i)) continue;
                MapChunk chunk = new MapChunk(tag.func_74775_l("r" + i));
                this.chunks.func_76038_a(i, (Object)chunk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToNBT(NBTTagCompound tag) {
        for (int i = 0; i < 256; ++i) {
            MapChunk chunk = (MapChunk)this.chunks.func_76041_a(i);
            if (chunk == null) continue;
            NBTTagCompound chunkNBT = new NBTTagCompound();
            MapChunk mapChunk = chunk;
            synchronized (mapChunk) {
                chunk.writeToNBT(chunkNBT);
            }
            tag.func_74782_a("r" + i, (NBTBase)chunkNBT);
        }
    }
}

