/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.gui;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftRobotics;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.slots.SlotOutput;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.render.DynamicTextureBC;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.robotics.TileZonePlan;
import buildcraft.robotics.ZonePlan;
import buildcraft.robotics.gui.GuiZonePlan;
import buildcraft.robotics.map.MapWorld;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.material.MapColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public class ContainerZonePlan
extends BuildCraftContainer
implements ICommandReceiver {
    private static final int MAX_PACKET_LENGTH = 30000;
    public DynamicTextureBC mapTexture;
    public ZonePlan currentAreaSelection;
    public GuiZonePlan gui;
    private TileZonePlan map;

    public ContainerZonePlan(IInventory playerInventory, TileZonePlan iZonePlan) {
        super(0);
        this.map = iZonePlan;
        this.func_75146_a(new Slot((IInventory)iZonePlan, 0, 233, 9));
        this.func_75146_a((Slot)new SlotOutput((IInventory)iZonePlan, 1, 233, 57));
        this.func_75146_a(new Slot((IInventory)iZonePlan, 2, 8, 125));
        for (int l = 0; l < 3; ++l) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.func_75146_a(new Slot(playerInventory, k1 + l * 9 + 9, 88 + k1 * 18, 146 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot(playerInventory, i1, 88 + i1 * 18, 204));
        }
    }

    public TileZonePlan getTile() {
        return this.map;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void loadArea(final int index) {
        BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this, "loadArea", new CommandWriter(){

            public void write(ByteBuf data) {
                data.writeByte(index);
            }
        }));
    }

    public void saveArea(final int index) {
        BuildCraftCore.instance.sendToServer((Packet)new PacketCommand((Object)this, "saveArea", new CommandWriter(){

            public void write(ByteBuf data) {
                data.writeByte(index);
                ContainerZonePlan.this.currentAreaSelection.writeData(data);
            }
        }));
    }

    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        if (side.isClient()) {
            if ("areaLoaded".equals(command)) {
                this.currentAreaSelection = new ZonePlan();
                this.currentAreaSelection.readData(stream);
                this.gui.refreshSelectedArea();
            } else if ("receiveImage".equals(command)) {
                int size = stream.readUnsignedMedium();
                int pos = stream.readUnsignedMedium();
                for (int i = 0; i < Math.min(size - pos, 30000); ++i) {
                    this.mapTexture.colorMap[pos + i] = 0xFF000000 | MapColor.field_76281_a[stream.readUnsignedByte()].field_76291_p;
                }
            }
        } else if (side.isServer()) {
            if ("loadArea".equals(command)) {
                final short index = stream.readUnsignedByte();
                BuildCraftCore.instance.sendToPlayer((EntityPlayer)sender, (Packet)new PacketCommand((Object)this, "areaLoaded", new CommandWriter(){

                    public void write(ByteBuf data) {
                        ContainerZonePlan.this.map.selectArea(index).writeData(data);
                    }
                }));
            } else if ("saveArea".equals(command)) {
                short index = stream.readUnsignedByte();
                ZonePlan plan = new ZonePlan();
                plan.readData(stream);
                this.map.setArea(index, plan);
            } else if ("computeMap".equals(command)) {
                this.computeMap(stream.readInt(), stream.readInt(), stream.readUnsignedShort(), stream.readUnsignedShort(), stream.readFloat(), (EntityPlayer)sender);
            } else if ("setName".equals(command)) {
                this.map.mapName = NetworkUtils.readUTF((ByteBuf)stream);
            }
        }
    }

    private void computeMap(int cx, int cz, int width, int height, float blocksPerPixel, EntityPlayer player) {
        final byte[] textureData = new byte[width * height];
        MapWorld w = BuildCraftRobotics.manager.getWorld(this.map.func_145831_w());
        int startX = Math.round((float)cx - (float)width * blocksPerPixel / 2.0f);
        int startZ = Math.round((float)cz - (float)height * blocksPerPixel / 2.0f);
        int mapStartX = this.map.chunkStartX << 4;
        int mapStartZ = this.map.chunkStartZ << 4;
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int x = Math.round((float)startX + (float)i * blocksPerPixel);
                int z = Math.round((float)startZ + (float)j * blocksPerPixel);
                int ix = x - mapStartX;
                int iz = z - mapStartZ;
                if (ix < 0 || iz < 0 || ix >= 2048 || iz >= 2048) continue;
                textureData[i + j * width] = (byte)w.getColor(x, z);
            }
        }
        int len = 30000;
        for (int i = 0; i < textureData.length; i += 30000) {
            final int pos = i;
            BuildCraftCore.instance.sendToPlayer(player, (Packet)new PacketCommand((Object)this, "receiveImage", new CommandWriter(){

                public void write(ByteBuf data) {
                    data.writeMedium(textureData.length);
                    data.writeMedium(pos);
                    data.writeBytes(textureData, pos, Math.min(textureData.length - pos, 30000));
                }
            }));
        }
    }
}

