/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IWorldProperty;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.api.robots.ResourceId;
import buildcraft.api.robots.ResourceIdBlock;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.robotics.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotSearchAndGotoBlock;
import buildcraft.robotics.ai.AIRobotUseToolOnBlock;
import buildcraft.robotics.boards.BCBoardNBT;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class BoardRobotFarmer
extends RedstoneBoardRobot {
    private BlockIndex blockFound;

    public BoardRobotFarmer(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("farmer");
    }

    public void update() {
        final IWorldProperty isDirt = BuildCraftAPI.getWorldProperty((String)"dirt");
        if (this.robot.func_70694_bm() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new IStackFilter(){

                public boolean matches(ItemStack stack) {
                    return stack != null && stack.func_77973_b() instanceof ItemHoe;
                }
            }));
        } else {
            this.startDelegateAI(new AIRobotSearchAndGotoBlock(this.robot, false, new IBlockFilter(){

                public boolean matches(World world, int x, int y, int z) {
                    return isDirt.get(world, x, y, z) && !BoardRobotFarmer.this.robot.getRegistry().isTaken((ResourceId)new ResourceIdBlock(x, y, z)) && BoardRobotFarmer.this.isAirAbove(world, x, y, z);
                }
            }));
        }
    }

    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotSearchAndGotoBlock) {
            if (ai.success()) {
                this.blockFound = ((AIRobotSearchAndGotoBlock)ai).getBlockFound();
                this.startDelegateAI(new AIRobotUseToolOnBlock(this.robot, this.blockFound));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotFetchAndEquipItemStack) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotUseToolOnBlock) {
            this.releaseBlockFound();
        }
    }

    private void releaseBlockFound() {
        if (this.blockFound != null) {
            this.robot.getRegistry().release((ResourceId)new ResourceIdBlock(this.blockFound));
            this.blockFound = null;
        }
    }

    public void end() {
        this.releaseBlockFound();
    }

    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.func_74782_a("blockFound", (NBTBase)sub);
        }
    }

    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = new BlockIndex(nbt.func_74775_l("blockFound"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAirAbove(World world, int x, int y, int z) {
        World world2 = world;
        synchronized (world2) {
            return world.func_147437_c(x, y + 1, z);
        }
    }
}

