/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.builders.TileConstructionMarker;
import buildcraft.core.builders.BuildingItem;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.IBuildingItemsProvider;
import buildcraft.core.lib.inventory.filters.ArrayStackFilter;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.robotics.ai.AIRobotDisposeItems;
import buildcraft.robotics.ai.AIRobotGotoBlock;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotGotoStationAndLoad;
import buildcraft.robotics.ai.AIRobotRecharge;
import buildcraft.robotics.boards.BCBoardNBT;
import java.util.LinkedList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldSettings;

public class BoardRobotBuilder
extends RedstoneBoardRobot {
    private static final int MAX_RANGE_SQ = 12288;
    private TileConstructionMarker markerToBuild;
    private BuildingSlot currentBuildingSlot;
    private LinkedList<ItemStack> requirementsToLookFor;
    private int launchingDelay = 0;

    public BoardRobotBuilder(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("builder");
    }

    public void update() {
        if (this.launchingDelay > 0) {
            --this.launchingDelay;
            return;
        }
        if (this.markerToBuild == null) {
            this.markerToBuild = this.findClosestMarker();
            if (this.markerToBuild == null) {
                if (this.robot.containsItems()) {
                    this.startDelegateAI(new AIRobotDisposeItems(this.robot));
                } else {
                    this.startDelegateAI(new AIRobotGotoSleep(this.robot));
                }
                return;
            }
        }
        if (!this.markerToBuild.needsToBuild()) {
            this.markerToBuild = null;
            this.currentBuildingSlot = null;
            return;
        }
        if (this.currentBuildingSlot == null) {
            this.currentBuildingSlot = this.markerToBuild.bluePrintBuilder.reserveNextSlot(this.robot.field_70170_p);
            if (this.currentBuildingSlot == null) {
                this.launchingDelay = 40;
                return;
            }
        }
        if (this.requirementsToLookFor == null) {
            if (this.robot.containsItems()) {
                this.startDelegateAI(new AIRobotDisposeItems(this.robot));
            }
            this.requirementsToLookFor = this.robot.field_70170_p.func_72912_H().func_76077_q() != WorldSettings.GameType.CREATIVE ? this.currentBuildingSlot.getRequirements((IBuilderContext)this.markerToBuild.getContext()) : new LinkedList();
            if (this.requirementsToLookFor == null) {
                this.launchingDelay = 40;
                return;
            }
            if (this.requirementsToLookFor.size() > 4) {
                this.currentBuildingSlot.built = true;
                this.currentBuildingSlot = null;
                this.requirementsToLookFor = null;
                return;
            }
        }
        if (this.requirementsToLookFor.size() > 0) {
            this.startDelegateAI(new AIRobotGotoStationAndLoad(this.robot, (IStackFilter)new ArrayStackFilter(new ItemStack[]{this.requirementsToLookFor.getFirst()}), this.requirementsToLookFor.getFirst().field_77994_a));
            return;
        }
        if (this.requirementsToLookFor.size() == 0) {
            if (this.currentBuildingSlot.stackConsumed == null) {
                this.markerToBuild.bluePrintBuilder.useRequirements((IInventory)this.robot, this.currentBuildingSlot);
            }
            if (!this.hasEnoughEnergy()) {
                this.startDelegateAI(new AIRobotRecharge(this.robot));
            } else {
                this.startDelegateAI(new AIRobotGotoBlock(this.robot, (int)this.currentBuildingSlot.getDestination().x, (int)this.currentBuildingSlot.getDestination().y, (int)this.currentBuildingSlot.getDestination().z, 8.0));
            }
        }
    }

    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotGotoStationAndLoad) {
            if (ai.success()) {
                this.requirementsToLookFor.removeFirst();
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotGotoBlock) {
            if (this.markerToBuild == null || this.markerToBuild.bluePrintBuilder == null) {
                return;
            }
            if (!this.hasEnoughEnergy()) {
                this.startDelegateAI(new AIRobotRecharge(this.robot));
                return;
            }
            this.robot.getBattery().extractEnergy(this.currentBuildingSlot.getEnergyRequirement(), false);
            this.launchingDelay = this.currentBuildingSlot.getStacksToDisplay().size() * BuildingItem.ITEMS_SPACE;
            this.markerToBuild.bluePrintBuilder.buildSlot(this.robot.field_70170_p, (IBuildingItemsProvider)this.markerToBuild, this.currentBuildingSlot, this.robot.field_70165_t + 0.125, this.robot.field_70163_u + 0.125, this.robot.field_70161_v + 0.125);
            this.currentBuildingSlot = null;
            this.requirementsToLookFor = null;
        }
    }

    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        nbt.func_74768_a("launchingDelay", this.launchingDelay);
    }

    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        this.launchingDelay = nbt.func_74762_e("launchingDelay");
    }

    private TileConstructionMarker findClosestMarker() {
        double minDistance = Double.MAX_VALUE;
        TileConstructionMarker minMarker = null;
        IZone zone = this.robot.getZoneToWork();
        for (TileConstructionMarker marker : TileConstructionMarker.currentMarkers) {
            double dz;
            double dy;
            double dx;
            double distance;
            if (marker.func_145831_w() != this.robot.field_70170_p || !marker.needsToBuild() || zone != null && !zone.contains((double)marker.field_145851_c, (double)marker.field_145848_d, (double)marker.field_145849_e) || !((distance = (dx = this.robot.field_70165_t - (double)marker.field_145851_c) * dx + (dy = this.robot.field_70163_u - (double)marker.field_145848_d) * dy + (dz = this.robot.field_70161_v - (double)marker.field_145849_e) * dz) < minDistance)) continue;
            minMarker = marker;
            minDistance = distance;
        }
        if (minMarker != null && minDistance < 12288.0) {
            return minMarker;
        }
        return null;
    }

    private boolean hasEnoughEnergy() {
        return this.robot.getEnergy() - this.currentBuildingSlot.getEnergyRequirement() > 20000;
    }
}

