/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IZone;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.IStationFilter;
import buildcraft.robotics.statements.ActionStationForbidRobot;

public class AIRobotSearchStation
extends AIRobot {
    public DockingStation targetStation;
    private IStationFilter filter;
    private IZone zone;

    public AIRobotSearchStation(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotSearchStation(EntityRobotBase iRobot, IStationFilter iFilter, IZone iZone) {
        this(iRobot);
        this.filter = iFilter;
        this.zone = iZone;
    }

    public void start() {
        if (this.robot.getDockingStation() != null && this.filter.matches(this.robot.getDockingStation())) {
            this.targetStation = this.robot.getDockingStation();
            this.terminate();
            return;
        }
        double potentialStationDistance = 3.4028234663852886E38;
        DockingStation potentialStation = null;
        for (DockingStation station : this.robot.getRegistry().getStations()) {
            if (!station.isInitialized() || station.isTaken() && station.robotIdTaking() != this.robot.getRobotId() || this.zone != null && !this.zone.contains((double)station.x(), (double)station.y(), (double)station.z()) || !this.filter.matches(station) || ActionStationForbidRobot.isForbidden(station, this.robot)) continue;
            double dx = this.robot.field_70165_t - (double)station.x();
            double dy = this.robot.field_70163_u - (double)station.y();
            double dz = this.robot.field_70161_v - (double)station.z();
            double distance = dx * dx + dy * dy + dz * dz;
            if (potentialStation != null && !(distance < potentialStationDistance)) continue;
            potentialStation = station;
            potentialStationDistance = distance;
        }
        if (potentialStation != null) {
            this.targetStation = potentialStation;
        }
        this.terminate();
    }

    public void delegateAIEnded(AIRobot ai) {
        this.terminate();
    }

    public boolean success() {
        return this.targetStation != null;
    }
}

