/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.BlockUtils;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class AIRobotPumpBlock
extends AIRobot {
    private BlockIndex blockToPump;
    private long waited = 0L;
    private int pumped = 0;

    public AIRobotPumpBlock(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotPumpBlock(EntityRobotBase iRobot, BlockIndex iBlockToPump) {
        this(iRobot);
        this.blockToPump = iBlockToPump;
    }

    public void start() {
        this.robot.aimItemAt(this.blockToPump.x, this.blockToPump.y, this.blockToPump.z);
    }

    public void preempt(AIRobot ai) {
        super.preempt(ai);
    }

    public void update() {
        if (this.waited < 40L) {
            ++this.waited;
        } else {
            FluidStack fluidStack = BlockUtils.drainBlock((World)this.robot.field_70170_p, (int)this.blockToPump.x, (int)this.blockToPump.y, (int)this.blockToPump.z, (boolean)false);
            if (fluidStack != null && this.robot.fill(ForgeDirection.UNKNOWN, fluidStack, true) > 0) {
                BlockUtils.drainBlock((World)this.robot.field_70170_p, (int)this.blockToPump.x, (int)this.blockToPump.y, (int)this.blockToPump.z, (boolean)true);
            }
            this.terminate();
        }
    }

    public int getEnergyCost() {
        return 5;
    }

    public boolean success() {
        return this.pumped > 0;
    }
}

