/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.crops.CropManager;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.proxy.CoreProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class AIRobotPlant
extends AIRobot {
    private BlockIndex blockFound;
    private int delay = 0;

    public AIRobotPlant(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotPlant(EntityRobotBase iRobot, BlockIndex iBlockFound) {
        this(iRobot);
        this.blockFound = iBlockFound;
    }

    public void start() {
        this.robot.aimItemAt(this.blockFound.x, this.blockFound.y, this.blockFound.z);
        this.robot.setItemActive(true);
    }

    public void update() {
        if (this.blockFound == null) {
            this.setSuccess(false);
            this.terminate();
        }
        if (this.delay++ > 40) {
            EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.robot.field_70170_p).get();
            if (!CropManager.plantCrop((World)this.robot.field_70170_p, (EntityPlayer)player, (ItemStack)this.robot.func_70694_bm(), (int)this.blockFound.x, (int)this.blockFound.y, (int)this.blockFound.z)) {
                this.setSuccess(false);
            }
            if (this.robot.func_70694_bm().field_77994_a > 0) {
                BlockUtils.dropItem((WorldServer)((WorldServer)this.robot.field_70170_p), (int)MathHelper.func_76128_c((double)this.robot.field_70165_t), (int)MathHelper.func_76128_c((double)this.robot.field_70163_u), (int)MathHelper.func_76128_c((double)this.robot.field_70161_v), (int)6000, (ItemStack)this.robot.func_70694_bm());
            }
            this.robot.setItemInUse(null);
            this.terminate();
        }
    }

    public void end() {
        this.robot.setItemActive(false);
    }

    public boolean canLoadFromNBT() {
        return true;
    }

    public void writeSelfToNBT(NBTTagCompound nbt) {
        super.writeSelfToNBT(nbt);
        if (this.blockFound != null) {
            NBTTagCompound sub = new NBTTagCompound();
            this.blockFound.writeTo(sub);
            nbt.func_74782_a("blockFound", (NBTBase)sub);
        }
    }

    public void loadSelfFromNBT(NBTTagCompound nbt) {
        super.loadSelfFromNBT(nbt);
        if (nbt.func_74764_b("blockFound")) {
            this.blockFound = new BlockIndex(nbt.func_74775_l("blockFound"));
        }
    }
}

