/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.core.BCLog;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.robotics.ai.AIRobotRecharge;
import buildcraft.robotics.ai.AIRobotShutdown;

public class AIRobotMain
extends AIRobot {
    private AIRobot overridingAI;
    private int rechargeCooldown = 0;

    public AIRobotMain(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public int getEnergyCost() {
        return 0;
    }

    public void preempt(AIRobot ai) {
        if (!(this.robot.getEnergy() > 0 || this.robot.getDockingStation() != null && this.robot.getDockingStation().providesPower())) {
            if (!(ai instanceof AIRobotShutdown)) {
                BCLog.logger.info("Shutting down robot " + this.robot.toString() + " - no power");
                this.startDelegateAI(new AIRobotShutdown(this.robot));
            }
        } else if (this.robot.getEnergy() < 20000) {
            if (!(ai instanceof AIRobotRecharge) && !(ai instanceof AIRobotShutdown) && this.rechargeCooldown-- <= 0) {
                this.startDelegateAI(new AIRobotRecharge(this.robot));
            }
        } else if (!(ai instanceof AIRobotRecharge) && this.overridingAI != null && ai != this.overridingAI) {
            this.startDelegateAI(this.overridingAI);
        }
    }

    public void update() {
        RedstoneBoardRobot board = this.robot.getBoard();
        if (board != null) {
            this.startDelegateAI((AIRobot)board);
        }
    }

    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotRecharge && !ai.success()) {
            this.rechargeCooldown = 120;
        }
        if (ai == this.overridingAI) {
            this.overridingAI = null;
        }
    }

    public void setOverridingAI(AIRobot ai) {
        if (this.overridingAI == null) {
            this.overridingAI = ai;
        }
    }

    public AIRobot getOverridingAI() {
        return this.overridingAI;
    }

    public boolean canLoadFromNBT() {
        return true;
    }
}

