/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.robotics.statements.ActionRobotFilter;
import buildcraft.robotics.statements.ActionStationProvideItems;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class AIRobotLoad
extends AIRobot {
    public static final int ANY_QUANTITY = -1;
    private IStackFilter filter;
    private int quantity;
    private int waitedCycles = 0;

    public AIRobotLoad(EntityRobotBase iRobot) {
        super(iRobot);
    }

    public AIRobotLoad(EntityRobotBase iRobot, IStackFilter iFilter, int iQuantity) {
        super(iRobot);
        this.filter = iFilter;
        this.quantity = iQuantity;
    }

    public void update() {
        if (this.filter == null) {
            this.terminate();
            return;
        }
        ++this.waitedCycles;
        if (this.waitedCycles > 40) {
            this.setSuccess(AIRobotLoad.load(this.robot, this.robot.getDockingStation(), this.filter, this.quantity, true));
            this.terminate();
        }
    }

    public static ItemStack takeSingle(DockingStation station, IStackFilter filter, boolean doTake) {
        if (station == null) {
            return null;
        }
        IInventory tileInventory = station.getItemInput();
        if (tileInventory == null) {
            return null;
        }
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)tileInventory, (ForgeDirection)station.getItemInputSide())) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack) || !ActionStationProvideItems.canExtractItem(station, stack) || !ActionRobotFilter.canInteractWithItem(station, filter, ActionStationProvideItems.class)) continue;
            if (doTake) {
                stack = slot.decreaseStackInSlot(1);
            } else {
                stack = stack.func_77946_l();
                stack = stack.func_77979_a(1);
            }
            return stack;
        }
        return null;
    }

    public static boolean load(EntityRobotBase robot, DockingStation station, IStackFilter filter, int quantity, boolean doLoad) {
        if (station == null) {
            return false;
        }
        int loaded = 0;
        IInventory tileInventory = station.getItemInput();
        if (tileInventory == null) {
            return false;
        }
        for (IInvSlot slot : InventoryIterator.getIterable((IInventory)tileInventory, (ForgeDirection)station.getItemInputSide())) {
            ItemStack stack = slot.getStackInSlot();
            if (stack == null || !slot.canTakeStackFromSlot(stack) || !filter.matches(stack) || !ActionStationProvideItems.canExtractItem(station, stack) || !ActionRobotFilter.canInteractWithItem(station, filter, ActionStationProvideItems.class)) continue;
            ITransactor robotTransactor = Transactor.getTransactorFor((Object)robot);
            if (quantity == -1) {
                ItemStack added = robotTransactor.add(slot.getStackInSlot(), ForgeDirection.UNKNOWN, doLoad);
                if (doLoad) {
                    slot.decreaseStackInSlot(added.field_77994_a);
                }
                return added.field_77994_a > 0;
            }
            ItemStack toAdd = slot.getStackInSlot().func_77946_l();
            if (toAdd.field_77994_a > quantity - loaded) {
                toAdd.field_77994_a = quantity - loaded;
            }
            ItemStack added = robotTransactor.add(toAdd, ForgeDirection.UNKNOWN, doLoad);
            if (doLoad) {
                slot.decreaseStackInSlot(added.field_77994_a);
            }
            if (quantity - (loaded += added.field_77994_a) > 0) continue;
            return true;
        }
        return false;
    }

    public int getEnergyCost() {
        return 8;
    }
}

