/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.ai;

import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;

public abstract class AIRobotGoto
extends AIRobot {
    protected float nextX;
    protected float nextY;
    protected float nextZ;
    protected double dirX;
    protected double dirY;
    protected double dirZ;

    public AIRobotGoto(EntityRobotBase iRobot) {
        super(iRobot);
    }

    protected void setDestination(EntityRobotBase robot, float x, float y, float z) {
        this.nextX = x;
        this.nextY = y;
        this.nextZ = z;
        this.dirX = (double)this.nextX - robot.field_70165_t;
        this.dirY = (double)this.nextY - robot.field_70163_u;
        this.dirZ = (double)this.nextZ - robot.field_70161_v;
        double magnitude = Math.sqrt(this.dirX * this.dirX + this.dirY * this.dirY + this.dirZ * this.dirZ);
        if (magnitude != 0.0) {
            this.dirX /= magnitude;
            this.dirY /= magnitude;
            this.dirZ /= magnitude;
        } else {
            this.dirX = 0.0;
            this.dirY = 0.0;
            this.dirZ = 0.0;
        }
        robot.field_70159_w = this.dirX / 10.0;
        robot.field_70181_x = this.dirY / 10.0;
        robot.field_70179_y = this.dirZ / 10.0;
    }

    public int getEnergyCost() {
        return 3;
    }
}

