/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.api.boards.RedstoneBoardNBT;
import buildcraft.api.boards.RedstoneBoardRegistry;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.DockingStation;
import buildcraft.api.robots.IDockingStationProvider;
import buildcraft.api.transport.IPipeTile;
import buildcraft.robotics.ItemRobot;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public final class RobotUtils {
    private RobotUtils() {
    }

    public static List<DockingStation> getStations(Object tile) {
        DockingStation station;
        ArrayList<DockingStation> stations = new ArrayList<DockingStation>();
        if (tile instanceof IDockingStationProvider && (station = ((IDockingStationProvider)tile).getStation()) != null) {
            stations.add(station);
        }
        if (tile instanceof IPipeTile) {
            IPipeTile pipeTile = (IPipeTile)tile;
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                IDockingStationProvider pluggable;
                DockingStation station2;
                if (!(pipeTile.getPipePluggable(d) instanceof IDockingStationProvider) || (station2 = (pluggable = (IDockingStationProvider)pipeTile.getPipePluggable(d)).getStation()) == null) continue;
                stations.add(station2);
            }
        }
        return stations;
    }

    public static RedstoneBoardRobotNBT getNextBoard(ItemStack stack, boolean reverse) {
        Collection boards = RedstoneBoardRegistry.instance.getAllBoardNBTs();
        if (stack == null || !(stack.func_77973_b() instanceof ItemRobot)) {
            if (!reverse) {
                return (RedstoneBoardRobotNBT)Iterables.getFirst((Iterable)boards, null);
            }
            return (RedstoneBoardRobotNBT)Iterables.getLast((Iterable)boards, null);
        }
        if (reverse) {
            boards = Lists.reverse((List)((List)boards));
        }
        boolean found = false;
        for (RedstoneBoardNBT boardNBT : boards) {
            if (found) {
                return (RedstoneBoardRobotNBT)boardNBT;
            }
            if (ItemRobot.getRobotNBT(stack) != boardNBT) continue;
            found = true;
        }
        return null;
    }
}

