/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.core;

import biomesoplenty.api.BOPObfuscationHelper;
import biomesoplenty.api.biome.BOPOverriddenBiome;
import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.common.biome.end.BiomeGenSpectralGarden;
import biomesoplenty.common.biome.nether.BiomeGenBoneyard;
import biomesoplenty.common.biome.nether.BiomeGenCorruptedSands;
import biomesoplenty.common.biome.nether.BiomeGenPhantasmagoricInferno;
import biomesoplenty.common.biome.nether.BiomeGenPolarChasm;
import biomesoplenty.common.biome.nether.BiomeGenUndergarden;
import biomesoplenty.common.biome.nether.BiomeGenVisceralHeap;
import biomesoplenty.common.biome.overridden.BiomeGenBOPBirchForest;
import biomesoplenty.common.biome.overridden.BiomeGenBOPDesert;
import biomesoplenty.common.biome.overridden.BiomeGenBOPExtremeHills;
import biomesoplenty.common.biome.overridden.BiomeGenBOPForest;
import biomesoplenty.common.biome.overridden.BiomeGenBOPHell;
import biomesoplenty.common.biome.overridden.BiomeGenBOPIcePlains;
import biomesoplenty.common.biome.overridden.BiomeGenBOPJungle;
import biomesoplenty.common.biome.overridden.BiomeGenBOPMesa;
import biomesoplenty.common.biome.overridden.BiomeGenBOPMushroomIsland;
import biomesoplenty.common.biome.overridden.BiomeGenBOPOcean;
import biomesoplenty.common.biome.overridden.BiomeGenBOPPlains;
import biomesoplenty.common.biome.overridden.BiomeGenBOPRiver;
import biomesoplenty.common.biome.overridden.BiomeGenBOPRoofedForest;
import biomesoplenty.common.biome.overridden.BiomeGenBOPSavanna;
import biomesoplenty.common.biome.overridden.BiomeGenBOPSwamp;
import biomesoplenty.common.biome.overridden.BiomeGenBOPTaiga;
import biomesoplenty.common.biome.overworld.BiomeGenAlps;
import biomesoplenty.common.biome.overworld.BiomeGenArctic;
import biomesoplenty.common.biome.overworld.BiomeGenBambooForest;
import biomesoplenty.common.biome.overworld.BiomeGenBayou;
import biomesoplenty.common.biome.overworld.BiomeGenBog;
import biomesoplenty.common.biome.overworld.BiomeGenBorealForest;
import biomesoplenty.common.biome.overworld.BiomeGenBrushland;
import biomesoplenty.common.biome.overworld.BiomeGenCanyon;
import biomesoplenty.common.biome.overworld.BiomeGenChaparral;
import biomesoplenty.common.biome.overworld.BiomeGenCherryBlossomGrove;
import biomesoplenty.common.biome.overworld.BiomeGenConiferousForest;
import biomesoplenty.common.biome.overworld.BiomeGenConiferousForestSnow;
import biomesoplenty.common.biome.overworld.BiomeGenCrag;
import biomesoplenty.common.biome.overworld.BiomeGenDeadForest;
import biomesoplenty.common.biome.overworld.BiomeGenDeadSwamp;
import biomesoplenty.common.biome.overworld.BiomeGenDeciduousForest;
import biomesoplenty.common.biome.overworld.BiomeGenDenseForest;
import biomesoplenty.common.biome.overworld.BiomeGenEucalyptusForest;
import biomesoplenty.common.biome.overworld.BiomeGenFen;
import biomesoplenty.common.biome.overworld.BiomeGenFlowerField;
import biomesoplenty.common.biome.overworld.BiomeGenFrostForest;
import biomesoplenty.common.biome.overworld.BiomeGenFungiForest;
import biomesoplenty.common.biome.overworld.BiomeGenGarden;
import biomesoplenty.common.biome.overworld.BiomeGenGrassland;
import biomesoplenty.common.biome.overworld.BiomeGenGrove;
import biomesoplenty.common.biome.overworld.BiomeGenHeathland;
import biomesoplenty.common.biome.overworld.BiomeGenHighland;
import biomesoplenty.common.biome.overworld.BiomeGenJadeCliffs;
import biomesoplenty.common.biome.overworld.BiomeGenLandOfLakes;
import biomesoplenty.common.biome.overworld.BiomeGenLavenderFields;
import biomesoplenty.common.biome.overworld.BiomeGenLushDesert;
import biomesoplenty.common.biome.overworld.BiomeGenLushSwamp;
import biomesoplenty.common.biome.overworld.BiomeGenMapleWoods;
import biomesoplenty.common.biome.overworld.BiomeGenMarsh;
import biomesoplenty.common.biome.overworld.BiomeGenMeadow;
import biomesoplenty.common.biome.overworld.BiomeGenMoor;
import biomesoplenty.common.biome.overworld.BiomeGenMountain;
import biomesoplenty.common.biome.overworld.BiomeGenMysticGrove;
import biomesoplenty.common.biome.overworld.BiomeGenOminousWoods;
import biomesoplenty.common.biome.overworld.BiomeGenOrchard;
import biomesoplenty.common.biome.overworld.BiomeGenOriginValley;
import biomesoplenty.common.biome.overworld.BiomeGenOutback;
import biomesoplenty.common.biome.overworld.BiomeGenPrairie;
import biomesoplenty.common.biome.overworld.BiomeGenRainforest;
import biomesoplenty.common.biome.overworld.BiomeGenRedwoodForest;
import biomesoplenty.common.biome.overworld.BiomeGenSacredSprings;
import biomesoplenty.common.biome.overworld.BiomeGenSeasonalForest;
import biomesoplenty.common.biome.overworld.BiomeGenShield;
import biomesoplenty.common.biome.overworld.BiomeGenShrubland;
import biomesoplenty.common.biome.overworld.BiomeGenSludgepit;
import biomesoplenty.common.biome.overworld.BiomeGenSteppe;
import biomesoplenty.common.biome.overworld.BiomeGenTemperateRainforest;
import biomesoplenty.common.biome.overworld.BiomeGenThicket;
import biomesoplenty.common.biome.overworld.BiomeGenTropicalRainforest;
import biomesoplenty.common.biome.overworld.BiomeGenTundra;
import biomesoplenty.common.biome.overworld.BiomeGenWasteland;
import biomesoplenty.common.biome.overworld.BiomeGenWetland;
import biomesoplenty.common.biome.overworld.BiomeGenWoodland;
import biomesoplenty.common.biome.overworld.BiomeGenXericShrubland;
import biomesoplenty.common.biome.overworld.ocean.BiomeGenCoralReef;
import biomesoplenty.common.biome.overworld.ocean.BiomeGenKelpForest;
import biomesoplenty.common.biome.overworld.sub.BiomeGenAlpsForest;
import biomesoplenty.common.biome.overworld.sub.BiomeGenCanyonRavine;
import biomesoplenty.common.biome.overworld.sub.BiomeGenGlacier;
import biomesoplenty.common.biome.overworld.sub.BiomeGenLandOfLakesMarsh;
import biomesoplenty.common.biome.overworld.sub.BiomeGenMangrove;
import biomesoplenty.common.biome.overworld.sub.BiomeGenMeadowForest;
import biomesoplenty.common.biome.overworld.sub.BiomeGenOasis;
import biomesoplenty.common.biome.overworld.sub.BiomeGenQuagmire;
import biomesoplenty.common.biome.overworld.sub.BiomeGenScrubland;
import biomesoplenty.common.biome.overworld.sub.BiomeGenSeasonalForestClearing;
import biomesoplenty.common.biome.overworld.sub.BiomeGenSilkglades;
import biomesoplenty.common.biome.overworld.sub.BiomeGenSpruceWoods;
import biomesoplenty.common.biome.overworld.sub.BiomeGenTropics;
import biomesoplenty.common.biome.overworld.sub.BiomeGenVolcano;
import biomesoplenty.common.biome.overworld.tech.BiomeGenDryRiver;
import biomesoplenty.common.biome.overworld.tech.BiomeGenLushRiver;
import biomesoplenty.common.configuration.BOPConfigurationBiomeGen;
import biomesoplenty.common.configuration.BOPConfigurationBiomeWeights;
import biomesoplenty.common.configuration.BOPConfigurationIDs;
import biomesoplenty.common.configuration.BOPConfigurationMisc;
import biomesoplenty.common.helpers.BOPReflectionHelper;
import biomesoplenty.common.integration.ATGIntegration;
import biomesoplenty.common.utils.BOPLogger;
import biomesoplenty.common.world.BOPBiomeManager;
import biomesoplenty.common.world.WorldTypeBOP;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import org.apache.logging.log4j.Level;

public class BOPBiomes {
    public static WorldTypeBOP worldTypeBOP;
    public static BiomeGenBase onlyBiome;

    public static void init() {
        try {
            BOPConfigurationIDs.config.load();
            BOPConfigurationBiomeGen.config.load();
            BOPConfigurationBiomeWeights.config.load();
            BOPBiomes.registerBiomes();
            BOPBiomes.registerOverriddenBiomes();
        }
        catch (Exception e) {
            BOPLogger.log(Level.ERROR, "Biomes O Plenty has had a problem loading its configuration", e);
        }
        finally {
            if (BOPConfigurationIDs.config.hasChanged()) {
                BOPConfigurationIDs.config.save();
            }
            if (BOPConfigurationBiomeGen.config.hasChanged()) {
                BOPConfigurationBiomeGen.config.save();
            }
            if (BOPConfigurationBiomeWeights.config.hasChanged()) {
                BOPConfigurationBiomeWeights.config.save();
            }
        }
        BOPBiomes.addBiomesToDictionary();
        BOPBiomes.disableRivers();
        BOPBiomes.addSpawnBiomes();
    }

    private static void registerBiomes() {
        BOPCBiomes.alps = BOPBiomes.registerOverworldBiome(BiomeGenAlps.class, "Alps", 3, 5);
        BOPCBiomes.arctic = BOPBiomes.registerOverworldBiome(BiomeGenArctic.class, "Arctic", 3, 10);
        BOPCBiomes.bambooForest = BOPBiomes.registerOverworldBiome(BiomeGenBambooForest.class, "Bamboo Forest", 0, 5);
        BOPCBiomes.bayou = BOPBiomes.registerOverworldBiome(BiomeGenBayou.class, "Bayou", 1, 10);
        BOPCBiomes.bog = BOPBiomes.registerOverworldBiome(BiomeGenBog.class, "Bog", 2, 7);
        BOPCBiomes.borealForest = BOPBiomes.registerOverworldBiome(BiomeGenBorealForest.class, "Boreal Forest", 2, 10);
        BOPCBiomes.brushland = BOPBiomes.registerOverworldBiome(BiomeGenBrushland.class, "Brushland", 0, 10);
        BOPCBiomes.canyon = BOPBiomes.registerOverworldBiome(BiomeGenCanyon.class, "Canyon", 0, 5);
        BOPCBiomes.chaparral = BOPBiomes.registerOverworldBiome(BiomeGenChaparral.class, "Chaparral", 1, 10);
        BOPCBiomes.cherryBlossomGrove = BOPBiomes.registerOverworldBiome(BiomeGenCherryBlossomGrove.class, "Cherry Blossom Grove", 2, 3);
        BOPCBiomes.coniferousForest = BOPBiomes.registerOverworldBiome(BiomeGenConiferousForest.class, "Coniferous Forest", 2, 10);
        BOPCBiomes.snowyConiferousForest = BOPBiomes.registerOverworldBiome(BiomeGenConiferousForestSnow.class, "Snowy Coniferous Forest", 3, 10);
        BOPCBiomes.crag = BOPBiomes.registerOverworldBiome(BiomeGenCrag.class, "Crag", 2, 3);
        BOPCBiomes.deadForest = BOPBiomes.registerOverworldBiome(BiomeGenDeadForest.class, "Dead Forest", 2, 5);
        BOPCBiomes.deadSwamp = BOPBiomes.registerOverworldBiome(BiomeGenDeadSwamp.class, "Dead Swamp", 2, 5);
        BOPCBiomes.deciduousForest = BOPBiomes.registerOverworldBiome(BiomeGenDeciduousForest.class, "Deciduous Forest", 1, 10);
        BOPCBiomes.denseForest = BOPBiomes.registerOverworldBiome(BiomeGenDenseForest.class, "Dense Forest", 1, 7);
        BOPCBiomes.eucalyptusForest = BOPBiomes.registerOverworldBiome(BiomeGenEucalyptusForest.class, "Eucalyptus Forest", 0, 7);
        BOPCBiomes.fen = BOPBiomes.registerOverworldBiome(BiomeGenFen.class, "Fen", 2, 10);
        BOPCBiomes.flowerField = BOPBiomes.registerOverworldBiome(BiomeGenFlowerField.class, "Flower Field", 1, 3);
        BOPCBiomes.frostForest = BOPBiomes.registerOverworldBiome(BiomeGenFrostForest.class, "Frost Forest", 3, 7);
        BOPCBiomes.fungiForest = BOPBiomes.registerOverworldBiome(BiomeGenFungiForest.class, "Fungi Forest", 1, 3);
        BOPCBiomes.garden = BOPBiomes.registerOverworldBiome(BiomeGenGarden.class, "Garden", 2, 3);
        BOPCBiomes.grassland = BOPBiomes.registerOverworldBiome(BiomeGenGrassland.class, "Grassland", 2, 10);
        BOPCBiomes.grove = BOPBiomes.registerOverworldBiome(BiomeGenGrove.class, "Grove", 2, 7);
        BOPCBiomes.heathland = BOPBiomes.registerOverworldBiome(BiomeGenHeathland.class, "Heathland", 1, 10);
        BOPCBiomes.highland = BOPBiomes.registerOverworldBiome(BiomeGenHighland.class, "Highland", 1, 7);
        BOPCBiomes.jadeCliffs = BOPBiomes.registerOverworldBiome(BiomeGenJadeCliffs.class, "Jade Cliffs", 1, 3);
        BOPCBiomes.landOfLakes = BOPBiomes.registerOverworldBiome(BiomeGenLandOfLakes.class, "Land of Lakes", 2, 5);
        BOPCBiomes.lavenderFields = BOPBiomes.registerOverworldBiome(BiomeGenLavenderFields.class, "Lavender Fields", 1, 3);
        BOPCBiomes.lushDesert = BOPBiomes.registerOverworldBiome(BiomeGenLushDesert.class, "Lush Desert", 0, 5);
        BOPCBiomes.lushSwamp = BOPBiomes.registerOverworldBiome(BiomeGenLushSwamp.class, "Lush Swamp", 1, 10);
        BOPCBiomes.mapleWoods = BOPBiomes.registerOverworldBiome(BiomeGenMapleWoods.class, "Maple Woods", 2, 10);
        BOPCBiomes.marsh = BOPBiomes.registerOverworldBiome(BiomeGenMarsh.class, "Marsh", 1, 7);
        BOPCBiomes.meadow = BOPBiomes.registerOverworldBiome(BiomeGenMeadow.class, "Meadow", 2, 10);
        BOPCBiomes.moor = BOPBiomes.registerOverworldBiome(BiomeGenMoor.class, "Moor", 2, 7);
        BOPCBiomes.mountain = BOPBiomes.registerOverworldBiome(BiomeGenMountain.class, "Mountain", 1, 10);
        BOPCBiomes.mysticGrove = BOPBiomes.registerOverworldBiome(BiomeGenMysticGrove.class, "Mystic Grove", 2, 2);
        BOPCBiomes.ominousWoods = BOPBiomes.registerOverworldBiome(BiomeGenOminousWoods.class, "Ominous Woods", 2, 2);
        BOPCBiomes.orchard = BOPBiomes.registerOverworldBiome(BiomeGenOrchard.class, "Orchard", 1, 3);
        BOPCBiomes.originValley = BOPBiomes.registerOverworldBiome(BiomeGenOriginValley.class, "Origin Valley", 1, 1);
        BOPCBiomes.outback = BOPBiomes.registerOverworldBiome(BiomeGenOutback.class, "Outback", 0, 7);
        BOPCBiomes.prairie = BOPBiomes.registerOverworldBiome(BiomeGenPrairie.class, "Prairie", 1, 10);
        BOPCBiomes.rainforest = BOPBiomes.registerOverworldBiome(BiomeGenRainforest.class, "Rainforest", 1, 7);
        BOPCBiomes.redwoodForest = BOPBiomes.registerOverworldBiome(BiomeGenRedwoodForest.class, "Redwood Forest", 1, 5);
        BOPCBiomes.sacredSprings = BOPBiomes.registerOverworldBiome(BiomeGenSacredSprings.class, "Sacred Springs", 1, 3);
        BOPCBiomes.seasonalForest = BOPBiomes.registerOverworldBiome(BiomeGenSeasonalForest.class, "Seasonal Forest", 2, 10);
        BOPCBiomes.shield = BOPBiomes.registerOverworldBiome(BiomeGenShield.class, "Shield", 2, 7);
        BOPCBiomes.shrubland = BOPBiomes.registerOverworldBiome(BiomeGenShrubland.class, "Shrubland", 2, 10);
        BOPCBiomes.sludgepit = BOPBiomes.registerOverworldBiome(BiomeGenSludgepit.class, "Sludgepit", 1, 5);
        BOPCBiomes.steppe = BOPBiomes.registerOverworldBiome(BiomeGenSteppe.class, "Steppe", 0, 5);
        BOPCBiomes.temperateRainforest = BOPBiomes.registerOverworldBiome(BiomeGenTemperateRainforest.class, "Temperate Rainforest", 2, 10);
        BOPCBiomes.thicket = BOPBiomes.registerOverworldBiome(BiomeGenThicket.class, "Thicket", 2, 5);
        BOPCBiomes.tropicalRainforest = BOPBiomes.registerOverworldBiome(BiomeGenTropicalRainforest.class, "Tropical Rainforest", 0, 5);
        BOPCBiomes.tundra = BOPBiomes.registerOverworldBiome(BiomeGenTundra.class, "Tundra", 3, 7);
        BOPCBiomes.wasteland = BOPBiomes.registerOverworldBiome(BiomeGenWasteland.class, "Wasteland", 0, 3);
        BOPCBiomes.wetland = BOPBiomes.registerOverworldBiome(BiomeGenWetland.class, "Wetland", 1, 7);
        BOPCBiomes.woodland = BOPBiomes.registerOverworldBiome(BiomeGenWoodland.class, "Woodland", 2, 10);
        BOPCBiomes.xericShrubland = BOPBiomes.registerOverworldBiome(BiomeGenXericShrubland.class, "Xeric Shrubland", 0, 5);
        BOPCBiomes.coralReef = BOPBiomes.registerOverworldSubBiome(BiomeGenCoralReef.class, "Coral Reef", 10, BiomeGenBase.field_76771_b);
        BOPCBiomes.kelpForest = BOPBiomes.registerOverworldSubBiome(BiomeGenKelpForest.class, "Kelp Forest", 10, BiomeGenBase.field_76771_b);
        BOPCBiomes.tropics = BOPBiomes.registerOverworldSubBiome(BiomeGenTropics.class, "Tropics", 10, BiomeGenBase.field_150575_M);
        BOPCBiomes.volcano = BOPBiomes.registerOverworldSubBiome(BiomeGenVolcano.class, "Volcano", 10, BiomeGenBase.field_150575_M);
        BOPCBiomes.mangrove = BOPBiomes.registerOverworldSubBiome(BiomeGenMangrove.class, "Mangrove", 10, BiomeGenBase.field_150575_M);
        BOPCBiomes.alpsForest = BOPBiomes.registerOverworldSubBiome(BiomeGenAlpsForest.class, "Alps Forest", 10, BOPCBiomes.alps);
        BOPCBiomes.canyonRavine = BOPBiomes.registerOverworldSubBiome(BiomeGenCanyonRavine.class, "Canyon Ravine", 10, BOPCBiomes.canyon);
        BOPCBiomes.glacier = BOPBiomes.registerOverworldSubBiome(BiomeGenGlacier.class, "Glacier", 10, BOPCBiomes.arctic);
        BOPCBiomes.landOfLakesMarsh = BOPBiomes.registerOverworldSubBiome(BiomeGenLandOfLakesMarsh.class, "Land of Lakes Marsh", 10, BOPCBiomes.landOfLakes);
        BOPCBiomes.meadowForest = BOPBiomes.registerOverworldSubBiome(BiomeGenMeadowForest.class, "Meadow Forest", 10, BOPCBiomes.meadow);
        BOPCBiomes.oasis = BOPBiomes.registerOverworldSubBiome(BiomeGenOasis.class, "Oasis", 10, BiomeGenBase.field_76769_d);
        BOPCBiomes.quagmire = BOPBiomes.registerOverworldSubBiome(BiomeGenQuagmire.class, "Quagmire", 10, BOPCBiomes.sludgepit);
        BOPCBiomes.scrubland = BOPBiomes.registerOverworldSubBiome(BiomeGenScrubland.class, "Scrubland", 10, BiomeGenBase.field_150588_X);
        BOPCBiomes.seasonalForestClearing = BOPBiomes.registerOverworldSubBiome(BiomeGenSeasonalForestClearing.class, "Seasonal Forest Clearing", 10, BOPCBiomes.seasonalForest);
        BOPCBiomes.silkglades = BOPBiomes.registerOverworldSubBiome(BiomeGenSilkglades.class, "Silkglades", 10, BOPCBiomes.sludgepit);
        BOPCBiomes.spruceWoods = BOPBiomes.registerOverworldSubBiome(BiomeGenSpruceWoods.class, "Spruce Woods", 10, BiomeGenBase.field_76767_f);
        BOPCBiomes.corruptedSands = BOPBiomes.registerNetherBiome(BiomeGenCorruptedSands.class, "Corrupted Sands", 10);
        BOPCBiomes.phantasmagoricInferno = BOPBiomes.registerNetherBiome(BiomeGenPhantasmagoricInferno.class, "Phantasmagoric Inferno", 10);
        BOPCBiomes.boneyard = BOPBiomes.registerNetherBiome(BiomeGenBoneyard.class, "Boneyard", 10);
        BOPCBiomes.visceralHeap = BOPBiomes.registerNetherBiome(BiomeGenVisceralHeap.class, "Visceral Heap", 10);
        BOPCBiomes.undergarden = BOPBiomes.registerNetherBiome(BiomeGenUndergarden.class, "Undergarden", 10);
        BOPCBiomes.polarChasm = BOPBiomes.registerNetherBiome(BiomeGenPolarChasm.class, "Polar Chasm", 1);
        BOPCBiomes.spectralGarden = BOPBiomes.registerEndBiome(BiomeGenSpectralGarden.class, "Spectral Garden", 10);
        BOPCBiomes.lushRiver = BOPBiomes.registerOverworldRiverBiome(BiomeGenLushRiver.class, "Lush River", BOPCBiomes.lushSwamp, BOPCBiomes.lavenderFields, BOPCBiomes.flowerField, BOPCBiomes.bambooForest, BOPCBiomes.cherryBlossomGrove, BOPCBiomes.lushDesert, BOPCBiomes.meadow, BOPCBiomes.spruceWoods, BOPCBiomes.rainforest, BiomeGenBase.field_76767_f, BiomeGenBase.field_76785_t, BiomeGenBase.field_76782_w, BiomeGenBase.field_150574_L, BiomeGenBase.field_76792_x);
        BOPCBiomes.dryRiver = BOPBiomes.registerOverworldRiverBiome(BiomeGenDryRiver.class, "Dry River", BOPCBiomes.outback, BOPCBiomes.steppe, BiomeGenBase.field_76769_d, BiomeGenBase.field_76786_s);
    }

    private static void registerOverriddenBiomes() {
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPBirchForest.class, BOPObfuscationHelper.birchForest, BOPObfuscationHelper.birchForestHills);
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPDesert.class, BOPObfuscationHelper.desert, BOPObfuscationHelper.desertHills);
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPExtremeHills.class, BOPObfuscationHelper.extremeHills, BOPObfuscationHelper.extremeHillsEdge);
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPForest.class, BOPObfuscationHelper.forest, BOPObfuscationHelper.forestHills);
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPIcePlains.class, new String[][]{BOPObfuscationHelper.icePlains});
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPJungle.class, BOPObfuscationHelper.jungle, BOPObfuscationHelper.jungleEdge, BOPObfuscationHelper.jungleHills);
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPMesa.class, BOPObfuscationHelper.mesa, BOPObfuscationHelper.mesaPlateau, BOPObfuscationHelper.mesaPlateau_F);
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPMushroomIsland.class, BOPObfuscationHelper.mushroomIsland, BOPObfuscationHelper.mushroomIslandShore);
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPOcean.class, new String[][]{BOPObfuscationHelper.ocean});
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPPlains.class, new String[][]{BOPObfuscationHelper.plains});
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPRiver.class, new String[][]{BOPObfuscationHelper.river});
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPRoofedForest.class, new String[][]{BOPObfuscationHelper.roofedForest});
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPSavanna.class, BOPObfuscationHelper.savanna, BOPObfuscationHelper.savannaPlateau);
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPSwamp.class, new String[][]{BOPObfuscationHelper.swampland});
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPTaiga.class, BOPObfuscationHelper.taiga, BOPObfuscationHelper.taigaHills, BOPObfuscationHelper.coldTaiga, BOPObfuscationHelper.coldTaigaHills);
        BOPBiomes.registerOverriddenBiome(BiomeGenBOPHell.class, new String[][]{BOPObfuscationHelper.hell});
    }

    private static void addBiomesToDictionary() {
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.alps, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.COLD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.alpsForest, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.arctic, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DEAD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.bambooForest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.bayou, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WATER, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.bog, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.DEAD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.boneyard, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.borealForest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.brushland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.canyon, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.canyonRavine, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.chaparral, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.cherryBlossomGrove, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.coniferousForest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.snowyConiferousForest, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.corruptedSands, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SPOOKY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.crag, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.deadForest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SPOOKY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.deadSwamp, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.SPOOKY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.deciduousForest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.DRY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.fen, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.WET);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.flowerField, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.frostForest, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD, BiomeDictionary.Type.SPARSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.fungiForest, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.garden, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.glacier, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.COLD, BiomeDictionary.Type.DEAD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.grassland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.grove, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.heathland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SAVANNA);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.highland, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.SPARSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.jadeCliffs, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.lavenderFields, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SPARSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.lushDesert, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DRY, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.HOT);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.lushSwamp, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WATER, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.mangrove, BiomeDictionary.Type.WATER, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.mapleWoods, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.COLD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.marsh, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.meadow, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.meadowForest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.moor, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WET);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.mountain, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.mysticGrove, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.oasis, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.coralReef, BiomeDictionary.Type.WATER);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.kelpForest, BiomeDictionary.Type.WATER, BiomeDictionary.Type.FOREST);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.ominousWoods, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.DEAD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.orchard, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.SPARSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.outback, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.phantasmagoricInferno, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.SPOOKY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.prairie, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.SPARSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.quagmire, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.WET, BiomeDictionary.Type.DEAD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.rainforest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.redwoodForest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.sacredSprings, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.scrubland, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.seasonalForest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.shield, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WATER, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.WET);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.shrubland, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DRY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.silkglades, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.sludgepit, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.WET, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.spruceWoods, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.steppe, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SANDY, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.DEAD);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.temperateRainforest, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.WET, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.thicket, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.tropicalRainforest, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.HOT, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.tropics, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.WATER, BiomeDictionary.Type.WET, BiomeDictionary.Type.LUSH);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.tundra, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPARSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.undergarden, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.JUNGLE, BiomeDictionary.Type.SPOOKY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.visceralHeap, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.SPOOKY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.volcano, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.wasteland, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPARSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.wetland, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.LUSH, BiomeDictionary.Type.WET, BiomeDictionary.Type.DENSE);
        BOPBiomes.registerBiomeToDictionary(BOPCBiomes.woodland, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DRY, BiomeDictionary.Type.DENSE);
    }

    private static void registerBiomeToDictionary(BiomeGenBase biome, BiomeDictionary.Type ... types) {
        if (biome != null) {
            BiomeDictionary.registerBiomeType((BiomeGenBase)biome, (BiomeDictionary.Type[])types);
        }
    }

    private static void disableRivers() {
        BOPBiomes.disableRiver(BOPCBiomes.quagmire);
        BOPBiomes.disableRiver(BOPCBiomes.sludgepit);
        BOPBiomes.disableRiver(BOPCBiomes.silkglades);
        BOPBiomes.disableRiver(BOPCBiomes.wetland);
        BOPBiomes.disableRiver(BOPCBiomes.wasteland);
        BOPBiomes.disableRiver(BOPCBiomes.tropicalRainforest);
        BOPBiomes.disableRiver(BOPCBiomes.originValley);
        BOPBiomes.disableRiver(BOPCBiomes.ominousWoods);
        BOPBiomes.disableRiver(BOPCBiomes.mysticGrove);
        BOPBiomes.disableRiver(BOPCBiomes.deadSwamp);
        BOPBiomes.disableRiver(BOPCBiomes.crag);
        BOPBiomes.disableRiver(BOPCBiomes.bayou);
    }

    private static void addSpawnBiomes() {
        if (BOPConfigurationMisc.onlySpawnOnBeaches) {
            BOPBiomes.clearAllSpawnBiomes();
            BOPBiomes.addSpawnBiome(BiomeGenBase.field_76787_r);
            BOPBiomes.addSpawnBiome(BiomeGenBase.field_150576_N);
            BOPBiomes.addSpawnBiome(BiomeGenBase.field_150577_O);
        } else {
            for (List<BiomeManager.BiomeEntry> biomeList : BOPBiomeManager.overworldBiomes) {
                for (BiomeManager.BiomeEntry entry : biomeList) {
                    BOPBiomes.addSpawnBiome(entry.biome);
                }
            }
        }
    }

    private static BiomeGenBase registerOverworldBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName, int temperatureType, int weight) {
        if (BOPBiomeManager.overworldBiomes[temperatureType] == null) {
            BOPBiomeManager.overworldBiomes[temperatureType] = new ArrayList<BiomeManager.BiomeEntry>();
        }
        return BOPBiomeManager.createAndRegisterBiome(biomeClass, "Overworld", biomeName, BOPBiomeManager.overworldBiomes[temperatureType], weight);
    }

    private static BiomeGenBase registerOverworldSubBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName, int weight, BiomeGenBase ... parents) {
        BiomeGenBase biome = BOPBiomeManager.createBiome(biomeClass, biomeName);
        if (biome != null) {
            BiomeManager.BiomeEntry entry = new BiomeManager.BiomeEntry(biome, weight);
            if (BOPConfigurationBiomeGen.config.get("Overworld (Sub) Biomes To Generate", biome.field_76791_y, true).getBoolean(false)) {
                for (BiomeGenBase parent : parents) {
                    if (parent == null) continue;
                    if (BOPBiomeManager.overworldSubBiomes[parent.field_76756_M] == null) {
                        BOPBiomeManager.overworldSubBiomes[parent.field_76756_M] = new ArrayList<BiomeManager.BiomeEntry>();
                    }
                    BOPBiomeManager.overworldSubBiomes[parent.field_76756_M].add(entry);
                    ATGIntegration.registerATGSubBiome(parent, biome);
                }
            }
            return biome;
        }
        return null;
    }

    private static BiomeGenBase registerOverworldRiverBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName, BiomeGenBase ... parents) {
        BiomeGenBase biome = BOPBiomeManager.createBiome(biomeClass, biomeName);
        if (biome != null && BOPConfigurationBiomeGen.config.get("Overworld (River) Biomes To Generate", biome.field_76791_y, true).getBoolean(false)) {
            for (BiomeGenBase parent : parents) {
                if (parent == null) continue;
                BOPBiomeManager.overworldRiverBiomes[parent.field_76756_M] = biome;
            }
        }
        return null;
    }

    private static void disableRiver(BiomeGenBase biome) {
        BOPBiomeManager.overworldRiverBiomes[biome.field_76756_M] = biome;
    }

    private static BiomeGenBase registerNetherBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName, int weight) {
        return BOPBiomeManager.createAndRegisterBiome(biomeClass, "Nether", biomeName, BOPBiomeManager.netherBiomes, weight);
    }

    private static BiomeGenBase registerEndBiome(Class<? extends BiomeGenBase> biomeClass, String biomeName, int weight) {
        return BOPBiomeManager.createAndRegisterBiome(biomeClass, "End", biomeName, BOPBiomeManager.endBiomes, weight);
    }

    private static void registerOverriddenBiome(Class<? extends BOPOverriddenBiome> biomeClass, String[] ... overriddenBiomeNames) {
        for (String[] overriddenBiomeName : overriddenBiomeNames) {
            Field field = BOPReflectionHelper.removeFinal(BiomeGenBase.class, null, overriddenBiomeName);
            try {
                BiomeGenBase biomeToOverride = (BiomeGenBase)field.get(null);
                if (biomeToOverride == null) continue;
                BiomeGenBase newBiome = BOPBiomeManager.createBiome(biomeClass, biomeToOverride.field_76791_y, biomeToOverride.field_76756_M);
                if (!BOPConfigurationBiomeGen.config.get("Vanilla Biomes To Override", biomeToOverride.field_76791_y, true).getBoolean(false)) continue;
                field.set(null, newBiome);
                BiomeGenBase.func_150565_n()[biomeToOverride.field_76756_M] = newBiome;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void addSpawnBiome(BiomeGenBase biome) {
        BiomeManager.addSpawnBiome((BiomeGenBase)biome);
    }

    public static void clearAllSpawnBiomes() {
        WorldChunkManager.allowedBiomes.clear();
    }

    static {
        onlyBiome = null;
    }
}

