/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.network.PacketEntityUpdate;
import buildcraft.core.lib.network.PacketGuiReturn;
import buildcraft.core.lib.network.PacketGuiWidget;
import buildcraft.core.lib.network.PacketNBT;
import buildcraft.core.lib.network.PacketSide;
import buildcraft.core.lib.network.PacketTileState;
import buildcraft.core.lib.network.PacketTileUpdate;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.proxy.CoreProxy;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.util.AttributeKey;
import java.lang.ref.WeakReference;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@ChannelHandler.Sharable
public final class ChannelHandler
extends MessageToMessageCodec<FMLProxyPacket, Packet> {
    public static final Marker SUSPICIOUS_PACKETS = MarkerManager.getMarker((String)"SuspiciousPackets");
    public static final AttributeKey<ThreadLocal<WeakReference<FMLProxyPacket>>> INBOUNDPACKETTRACKER = new AttributeKey("bc:inboundpacket");
    private TByteObjectHashMap<DiscriminatorData> discriminators = new TByteObjectHashMap();
    private TObjectByteHashMap<Class<? extends Packet>> types = new TObjectByteHashMap();
    private int maxDiscriminator;

    public ChannelHandler() {
        this.addDiscriminator(0, PacketTileUpdate.class, PacketSide.CLIENT_ONLY);
        this.addDiscriminator(1, PacketTileState.class, PacketSide.CLIENT_ONLY);
        this.addDiscriminator(2, PacketNBT.class, PacketSide.BOTH_SIDES);
        this.addDiscriminator(4, PacketGuiReturn.class, PacketSide.SERVER_ONLY);
        this.addDiscriminator(5, PacketGuiWidget.class, PacketSide.CLIENT_ONLY);
        this.addDiscriminator(7, PacketCommand.class, PacketSide.BOTH_SIDES);
        this.addDiscriminator(8, PacketEntityUpdate.class, PacketSide.CLIENT_ONLY);
        this.maxDiscriminator = 9;
    }

    public byte getDiscriminator(Class<? extends Packet> clazz) {
        return this.types.get(clazz);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        ctx.attr(INBOUNDPACKETTRACKER).set(new ThreadLocal());
    }

    public ChannelHandler addDiscriminator(int discriminator, Class<? extends Packet> type) {
        return this.addDiscriminator(discriminator, type, PacketSide.BOTH_SIDES);
    }

    public ChannelHandler addDiscriminator(int discriminator, Class<? extends Packet> packetType, PacketSide packetSide) {
        this.discriminators.put((byte)discriminator, (Object)new DiscriminatorData(packetType, packetSide));
        this.types.put(packetType, (byte)discriminator);
        return this;
    }

    protected void logSuspiciousPacketWrongSide(EntityPlayer player, String packetType) {
        BCLog.logger.info(SUSPICIOUS_PACKETS, "Player {} tried to send packet of type {} to invalid side {}. This could be a false warning due to custom mod/addon interference, or an indicator of hacking/cheating activity.", new Object[]{player.func_146103_bH(), packetType, player instanceof EntityPlayerMP ? Side.SERVER : Side.CLIENT});
    }

    protected void logSuspiciousPacketWrongDiscriminator(EntityPlayer player, int typeId) {
        BCLog.logger.info(SUSPICIOUS_PACKETS, "Player {} tried to send packet of invalid type {}. This could be a false warning due to custom mod/addon interference, or an indicator of hacking/cheating activity.", new Object[]{player.func_146103_bH(), typeId});
    }

    protected void encode(ChannelHandlerContext ctx, Packet msg, List<Object> out) throws Exception {
        FMLProxyPacket old;
        ByteBuf buffer = Unpooled.buffer();
        Class<?> clazz = msg.getClass();
        byte discriminator = this.types.get(clazz);
        buffer.writeByte((int)discriminator);
        msg.writeData(buffer);
        FMLProxyPacket proxy = new FMLProxyPacket(buffer.copy(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        WeakReference ref = (WeakReference)((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).get();
        FMLProxyPacket fMLProxyPacket = old = ref == null ? null : (FMLProxyPacket)ref.get();
        if (old != null) {
            proxy.setDispatcher(old.getDispatcher());
        }
        out.add(proxy);
    }

    protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
        PacketSide expectedSide;
        this.testMessageValidity(msg);
        ByteBuf payload = msg.payload();
        byte discriminator = payload.readByte();
        DiscriminatorData data = (DiscriminatorData)this.discriminators.get(discriminator);
        if (data == null) {
            INetHandler handler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(handler);
            this.logSuspiciousPacketWrongDiscriminator(player, discriminator);
            return;
        }
        PacketSide packetSide = expectedSide = ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get() == Side.CLIENT ? PacketSide.CLIENT_ONLY : PacketSide.SERVER_ONLY;
        if (!data.getSide().contains(expectedSide)) {
            INetHandler handler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(handler);
            this.logSuspiciousPacketWrongSide(player, data.getDiscriminator().getSimpleName());
        } else {
            Packet newMsg = data.getDiscriminator().newInstance();
            ((ThreadLocal)ctx.attr(INBOUNDPACKETTRACKER).get()).set(new WeakReference<FMLProxyPacket>(msg));
            newMsg.readData(payload.slice());
            out.add(newMsg);
        }
    }

    protected void testMessageValidity(FMLProxyPacket msg) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        FMLLog.log((Level)Level.ERROR, (Throwable)cause, (String)"BC ChannelHandler exception caught", (Object[])new Object[0]);
        super.exceptionCaught(ctx, cause);
    }

    public void registerPacketType(Class<? extends Packet> packetType) {
        this.registerPacketType(packetType, PacketSide.BOTH_SIDES);
    }

    public void registerPacketType(Class<? extends Packet> packetType, PacketSide packetSide) {
        this.addDiscriminator(this.maxDiscriminator++, packetType, packetSide);
    }

    private static final class DiscriminatorData {
        private final Class<? extends Packet> discriminator;
        private final PacketSide side;

        DiscriminatorData(Class<? extends Packet> discriminator, PacketSide side) {
            this.discriminator = discriminator;
            this.side = side;
        }

        public Class<? extends Packet> getDiscriminator() {
            return this.discriminator;
        }

        public PacketSide getSide() {
            return this.side;
        }
    }
}

