/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.api.tiles.IHasWork;
import buildcraft.core.lib.gui.ContainerDummy;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.lib.utils.CraftingUtils;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.silicon.ItemPackage;
import buildcraft.silicon.TileLaserTableBase;
import cpw.mods.fml.common.FMLCommonHandler;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileStampingTable
extends TileLaserTableBase
implements IHasWork,
ISidedInventory {
    private static final int[] SLOTS = Utils.createSlotArray((int)0, (int)5);
    private SlotCrafting craftSlot;
    private final LocalInventoryCrafting crafting = new LocalInventoryCrafting();

    public boolean canUpdate() {
        return !FMLCommonHandler.instance().getEffectiveSide().isClient();
    }

    public WeakReference<EntityPlayer> getInternalPlayer() {
        return CoreProxy.proxy.getBuildCraftPlayer((WorldServer)this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    private void handleLeftoverItems(IInventory items) {
        for (int i = 0; i < items.func_70302_i_(); ++i) {
            if (items.func_70301_a(i) == null) continue;
            ItemStack output = items.func_70301_a(i);
            if (output.field_77994_a <= 0) {
                items.func_70299_a(i, null);
                continue;
            }
            boolean inserted = false;
            for (int j = 2; j <= 4; ++j) {
                ItemStack target = this.func_70301_a(j);
                if (target == null || target.field_77994_a <= 0) {
                    this.func_70299_a(j, output);
                    inserted = true;
                    break;
                }
                output.field_77994_a -= StackHelper.mergeStacks((ItemStack)output, (ItemStack)target, (boolean)true);
                if (output.field_77994_a != 0) continue;
                inserted = true;
                break;
            }
            if (!inserted && output.field_77994_a > 0) {
                output.field_77994_a -= Utils.addToRandomInventoryAround((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (ItemStack)output);
                if (output.field_77994_a > 0) {
                    InvUtils.dropItems((World)this.field_145850_b, (ItemStack)output, (int)this.field_145851_c, (int)(this.field_145848_d + 1), (int)this.field_145849_e);
                }
            }
            items.func_70299_a(i, null);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.getEnergy() >= this.getRequiredEnergy() && this.getEnergy() > 0) {
            IRecipe recipe;
            int i;
            ItemStack input = this.func_70301_a(0);
            if (input == null) {
                return;
            }
            EntityPlayer internalPlayer = (EntityPlayer)this.getInternalPlayer().get();
            if (this.craftSlot == null) {
                this.craftSlot = new SlotCrafting(internalPlayer, (IInventory)this.crafting, (IInventory)this, 1, 0, 0);
            }
            if (input.func_77973_b() instanceof ItemPackage) {
                NBTTagCompound tag = NBTUtils.getItemData((ItemStack)input);
                for (i = 0; i < 9; ++i) {
                    if (tag.func_74764_b("item" + i)) {
                        ItemStack is = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item" + i));
                        if (is != null) {
                            this.crafting.func_70299_a(i, is);
                            continue;
                        }
                        return;
                    }
                    this.crafting.func_70299_a(i, null);
                }
            } else {
                ItemStack input2 = input.func_77946_l();
                input2.field_77994_a = 1;
                this.crafting.func_70299_a(0, input2);
                for (i = 1; i < 9; ++i) {
                    this.crafting.func_70299_a(i, null);
                }
            }
            ItemStack result = (recipe = this.crafting.findRecipe()) != null ? recipe.func_77572_b((InventoryCrafting)this.crafting).func_77946_l() : null;
            this.addEnergy(-this.getRequiredEnergy());
            if (result != null) {
                this.craftSlot.func_82870_a(internalPlayer, result);
                this.handleLeftoverItems((IInventory)this.crafting);
                this.handleLeftoverItems((IInventory)internalPlayer.field_71071_by);
                for (int i2 = 1; i2 <= 4; ++i2) {
                    ItemStack inside = this.inv.func_70301_a(i2);
                    if (inside == null || inside.field_77994_a <= 0) {
                        this.inv.func_70299_a(i2, result.func_77946_l());
                        result.field_77994_a = 0;
                        break;
                    }
                    if (!StackHelper.canStacksMerge((ItemStack)inside, (ItemStack)result)) continue;
                    result.field_77994_a -= StackHelper.mergeStacks((ItemStack)result, (ItemStack)inside, (boolean)true);
                    if (result.field_77994_a == 0) break;
                }
                if (result.field_77994_a > 0) {
                    EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.7, (double)this.field_145849_e + 0.5, result.func_77946_l());
                    this.field_145850_b.func_72838_d((Entity)entityitem);
                    result.field_77994_a = 0;
                }
                this.func_70298_a(0, 1);
            } else {
                ItemStack outputSlot = this.func_70301_a(1);
                if (outputSlot == null) {
                    this.func_70299_a(1, this.func_70301_a(0));
                    this.func_70299_a(0, null);
                }
            }
        }
    }

    @Override
    public int getRequiredEnergy() {
        ItemStack stack = this.func_70301_a(0);
        ItemStack output = this.func_70301_a(1);
        if (output != null && output.field_77994_a == output.func_77976_d()) {
            return 0;
        }
        if (stack != null && stack.func_77973_b() != null) {
            if (stack.func_77973_b() instanceof ItemPackage) {
                return 400 * NBTUtils.getItemData((ItemStack)stack).func_150296_c().size();
            }
            return 400;
        }
        return 0;
    }

    public boolean hasWork() {
        return this.getRequiredEnergy() > 0;
    }

    @Override
    public boolean canCraft() {
        return this.hasWork();
    }

    public int func_70302_i_() {
        return 5;
    }

    public String func_145825_b() {
        return StringUtils.localize((String)"tile.stampingTableBlock.name");
    }

    public boolean func_145818_k_() {
        return false;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0;
    }

    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 1;
    }

    private class LocalInventoryCrafting
    extends InventoryCrafting {
        public LocalInventoryCrafting() {
            super((Container)new ContainerDummy(), 3, 3);
        }

        private IRecipe findRecipe() {
            return CraftingUtils.findMatchingRecipe((InventoryCrafting)this, (World)TileStampingTable.this.field_145850_b);
        }
    }
}

