/*
 * Decompiled with CFR 0.152.
 */
package eureka.gui.Widgets;

import eureka.api.IEurekaInfo;
import eureka.core.Logger;
import eureka.core.RenderUtils;
import eureka.core.TextGetter;
import eureka.gui.GuiEngineeringDiary;
import eureka.gui.Widgets.WidgetBase;
import java.util.List;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class WidgetChapter
extends WidgetBase {
    private final ResourceLocation UNSELECTED = new ResourceLocation("eureka:textures/gui/pieces/chapterUnselected.png");
    private final ResourceLocation SELECTED = new ResourceLocation("eureka:textures/gui/pieces/chapterSelected.png");
    private final IEurekaInfo chapter;
    private boolean selected;

    public WidgetChapter(int x, int y, int width, int height, GuiEngineeringDiary gui, IEurekaInfo chapter) {
        super(x, y, width, height, gui);
        this.chapter = chapter;
        this.selected = false;
    }

    @Override
    public void render(int mouseX, int mouseY) {
        if (!this.enabled) {
            return;
        }
        RenderUtils.drawImage(this.selected ? this.SELECTED : this.UNSELECTED, this.x, this.y, this.width, this.height);
        this.renderItem(this.chapter.getDisplayStack(), this.x + 3, this.y + 4);
    }

    private void renderItem(ItemStack stack, int x, int y) {
        RenderItem itemRender = new RenderItem();
        try {
            itemRender.func_82406_b(this.gui.getFontRendererObj(), RenderUtils.textureManager(), stack, x, y);
        }
        catch (Throwable e) {
            try {
                itemRender.func_77015_a(this.gui.getFontRendererObj(), RenderUtils.textureManager(), stack, x, y);
            }
            catch (Throwable e2) {
                Logger.error("Failed to render item for chapter " + this.chapter.getName());
            }
        }
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3008);
    }

    public WidgetChapter setSelected(boolean selected) {
        this.selected = selected;
        return this;
    }

    public IEurekaInfo getChapter() {
        return this.chapter;
    }

    @Override
    public void addTooltip(List<String> list, boolean shift) {
        list.add(TextGetter.getTitle(this.chapter.getName()));
    }
}

