/*
 * Decompiled with CFR 0.152.
 */
package eureka.core;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import eureka.api.EurekaAPI;
import eureka.api.IEurekaInfo;
import eureka.networking.MessageResearchFinished;
import eureka.networking.PacketHandler;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerResearch
implements IExtendedEntityProperties {
    private static final String EXT_PROP_NAME = "EurekaPlayerResearch";
    private final EntityPlayer player;
    private HashMap<String, Integer> progressList = new HashMap();
    private HashMap<String, Boolean> finished = new HashMap();

    public PlayerResearch(EntityPlayer player) {
        this.player = player;
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new PlayerResearch(player));
    }

    public static PlayerResearch get(EntityPlayer player) {
        return (PlayerResearch)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        for (IEurekaInfo research : EurekaAPI.API.getAllKeys()) {
            if (!this.progressList.containsKey(research.getName())) {
                this.progressList.put(research.getName(), 0);
            }
            tag.func_74768_a(research.getName() + "Progress", this.progressList.get(research.getName()).intValue());
            if (!this.finished.containsKey(research.getName())) continue;
            tag.func_74757_a(research.getName() + "Finished", this.finished.get(research.getName()).booleanValue());
        }
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)tag);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound tag = compound.func_74775_l(EXT_PROP_NAME);
        this.loadOldResearch(compound);
        for (IEurekaInfo research : EurekaAPI.API.getAllKeys()) {
            this.finished.put(research.getName(), tag.func_74767_n(research.getName() + "Finished"));
            if (this.isFinished(research.getName())) {
                this.progressList.put(research.getName(), research.getMaxProgress());
                continue;
            }
            this.progressList.put(research.getName(), tag.func_74762_e(research.getName() + "Progress"));
        }
    }

    public void loadOldResearch(NBTTagCompound compound) {
        if (compound.func_74775_l("ForgeData") != null && compound.func_74775_l("ForgeData").func_74775_l("PlayerPersisted") != null) {
            NBTTagCompound tag = compound.func_74775_l("ForgeData").func_74775_l("PlayerPersisted");
            for (IEurekaInfo research : EurekaAPI.API.getAllKeys()) {
                this.progressList.put(research.getName(), tag.func_74762_e(research.getName() + "Progress"));
                this.finished.put(research.getName(), tag.func_74767_n(research.getName() + "Finished"));
                tag.func_82580_o(research.getName() + "Progress");
                tag.func_82580_o(research.getName() + "Finished");
            }
        }
    }

    public void init(Entity entity, World world) {
    }

    public void makeProgress(String key) {
        try {
            List<String> keys = EurekaAPI.API.getInfo(key).getRequiredResearch();
            for (String checkKey : keys) {
                if (this.isFinished(checkKey)) continue;
                return;
            }
            if (!this.progressList.containsKey(key)) {
                this.progressList.put(key, 0);
            }
            int progress = this.progressList.get(key);
            if (++progress >= EurekaAPI.API.getMaxProgress(key)) {
                progress = EurekaAPI.API.getMaxProgress(key);
                if (this.finished != null && key != null && !this.finished.get(key).booleanValue()) {
                    PacketHandler.instance.sendTo((IMessage)new MessageResearchFinished(key), (EntityPlayerMP)this.player);
                    this.finished.remove(key);
                    this.finished.put(key, true);
                }
            }
            this.progressList.remove(key);
            this.progressList.put(key, progress);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void completeResearch(String key) {
        List<String> keys = EurekaAPI.API.getInfo(key).getRequiredResearch();
        for (String checkKey : keys) {
            if (this.isFinished(checkKey)) continue;
            return;
        }
        this.player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"Eureka")));
        this.finished.remove(key);
        this.finished.put(key, true);
        this.progressList.remove(key);
        this.progressList.put(key, EurekaAPI.API.getMaxProgress(key));
    }

    public void revertProgress(String key) {
        if (this.isFinished(key)) {
            return;
        }
        try {
            if (!this.progressList.containsKey(key)) {
                this.progressList.put(key, 0);
                return;
            }
            int progress = this.progressList.get(key);
            if (--progress < 0) {
                return;
            }
            this.progressList.remove(key);
            this.progressList.put(key, progress);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean isFinished(String key) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return true;
        }
        if (!this.finished.containsKey(key)) {
            if (EurekaAPI.API.keyRegistered(key)) {
                this.finished.put(key, false);
            } else {
                return true;
            }
        }
        return this.finished.get(key);
    }

    public int getProgress(String key) {
        if (this.progressList.containsKey(key)) {
            return this.progressList.get(key);
        }
        return 0;
    }

    public void copy(PlayerResearch research) {
        this.progressList = research.progressList;
        this.finished = research.finished;
    }

    public void overrideProgress(String key, int progress) {
        this.progressList.remove(key);
        this.progressList.put(key, progress);
    }

    public void overrideFinished(String key, boolean finished) {
        this.finished.remove(key);
        this.finished.put(key, finished);
    }
}

