/*
 * Decompiled with CFR 0.152.
 */
package eureka.core;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import eureka.Eureka;
import eureka.api.EnumProgressOptions;
import eureka.api.EurekaAPI;
import eureka.core.EurekaAPIImplementation;
import eureka.core.PlayerResearch;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;

public class EventHandler {
    @SubscribeEvent
    public void onEntityConstruction(EntityEvent.EntityConstructing event) {
        if (event.entity instanceof EntityPlayer && PlayerResearch.get((EntityPlayer)event.entity) == null) {
            PlayerResearch.register((EntityPlayer)event.entity);
        }
    }

    @SubscribeEvent
    public void onClone(PlayerEvent.Clone event) {
        PlayerResearch.get(event.entityPlayer).copy(PlayerResearch.get(event.original));
    }

    @SubscribeEvent
    public void playerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.getEntityData().func_74775_l("PlayerPersisted").func_74764_b("bookRecieved") && Eureka.giveBook) {
            for (int slot = 0; slot < event.player.field_71071_by.func_70302_i_(); ++slot) {
                if (event.player.field_71071_by.func_70301_a(slot) != null) continue;
                event.player.field_71071_by.func_70299_a(slot, new ItemStack((Item)Eureka.engineeringDiary));
                NBTTagCompound tag = event.player.getEntityData().func_74775_l("PlayerPersisted");
                tag.func_74757_a("bookRecieved", true);
                event.player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)tag);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerUsesBlock(PlayerInteractEvent event) {
        String key = "";
        if (event.world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.entityPlayer;
        PlayerResearch research = PlayerResearch.get(player);
        if (player.func_71045_bC() != null) {
            key = EurekaAPI.API.getKey(player.func_71045_bC());
        }
        if (!research.isFinished(key) && !key.equals("")) {
            ItemStack stack = player.func_71045_bC().func_77946_l();
            stack.field_77994_a = 1;
            this.dropItems(event.world, event.x, event.y, event.z, EurekaAPI.API.getDrops(stack));
            if (event.entityPlayer.func_71045_bC().field_77994_a > 1) {
                --event.entityPlayer.func_71045_bC().field_77994_a;
            } else {
                event.entityPlayer.func_71028_bD();
            }
            event.setCanceled(true);
        }
        if ((key = EurekaAPI.API.getKey(event.world.func_147439_a(event.x, event.y, event.z))) != null && !key.equals("") && !research.isFinished(key)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void bucketFill(FillBucketEvent event) {
        this.makeProgress(EnumProgressOptions.FILL_BUCKET, PlayerResearch.get(event.entityPlayer), null);
    }

    @SubscribeEvent
    public void onTeleport(EnderTeleportEvent event) {
        if (event.entityLiving != null && event.entityLiving instanceof EntityPlayer) {
            this.makeProgress(EnumProgressOptions.ENDER_TELEPORT, PlayerResearch.get((EntityPlayer)event.entityLiving), null);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void blockPlacement(BlockEvent.PlaceEvent event) {
        String key = EurekaAPI.API.getKey(event.block);
        PlayerResearch research = PlayerResearch.get(event.player);
        if (!research.isFinished(key) && !key.equals("")) {
            this.dropItems(event.world, event.x, event.y, event.z, EurekaAPI.API.getDrops(new ItemStack(event.block)));
            event.world.func_147449_b(event.x, event.y, event.z, Blocks.field_150350_a);
        }
        this.makeProgress(EnumProgressOptions.PLACE_BLOCK, research, event.block);
        this.makeProgress(EnumProgressOptions.PLACE_ANY_BLOCK, research, null);
    }

    @SubscribeEvent
    public void onCrafted(PlayerEvent.ItemCraftedEvent event) {
        PlayerResearch research = PlayerResearch.get(event.player);
        Item obj = event.crafting.func_77973_b();
        if (event.crafting.func_77973_b() instanceof ItemBlock) {
            obj = ((ItemBlock)event.crafting.func_77973_b()).field_150939_a;
        }
        this.makeProgress(EnumProgressOptions.CRAFTING, research, obj);
        this.makeProgress(EnumProgressOptions.CRAFT_ANYTHING, research, null);
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        PlayerResearch research = PlayerResearch.get(event.getPlayer());
        this.revertProgress(EnumProgressOptions.PLACE_BLOCK, research, event.block);
        this.makeProgress(EnumProgressOptions.BREAK_BLOCK, research, event.block);
        this.makeProgress(EnumProgressOptions.BREAK_ANY_BLOCK, research, null);
    }

    private void dropItems(World world, int x, int y, int z, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (world.field_72995_K || stack == null || stack.field_77994_a <= 0 || stack.func_77973_b() == null) continue;
            float rx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float ry = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            float rz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), stack.func_77946_l());
            float factor = 0.05f;
            entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
            entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + 0.2000000029802322;
            entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
        }
    }

    private void makeProgress(EnumProgressOptions option, PlayerResearch research, Object arg) {
        if (research == null) {
            return;
        }
        EurekaAPIImplementation imp = (EurekaAPIImplementation)EurekaAPI.API;
        for (String key : imp.getKeysforProgress(option, arg)) {
            research.makeProgress(key);
        }
    }

    private void revertProgress(EnumProgressOptions option, PlayerResearch research, Object arg) {
        if (research == null) {
            return;
        }
        EurekaAPIImplementation imp = (EurekaAPIImplementation)EurekaAPI.API;
        for (String key : imp.getKeysforProgress(option, arg)) {
            research.revertProgress(key);
        }
    }
}

